;------------------------------------------------------------------------------
; File Name   :	c:\MyUser\hobby3\z9001_idas\IDAS.KCC
; Format      :	Binary file
; Base Address:	0000h Range: 0380h - 1C80h Loaded length: 1900h
; Segment type:	Pure code

;reass V.Pohlers 13.11.2025
;------------------------------------------------------------------------------

		cpu	z80

;AS-Funktionen
hi              function x,(x>>8)&255
lo              function x, x&255

;------------------------------------------------------------------------------
; defines
;------------------------------------------------------------------------------
;ROM-Version: anderer Speicherbereich Prgm, anderer Defaultwert f. MC-Bereich
;UZ-Version: lngere Startmeldung, gendertes outa
;patch_dos: (vp) Anpassung zweier Adr. im FCB wg. Nutzung durch Disk-OS

romversion	equ	0		; RAM-Version R0122
;romversion	equ	1		; ROM-Version IDAS-Modul

codebase	equ	0		; Version robotron
;codebase	equ	1		; UZ-Version (orig. nur als ROM-Version)

patch_dos	equ	0		; orignal
;patch_dos	equ	1		; Anpassung Disk-OS

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------


; OS
unk_0:          equ 0000h
BOS:		equ 0005h
DMA:            equ 001Bh
EOR:         	equ 0036h
FCB:            equ 005Ch
FTYP:         	equ 0064h
BLNR:           equ 006Bh
AADR:           equ 006Dh
EADR:           equ 006Fh
SADR:           equ 0071h
	if patch_dos=0
BUFADR:         equ 0073h		;das ist eigentlich SBY im OS!
unk_75:         equ 0075h
	else
BUFADR:         equ 0073h+7		;vp: wird im Disk-OS genutzt, daher hier ein Versatz+7
unk_75:         equ 0075h+7		;vp: wird im Disk-OS genutzt, daher hier ein Versatz+7
	endif
unk_79:         equ 0079h
CONBU:          equ 0080h
INTLN:          equ 0100h

; BOS-Rufe
CONSI:		 equ 1			; Eingabe eines	Zeichens von CONST
CONSO:		 equ 2			; Ausgabe eines	Zeichens zu CONST
PRNST:		 equ 9			; Ausgabe einer	Zeichenkette zu	CONST
RCONB:		 equ 0Ah		; Eingabe einer	Zeichenkette von CONST
CSTS:		 equ 0Bh		; Abfrage Status CONST
OPENR:		 equ 0Dh		; Erffnen Kassette lesen
;CLOSR:		 equ 0Eh		; Abschlieen Kassette lesen
OPENW:		 equ 0Fh		; Erffnen Kassette schreiben
CLOSW:		 equ 10h		; Abschlieen Kassette schreiben
READS:		 equ 14h		; Lesen	eines Blockes von Kassette
WRITS:		 equ 15h		; Schreiben eines Blockes auf Kassette

; RAM
stack:          equ 032Bh
device:         equ 032Dh
unk_32F:        equ 032Fh
unk_330:        equ 0330h
unk_332:        equ 0332h 		; lower adr of register stack area
; Adr. vgl Push-Reihenfolge in loc_50A
;0349	sp	regsv 348
;0347	af'
;0345	bc'
;0343	de'
;0341	hl'
;033f	af
;033d	bc
;033b	de
;0339	hl
;0337	ix
;0335	iy
;0333	i(f)
regsv:          equ 0348h 		; hi adr of register stack area
unk_34A:        equ 034Ah
stepval:        equ 034Ch		; Schrittweite Zeilennummerierung
unk_34E:        equ 034Eh
unk_354:        equ 0354h
unk_355:        equ 0355h
unk_358:        equ 0358h
unk_360:        equ 0360h
unk_368:        equ 0368h
off_395:        equ 0395h
byte_397:       equ 0397h
byte_398:       equ 0398h 		; Token
byte_399:       equ 0399h
word_39A:       equ 039Ah
unk_39C:        equ 039Ch
unk_3DC:	equ 03DCh
word_3E0:	equ 03E0h
word_3E2:	equ 03E2h
word_3E4:	equ 03E4h
word_3E6:	equ 03E6h
byte_3E8:	equ 03E8h
word_3EE:	equ 03EEh
byte_3F0:	equ 03F0h
byte_3F1:	equ 03F1h
unk_3F2:	equ 03F2h
byte_3F3:	equ 03F3h
; Speicher MC+TB
tb_anf:		equ 03F4h		; TB Start init 2000h
tb_pos:		equ 03F6h		; TB Pos.  init 2000h
tb_end:		equ 03F8h		; TB Ende  init 3FFFh
mc_anf:		equ 03FAh		; MC Start init 1C00h
mc_pos:		equ 03FCh		; MC Pos.  init 1C00h
mc_end:		equ 03FEh		; MC Ende  init 1FFFh


;------------------------------------------------------------------------------
; ORG
;------------------------------------------------------------------------------

	if romversion = 1
		org 0C000h
	else
		org 0400h
	endif

;------------------------------------------------------------------------------
; OS-Rahmen
;------------------------------------------------------------------------------

start:		jp	idas
aIdas:		db "IDAS    ",0
		db    0

;------------------------------------------------------------------------------
; Start
;------------------------------------------------------------------------------

idas:		ld	(regsv), sp
		ld	sp, regsv
		ex	af, af'		;'
		push	af
		ex	af, af'		;'
		exx
		push	bc
		push	de
		push	hl
		exx
		push	af
		push	bc
		push	de
		push	hl
		push	ix
		push	iy
		ld	a, i
		push	af
		ld	sp, stack
		ld	hl, aIdas_0	; "\r\nIDAS : "
		ld	b, tab1-aIdas_0	; Lnge Startmeldung
		call	print		; Ausgabe B Zeichen ab HL
		call	inch		; Eingabe Zeichen (mit Ausgabe)
		cp	'N'
		jr	nz, idas1
		; init-Werte eintragen
		ld	hl, tab1
		ld	de, tb_anf
		ld	bc, 12		; 6 Words
		ldir
		ld	hl, (EOR)
		ld	(tb_end), hl
idas1:		xor	a
		ld	(byte_3F3), a
		call	sub_1639	; Ausgabe Space+CR
		call	sub_1639	; Ausgabe Space+CR
idas2:		ld	sp, stack
		ld	ix, unk_3F2
		xor	a
		ld	(ix+0),	a
		ld	(unk_32F), a
		ld	a, '+'          ; Prompt
		call	outa		; Zeichenausgabe
		ld	a, ' '
		ld	(unk_79), a
		ld	b, 7
idas3:		call	outa		; Zeichenausgabe
		djnz	idas3
		call	sub_98B
		jr	nc, idas2
		call	sub_A31
		jr	nc, idas2
		ld	a, (byte_398)	; Token
		cp	6Eh
		jp	nc, loc_53C	; wenn Direkt-Kommando
		bit	0, (ix+0)
		jr	z, idas7
		bit	1, (ix+0)
		jr	nz, idas5
		ld	hl, unk_34E
		call	sub_D35
		ld	a, (byte_397)
		ld	b, a
		ld	c, 0
		ld	hl, (off_395)
		call	sub_1452
		jr	nc, idas4
		jr	z, idas6
idas4:		call	sub_C08
		xor	a
		ld	(byte_3F3), a
		jr	idas2
idas5:		ld	b, 0
		ld	hl, (off_395)
		call	sub_1452
		jp	nc, err_LNR
		jp	nz, err_LNR
idas6:		inc	hl
		inc	hl
		ld	c, (hl)
		dec	hl
		dec	hl
		jr	idas4
;
idas7:		cp	6Fh
		jr	nc, loc_4D7	; Direkt-Kommando
		cp	64h
		jp	nc, err_ILO	; Pseudo-Anweisung
		cp	31h
		jr	c, loc_4D7	; zulssige Assemblerbefehle
		cp	37h
		jp	c, err_ILO	; DJNZ..JRZ hier nicht erlaubt
loc_4D7:	call	sub_B3A
		ld	hl, unk_34E
		set	3, (ix+0)
		call	sub_D35
loc_4E4:	ld	(hl), 0C3h
		inc	hl
		ld	de, loc_50A
		ld	(hl), e
		inc	hl
		ld	(hl), d
		ld	sp, unk_332
		pop	af
		ld	i, a
		pop	iy
		pop	ix
		pop	hl
		pop	de
		pop	bc
		pop	af
		exx
		pop	hl
		pop	de
		pop	bc
		exx
		ex	af, af'		;'
		pop	af
		ex	af, af'		;'
		ld	sp, (regsv)
		jp	unk_34E

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

loc_50A:	ld	(regsv), sp
		ld	sp, regsv
		ex	af, af'		;'
		push	af
		ex	af, af'		;'
		exx
		push	bc
		push	de
		push	hl
		exx
		push	af
		push	bc
		push	de
		push	hl
		push	ix
		push	iy
		ld	a, i
		push	af
		jp	idas2


;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

aIdas_0:
	if codebase=0
		db 0Dh,0Ah
		db "IDAS : "
	else
		db 0Dh,14h,04h,"INTERPRETING DIALOG-ASSEMBLER"
		db 0Ah,0Ah,0Dh,14h,02h,"WBOOT? "
	endif

; Initial-Werte fr MC+TB
; werden nach unk_3F4 ff. kopiert
tab1:           dw 2000h
		dw 2000h
		dw 3FFFh
	if romversion = 1
		dw 0400h
		dw 0400h
	else
		dw 1C00h
		dw 1C00h
	endif
		dw 1FFFh

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

; Auswertung Kommandos
; Entry bei Token ab 6Eh
loc_53C:	ld	hl, idas2	; Ret.Adr.
		push	hl		; auf Stack
		call	sub_15EC

; Auswertung Kommandos
; Entry bei Token ab 6Eh
loc_543:	ld	a, (byte_398)	; Token
		cp	70h ; MCSV
		jp	z, mcsv
		cp	73h ; ADDR
		jr	z, addr
		cp	74h ; ASGN
		jr	z, asgn
		cp	75h ; CM
		jp	z, cm
		cp	76h ; DR
		jp	z, dr		; Anzeige der Register
		cp	77h ; DS
		jp	z, dsp
		cp	78h ; KILL
		jp	z, kill		; Streichen von	Zeilen im Textpuffer
		cp	79h ; LIST
		jp	z, list		; Anzeige des Textpufferinhalts
		cp	7Ah ; WRIT
		jp	z, writ
		cp	7Bh ; READ
		jp	z, read
		cp	7Ch ; RUN
		jp	z, run
		jp	step	; else

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

addr:		call	sub_12AF
		call	sub_B3A
		set	3, (ix+0)
		call	sub_15EC
		call	sub_114F
		jp	nz, err_OPD
	if codebase=0
		call	sub_614
	else
		ex      de, hl
		call    outhl
		ld      a, 'H'
		call	outa
	endif
		jp	sub_1639	; Ausgabe Space+CR

;------------------------------------------------------------------------------
; Anzeigen und Modifizieren der Pufferadressen
;------------------------------------------------------------------------------

asgn:		call	sub_12A9
		ld	hl, aTb_0	; "TB ("
		ld	b, 4
		call	print		; Ausgabe B Zeichen ab HL
		ld	hl, tb_anf
		call	sub_5D1
		jr	nc, loc_5B5
		ld	(tb_anf), de
		ld	(tb_pos), de
		ld	(tb_end), hl
loc_5B5:	ld	hl, aMc_0	; "MC ("
		ld	b, 4
		call	print		; Ausgabe B Zeichen ab HL
		ld	hl, mc_anf
		call	sub_5D1
		jr	nc, loc_5CC
		ld	(mc_anf), de
		ld	(mc_end), hl
loc_5CC:	xor	a
		ld	(byte_3F3), a
		ret
sub_5D1:	call	sub_610
		ld	a, '-'
		call	outa		; Zeichenausgabe
		call	sub_610
		ld	a, ','
		call	outa		; Zeichenausgabe
		call	sub_610
		ld	a, ')'
		call	outa		; Zeichenausgabe
loc_5E9:	ld	a, ':'
		call	outa		; Zeichenausgabe
		call	sub_1595
		jr	nz, loc_60B
		cp	0Dh
		jr	z, loc_608
		push	hl
		call	sub_159A
		jr	nz, loc_60B
		sra	c
		jr	nc, loc_60B
		pop	de
		call	sub_1618
		ret	c
		ex	de, hl
		ret
;
loc_608:	sra	c
		ret	nc
loc_60B:	call	sub_1639	; Ausgabe Space+CR
		jr	loc_5E9
;
sub_610:	ld	e, (hl)
		inc	hl
		ld	d, (hl)
		inc	hl
sub_614:	ex	de, hl
		call	outhl		; Ausgabe HL hexadezimal
		ex	de, hl
	if codebase=0
		ld	a, 'H'
		jp	outa		; Zeichenausgabe
	else
		ret
	endif

aTb_0:		db "TB ("
aMc_0:		db "MC ("

;------------------------------------------------------------------------------
; Rcksprung in	das Monitorprogramm
;------------------------------------------------------------------------------

cm:		ld	sp, unk_332
		pop	af
		ld	i, a
		pop	iy
		pop	ix
		pop	hl
		pop	de
		pop	bc
		pop	af
		exx
		pop	hl
		pop	de
		pop	bc
		exx
		ex	af, af'		;'
		pop	af
		ex	af, af'		;'
		ld	sp, (regsv)
		call	unk_0		; ins OS
		jp	loc_50A

;------------------------------------------------------------------------------
; Anzeige der Register
;------------------------------------------------------------------------------

dr:		ld	hl, drtab
		ld	d, hi(regsv)
dr1:		ld	a, (hl)
		or	a
		jr	nz, dr2
		ld	a, 0Dh
		call	outa		; Zeichenausgabe
		ret
dr2:		ld	b, a
		inc	hl
		ld	c, (hl)
		inc	hl
		call	print		; Ausgabe B Zeichen ab HL
		ld	a, '='
		call	outa		; Zeichenausgabe
		ld	a, ' '
		call	outa		; Zeichenausgabe
		ld	e, (hl)
		ld	a, (de)
		call	outhx		; Ausgabe A hexadezimal
		dec	c
		jr	z, dr3
		dec	de
		ld	a, (de)
		call	outhx		; Ausgabe A hexadezimal
dr3:		ld	a, ' '
		call	outa		; Zeichenausgabe
		inc	hl
		jr	dr1

; SP = 01FC  I = 02
;  A = 02	   F = 42
; BC = 0014  DE =	0067  HL = 0400
; IX = C18A  IY =	FFFF
;  A"= 4D     F"= 9B
; BC"= FFFF  DE"= FFFF  HL'= FFFF

; Adr. vgl Push-Reihenfolge in loc_50A
;0349	sp	regsv 348
;0347	af'
;0345	bc'
;0343	de'
;0341	hl'
;033f	af
;033d	bc
;033b	de
;0339	hl
;0337	ix
;0335	iy
;0333	i
drtab:		db    3			; Anz Zeichen
		db    2			; Anz Bytes
		db "SP "		; n Zeichen
		db  Lo(regsv+1)		; lo(regs.Adr)
		db    3
		db    1
		db " I "
		db  lo(regsv-21)
		db    4
		db    1
		db 0Dh," A "
		db  lo(regsv-9)
		db    5
		db    1
		db "   F "
		db  lo(regsv-10)
		db    4
		db    2
		db 0Dh,"BC "
		db  lo(regsv-11)
		db    4
		db    2
		db " DE "
		db  lo(regsv-13)
		db    4
		db    2
		db " HL "
		db  lo(regsv-15)
		db    4
		db    2
		db 0Dh,"IX "
		db  lo(regsv-17)
		db    4
		db    2
		db " IY "
		db  lo(regsv-19)
		db    4
		db    1
		db 0Dh," A",27h
		db  lo(regsv-1)
		db    6
		db    1
		db "    F",27h
		db  lo(regsv-2)
		db    4
		db    2
		db 0Dh,"BC",27h
		db  lo(regsv-3)
		db    4
		db    2
		db " DE",27h
		db  lo(regsv-5)
		db    4
		db    2
		db " HL",27h
		db  lo(regsv-7)
		db    0			; ende

;------------------------------------------------------------------------------
; Anzeige und Modifizierung von	Speicherinhalten
;------------------------------------------------------------------------------

dsp:		ld	a, ':'
		call	outa		; Zeichenausgabe
		call	sub_1595
		jr	nz, loc_73C
loc_6E9:	cp	3
		ret	z
		push	hl
		call	outhl		; Ausgabe HL hexadezimal
	if codebase=0
		ld	a, 'H'
		call	outa		; Zeichenausgabe
	endif
		call	0F310h
		pop	hl
		ld	a, (hl)
		call	outhx		; Ausgabe A hexadezimal
	if codebase=0
		ld	a, 'H'
		call	outa		; Zeichenausgabe
	endif
		ld	a, '-'
		call	outa		; Zeichenausgabe
		ld	c, CSTS
loc_709:	call	BOS
		or	a
		jr	z, loc_709
		cp	3
		jr	z, loc_71D
		cp	0Ah
		jr	z, loc_71D
		cp	0Bh
		jr	nz, loc_727
		dec	hl
		dec	hl
loc_71D:	call	sub_1639	; Ausgabe Space+CR
		ld	c, CONSI
		call	BOS
		jr	loc_739

loc_727:	push	hl
		call	sub_1595
		ex	de, hl
		pop	hl
		jr	nz, loc_73C
		sra	c
		jr	nc, loc_739
		ld	a, d
		or	a
		jp	nz, err_IO
		ld	(hl), e
loc_739:	inc	hl
		jr	loc_6E9

loc_73C:	jp	sub_1639	; Ausgabe Space+CR

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

kill:		call	sub_15C1	; Streichen von	Zeilen im Textpuffer
		call	sub_C8C
		ret	nc
loc_746:	inc	hl
		inc	hl
		ld	c, (hl)
		dec	hl
		dec	hl
		ld	b, 0
		push	hl
		push	de
		call	sub_C08
		pop	de
		pop	hl
		call	sub_C8C
		jr	c, loc_746
		ret

;------------------------------------------------------------------------------
; Anzeige des Textpufferinhalts
;------------------------------------------------------------------------------

list:		ld	iy, sub_7CC	; Anzeige des Textpufferinhalts
		xor	a
		ld	(device), a	; device 0 console, 1 tape
		jr	loc_76B

;------------------------------------------------------------------------------
; Ausgabe aus dem Textpuffer
;------------------------------------------------------------------------------

writ:		ld	iy, loc_7FB
		call	sub_18E7	; Device-Abfrage
					; ggf. OPENW
loc_76B:	ld	a, (hl)
		or	a
		jr	z, loc_784
		call	sub_152C
		jr	c, loc_784
		ex	de, hl
		ld	hl, byte_3E8
		call	sub_983
		ld	(hl), a
		call	sub_1473
		ld	de, 0FFFFh
		jr	loc_787

loc_784:	call	sub_15C1
loc_787:	call	sub_C8C
		ret	nc
loc_78B:	call	sub_C5D
		push	hl
		push	de
		push	iy
		pop	hl
		call	callhl		; call (hl)
		pop	de
		pop	hl
		ld	c, CSTS		; Abfrage Status CONST
		call	BOS
		or	a
		jr	z, loc_7B1
		ld	c, CONSI	; Eingabe eines	Zeichens von CONST
		call	BOS
		cp	3
		ret	z
loc_7A8:	cp	13h
		jr	nz, loc_7B1
		call	BOS
		jr	loc_7A8

loc_7B1:	call	sub_C76
		call	sub_C8C
		jr	c, loc_78B
		ld	a, (device)	; device 0 console, 1 tape
		or	a
		ret	z
		ld	hl, INTLN
		ld	(DMA), hl
		ld	c, CLOSW	; Abschlieen Kassette schreiben
		call	BOS
		jp	loc_1B47

sub_7CC:	ld	hl, outa	; Zeichenausgabe
		push	hl
		ld	hl, (off_395)
		call	outdez		; Ausgabe HL dezimal
		ld	hl, unk_355
		ld	b, 40h
		ld	a, ' '
		call	fill		; fill B Bytes ab HL mit A
		ld	hl, unk_358
		ld	de, unk_39C
		ld	a, (de)
		or	a
		jr	z, loc_7EF
		call	sub_983
		ld	(hl), ':'
loc_7EF:	ld	hl, unk_360
		inc	de
		call	sub_983
		ld	hl, unk_368
		jr	loc_819

loc_7FB:	ld	hl, loc_1A24	; Ausgabe E (nur wenn Z-Flag gesetzt), Ausgabe A
		push	hl
		ld	hl, unk_355
		ld	de, unk_39C
		ld	a, (de)
		or	a
		jr	z, loc_812
		call	sub_983
		ld	(hl), ':'
		inc	hl
		ld	(hl), ' '
		inc	hl
loc_812:	inc	de
		call	sub_983
		ld	(hl), ' '
		inc	hl
loc_819:	inc	de
		ld	a, (de)
		or	a
		jr	z, loc_837
		call	sub_983
		inc	de
		ld	a, (de)
		or	a
		jr	z, loc_837
		ld	(hl), ','
		inc	hl
		call	sub_983
		inc	de
		ld	a, (de)
		or	a
		jr	z, loc_837
		ld	(hl), ','
		inc	hl
		call	sub_983
loc_837:	ld	(hl), 0Dh
		ld	de, unk_355
		pop	hl
loc_83D:	ld	a, (de)
		call	callhl		; call (hl)
		inc	de
		cp	0Dh
		jr	nz, loc_83D
		ret

loc_847:	ex	de, hl
		ld	hl, byte_3E8
		call	sub_983
		ld	(hl), a
		call	sub_1473
		jr	loc_866

;------------------------------------------------------------------------------
; Eingabe in den Textpuffer
;------------------------------------------------------------------------------

read:		ld	a, (hl)
		or	a
		jr	z, loc_86B
		call	sub_13FE
		jr	nc, loc_847
		ld	(off_395), hl
		call	sub_1452
		jp	nc, err_LNR
loc_866:	call	sub_C76
		jr	loc_874

loc_86B:	ld	hl, 0
		ld	(off_395), hl
		ld	hl, (tb_anf)
loc_874:	ld	(stack), hl
		call	sub_1956
		xor	a
		ld	(byte_3F3), a
loc_87E:	ld	(ix+0),	4
		ld	hl, (off_395)
		inc	hl
		ld	(off_395), hl
		ld	hl, byte_397
		ld	b, 45h ; 'E'
		call	empty		; fill B Bytes ab HL mit 00
		call	sub_990		; Eingabe Kommandozeile
		push	af
		cp	3
		jr	z, loc_8CD
		pop	af
		jr	nc, loc_87E
		ld	hl, unk_355
		call	sub_A55
		jr	nc, loc_87E
		ld	a, (byte_398)	; Token
		cp	6Eh ; 'n'
		jr	c, loc_8B1	; wenn kein Direktkommando
		call	sub_8CE
		jp	loc_543		; Auswertung Kommandos

loc_8B1:	ld	hl, unk_34E
		call	sub_D35
		ld	a, (byte_397)
		ld	b, a
		ld	c, 0
		ld	hl, (stack)
		push	hl
		call	sub_C08
		pop	hl
		call	sub_C76
		ld	(stack), hl
		jr	loc_87E

loc_8CD:	pop	af
sub_8CE:	ld	a, (device)	; device 0 console, 1 tape
		or	a
		jr	z, loc_8F2
		ld	de, 0
		ld	hl, (unk_75)
		ld	b, h
		ld	c, l
		sbc	hl, de
		jr	z, loc_8F2
		ld	de, (tb_pos)
		ld	hl, (tb_end)
		inc	hl
		ldir
		dec	hl
		ld	(tb_pos), de
		ld	(tb_end), hl
loc_8F2:	ld	bc, 0Ah
		call	sub_965
		ret

;------------------------------------------------------------------------------
; Abarbeiten von Anweisungen aus dem Textpuffer
;------------------------------------------------------------------------------

run:		call	sub_B3A
		call	sub_15C1
		call	sub_C8C
		ret	nc
		xor	a
		ld	(byte_3F3), a
		ld	bc, 3
loc_90A:	push	hl
		push	de
		add	hl, bc
		ld	a, (hl)
		cp	6Fh ; 'o'
		jr	nc, loc_916
		cp	67h ; 'g'
		jr	nc, loc_930
loc_916:	add	hl, bc
		ld	(stepval), hl	; Schrittweite Zeilennummerierung
		bit	4, (ix+0)
		jr	nz, loc_930
		set	4, (ix+0)
		ld	d, (hl)
		dec	hl
		ld	e, (hl)
		ld	hl, unk_34E
		ld	(hl), 0C3h
		inc	hl
		ld	(hl), e
		inc	hl
		ld	(hl), d
loc_930:	pop	de
		pop	hl
		call	sub_C76
		call	sub_C8C
		jr	c, loc_90A
		bit	4, (ix+0)
		ret	z
		pop	hl
		ld	hl, (stepval)	; Schrittweite Zeilennummerierung
		ld	d, (hl)
		dec	hl
		ld	e, (hl)
		dec	hl
		ld	c, (hl)
		ex	de, hl
		add	hl, bc
		jp	loc_4E4

;------------------------------------------------------------------------------
; Schrittweite setzen
;------------------------------------------------------------------------------

step:		ld	bc, 1		; Standard-Schrittweite 1
		ld	a, (hl)		; kein Parameter?
		or	a
		jr	z, sub_965	; dann Standard
		call	sub_13FE
		jp	nc, err_LNR
		ld	a, h
		or	a
		jp	nz, err_LNR
		or	l
		jp	z, err_LNR
		ld	b, h
		ld	c, l

sub_965:	ld	(stepval), bc	; Schrittweite Zeilennummerierung
		ld	hl, (tb_anf)
loc_96C:	call	sub_C81
		ret	nc
		ld	de, (stepval)	; Schrittweite Zeilennummerierung
		ld	(hl), e
		inc	hl
		ld	(hl), d
		dec	hl
		ex	de, hl
		add	hl, bc
		ld	(stepval), hl	; Schrittweite Zeilennummerierung
		ex	de, hl
		call	sub_C76
		jr	loc_96C

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

sub_983:	ld	a, (de)
		or	a
		ret	z
		ld	(hl), a
		inc	hl
		inc	de
		jr	sub_983

sub_98B:	ld	hl, inch	; Eingabe Zeichen (mit Ausgabe)
		jr	loc_993

;------------------------------------------------------------------------------
; Eingabe Kommandozeile
;------------------------------------------------------------------------------

sub_990:	ld	hl, loc_19D2
loc_993:	push	hl
		ld	hl, unk_355
		push	hl
		ld	b, 40h
		call	empty		; fill B Bytes ab HL mit 00
		pop	de
		pop	hl
		ld	bc, 0
loc_9A2:	call	callhl		; call (hl)
		cp	0Dh
		jp	z, loc_A2D
		cp	27h ; '''
		jr	nz, loc_9B8
		ld	a, (unk_32F)
		xor	1
		ld	(unk_32F), a
		ld	a, 27h ; '''
loc_9B8:	cp	8
		jr	z, loc_A1F
		cp	3
		jr	nz, loc_9EE
		push	af
		ld	a, (unk_79)
		cp	15h
		jr	z, loc_9D2
		cp	14h
		jr	z, loc_9D2
		cp	5
		jr	z, loc_9D2
		pop	af
		ret

loc_9D2:	pop	af
		or	a
		jr	nz, loc_9EE
		ld	(de), a
		ld	a, (unk_79)
		push	af
		xor	a
		ld	(unk_79), a
		pop	af
		cp	15h
		jr	z, loc_A06
		cp	14h
		jr	z, loc_A06
		cp	5
		jr	z, loc_A06
		jr	loc_A08

loc_9EE:	ld	(unk_79), a
		cp	61h ; 'a'
		jr	c, loc_9FB
		cp	7Bh ; '{'
		jr	nc, loc_9FB
	if codebase=0
		sub	20h ; ' '
	else
		nop
		nop
	endif
loc_9FB:	ld	(de), a
		cp	20h ; ' '
		jr	nc, loc_A06
		ld	a, (unk_32F)
		or	a
		jr	z, loc_A08
loc_A06:	inc	de
		inc	b
loc_A08:	ld	c, 0
		ld	a, b
		cp	40h ; '@'
		jr	c, loc_9A2
		bit	2, (ix+0)
		jp	z, err_LNG
loc_A16:	call	callhl		; call (hl)
		cp	0Dh
		jr	nz, loc_A16
		scf
		ret

loc_A1F:	ld	c, 0FFh
		ld	a, b
		or	a
		jp	z, loc_9A2
		dec	b
		dec	de
		xor	a
		ld	(de), a
		jp	loc_9A2

loc_A2D:	sra	c
		ccf
		ret

sub_A31:	ld	hl, off_395
		ld	b, 47h ; 'G'
		call	empty		; fill B Bytes ab HL mit 00
		ld	hl, unk_355
		call	sub_13FE
		jr	nc, sub_A55
		ld	(off_395), hl
		ex	de, hl
		set	0, (ix+0)
		call	sub_B33
		or	a
		jr	nz, sub_A55
		set	1, (ix+0)
		scf
		ret

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

sub_A55:	ld	de, unk_39C
loc_A58:	call	sub_B33
		or	a
		ret	z
		cp	3Bh ; ';'
		scf
		ccf
		ret	z
		ld	b, 0
		push	hl
loc_A65:	ld	a, (hl)
		or	a
		jr	z, loc_A97
		cp	20h ; ' '
		jr	z, loc_A97
		cp	3Bh ; ';'
		jr	z, loc_A97
		cp	3Ah ; ':'
		jr	z, loc_A79
		inc	hl
		inc	b
		jr	loc_A65

loc_A79:	bit	7, (ix+0)
		jp	nz, err_SYM
		set	7, (ix+0)
		ld	(hl), 0
		ex	(sp), hl
		call	sub_1417
		ex	(sp), hl
		ld	(hl), 3Ah ; ':'
		jp	nc, err_SYM
		pop	hl
		call	sub_1625
		inc	hl
		jr	loc_A58

loc_A97:	pop	hl
		call	sub_13AF
		jp	nc, err_MNE
		ld	(byte_398), a	; Token
		inc	de
		call	sub_1625
		call	sub_B33
		or	a
		jr	z, loc_AE5
		cp	3Bh ; ';'
		jr	z, loc_AE5
		call	sub_AF2
		cp	2Ch ; ','
		jr	z, loc_AC1
		cp	20h ; ' '
		jr	nz, loc_ADA
		ld	a, (byte_398)	; Token
		cp	71h ; 'q'
		jr	c, loc_ADA
loc_AC1:	inc	hl
		call	sub_AF2
		cp	2Ch ; ','
		jr	nz, loc_ADA
		ld	a, (byte_398)	; Token
		cp	71h ; 'q'
		jp	c, err_OPD
		inc	hl
		call	sub_AF2
		cp	2Ch ; ','
		jp	z, err_OPD
loc_ADA:	call	sub_B33
		or	a
		jr	z, loc_AE5
		cp	3Bh ; ';'
		jp	nz, err_OPD
loc_AE5:	ld	hl, off_395
		ex	de, hl
		or	a
		sbc	hl, de
		ld	a, l
		ld	(byte_397), a
		scf
		ret

sub_AF2:	ld	b, 0
		push	hl
loc_AF5:	ld	a, (hl)
		or	a
		jr	z, loc_B27
		cp	20h ; ' '
		jr	z, loc_B27
		cp	3Bh ; ';'
		jr	z, loc_B27
		cp	2Ch ; ','
		jr	z, loc_B27
		inc	hl
		inc	b
		cp	27h ; '''
		jr	nz, loc_AF5
loc_B0B:	ld	a, (hl)
		or	a
	if codebase=0
		jr	nz, loc_B1F
		dec	hl
		ld	a, (hl)
		inc	hl
		cp	15h
		jr	z, loc_B1F
		cp	14h
		jr	z, loc_B1F
		cp	5
		jp	nz, err_OPD
	else
		jp	z, err_OPD
	endif
loc_B1F:	inc	hl
		inc	b
		cp	27h ; '''
		jr	z, loc_AF5
		jr	loc_B0B
loc_B27:		ld	a, b
		or	a
		jp	z, err_OPD
		inc	de
		pop	hl
		call	sub_1625
		ld	a, (hl)
		ret

sub_B33:	ld	a, (hl)
		cp	20h ; ' '
		ret	nz
		inc	hl
		jr	sub_B33

sub_B3A:	ld	a, (byte_3F3)
		or	a
		ret	nz
		ld	hl, off_395
		ld	de, unk_355
		ld	bc, 40h	; '@'
		ldir
		set	3, (ix+0)
		call	sub_B6B
		call	sub_BDA
		ld	a, 0FFh
		ld	(byte_3F3), a
		ld	hl, (unk_330)
		ld	(mc_pos), hl
		ld	hl, 355h
		ld	de, 395h
		ld	bc, 40h	; '@'
		ldir
		ret

sub_B6B:	ld	hl, (mc_anf)
		ld	(unk_330), hl
		ld	hl, (tb_anf)
loc_B74:	call	sub_C81
		ret	nc
		call	sub_C5D
		push	hl
		call	sub_15EC
		ld	a, (byte_398)	; Token
		cp	69h 		; "PN"
		jr	nc, loc_BBA
		cp	68h 		; "ORG"
		jr	nc, loc_BC6
		cp	67h 		; "EQU"
		jr	nc, loc_BD5
		cp	66h 		; "BER"
		call	nc, sub_1116
		ld	hl, (unk_330)
		ld	(word_39A), hl
		ld	a, (byte_399)
		ld	c, a
		ld	b, 0
		add	hl, bc
loc_BA0:	ld	de, (mc_end)
		dec	de
		dec	de
		dec	de
		call	sub_1618
		jp	c, err_MC
		ld	(unk_330), hl
loc_BB0:	ld	hl, off_395
		pop	de
		push	de
		ld	b, 7
		call	sub_1625
loc_BBA:	pop	hl
		call	sub_C76
		jr	loc_B74

loc_BC0:	ld	(word_39A), de
		jr	loc_BB0

loc_BC6:	call	sub_1121
		ld	hl, (mc_anf)
		ex	de, hl
		call	sub_1618
		jp	nc, err_MC
		jr	loc_BA0

loc_BD5:	call	sub_1121
		jr	loc_BC0

sub_BDA:	ld	hl, (mc_anf)
		ld	(unk_330), hl
		ld	hl, (tb_anf)
loc_BE3:	call	sub_C81
		ret	nc
		call	sub_C5D
		ld	a, (byte_398)	; Token
		cp	6Fh ; 'o'
		jr	nc, loc_BF5
		cp	67h ; EQU
		jr	nc, loc_C03
loc_BF5:	push	hl
		ld	hl, (word_39A)
		ld	(unk_330), hl
		call	sub_D35
		ld	(unk_330), hl
		pop	hl
loc_C03:	call	sub_C76
		jr	loc_BE3

sub_C08:	push	hl
		push	bc
		ex	de, hl
		ld	hl, (tb_pos)
		ld	a, b
		ld	b, 0
		sub	c
		jr	z, loc_C43
		jr	nc, loc_C2E
		neg
		or	a
		ld	c, a
		sbc	hl, bc
		ld	(tb_pos), hl
		sbc	hl, de
		push	hl
		ld	h, d
		ld	l, e
		add	hl, bc
		pop	bc
		ld	a, b
		or	c
		jr	z, loc_C2C
		ldir
loc_C2C:	jr	loc_C43
loc_C2E:	ld	c, a
		sbc	hl, de
		push	hl
		add	hl, de
		ld	d, h
		ld	e, l
		dec	de
		add	hl, bc
		ld	(tb_pos), hl
		dec	hl
		ex	de, hl
		pop	bc
		ld	a, b
		or	c
		jr	z, loc_C43
		lddr
loc_C43:	pop	bc
		pop	de
		ld	hl, off_395
		call	sub_1625
		ld	hl, (tb_pos)
		ld	de, (tb_end)
		ld	bc, 40h	; '@'
		add	hl, bc
		call	sub_1618
		jp	c, err_TB
		ret

sub_C5D:	push	hl
		push	de
		push	bc
		push	hl
		inc	hl
		inc	hl
		ld	c, (hl)
		ld	hl, off_395
		ld	b, 47h ; 'G'
		call	empty		; fill B Bytes ab HL mit 00
		pop	hl
		ld	de, off_395
		ldir
		pop	bc
		pop	de
		pop	hl
		ret

sub_C76:	push	bc
		inc	hl
		inc	hl
		ld	b, 0
		ld	c, (hl)
		dec	hl
		dec	hl
		add	hl, bc
		pop	bc
		ret

sub_C81:	push	de
		ld	de, (tb_pos)
		call	sub_1618
		ccf
		pop	de
		ret

sub_C8C:	call	sub_C81
		ret	nc
		push	de
		ld	e, (hl)
		inc	hl
		ld	d, (hl)
		dec	hl
		ex	(sp), hl
		call	sub_1618
		ex	de, hl
		pop	hl
		ret

;------------------------------------------------------------------------------
; Fehlerausgaben
;------------------------------------------------------------------------------

err_LNR:	ld	hl, aLnr	; "LNR"
		jr	error

err_IO:		ld	hl, aIo		; "IO+"
		jr	error

err_MC:		ld	hl, aMc		; "MC+"
		jr	error

err_TB:		ld	hl, aTb		; "TB+"
		jr	error

err_ILO:	ld	hl, aIlo	; "ILO"
		jr	error

err_LNG:	call	sub_1639	; Ausgabe Space+CR
		ld	hl, aLng	; "LNG"
		jr	error

err_OPD:	ld	hl, aOpd	; "OPD"
		jr	error

err_MDS:	ld	hl, aMds	; "MDS"
		jr	error

err_NDS:	ld	hl, aNds	; "NDS"
		jr	error

err_MNE:	ld	hl, aMne	; "MNE"
		jr	error

err_SYM:	ld	hl, aSym	; "SYM"
;
error:		push	hl
		ld	hl, (off_395)
		bit	2, (ix+0)
		jr	z, error2
		call	outdez		; Ausgabe HL dezimal
		ld	hl, unk_354
		ld	a, 9
error1:		call	outa		; Zeichenausgabe
		inc	hl
		ld	a, (hl)
		or	a
		jr	nz, error1
		call	sub_1639	; Ausgabe Space+CR
		jr	error3

error2:		bit	3, (ix+0)
		jr	z, error3
		ld	a, h
		or	l
		call	nz, sub_7CC
error3:		ld	a, '+'
		call	outa		; Zeichenausgabe
		ld	b, 3
		pop	hl
		call	print		; Ausgabe B Zeichen ab HL
		ld	a, '+'
		call	outa		; Zeichenausgabe
		call	sub_1639	; Ausgabe Space+CR
		jp	idas2

aLnr:		db "LNR"
aIo:		db "IO+"
aMc:		db "MC+"
aTb:		db "TB+"
aLng:		db "LNG"
aIlo:		db "ILO"
aOpd:		db "OPD"
aMds:		db "MDS"
aNds:		db "NDS"
aMne:		db "MNE"
aSym:		db "SYM"

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

sub_D35:	push	hl
		ld	hl, err_OPD	; Ret.Adr bei Fehler auf Stack
		push	hl
		;
		call	sub_15EC
		ld	a, (byte_398)	; Token
		cp	17h
		jr	c, loc_DA5	; 00..16: CCF..SCF
		cp	18h
		jr	c, loc_DAE	; 17: RST
		cp	31h
		jp	c, loc_DC9	; 18..30: CPD..RETN
		cp	37h
		jp	c, loc_DD2	; 31..36: DJNZ..JRZ
		cp	39h
		jp	c, loc_DDF	; 37..38: IN..OUT
		cp	4Ah
		jp	c, loc_E03	; 39..49: CAC..JPZ
		cp	4Bh
		jp	c, loc_E10	; 4A: EX
		cp	4Dh
		jp	c, loc_E39	; 4B..4C: POP..PUSH
		cp	54h
		jp	c, loc_E56	; 4D..53: RL..SRL
		cp	57h
		jp	c, loc_E76	; 54..56: BIT..RES
		cp	58h
		jp	c, loc_E91	; 57: JMP
		cp	5Ah
		jp	c, loc_EBB	; 58..59: INC..DEC
		cp	5Fh
		jp	c, loc_EF2	; 5A..5E: AND..CMP
		cp	61h
		jp	c, loc_F1A	; 5F..60: ADC..SBC
		cp	62h
		jp	c, loc_F3A	; 61: ADD
		cp	63h
		jp	c, loc_F6D	; 62: LD
		; Pseudo-Anweisungen
		cp	64h
		jp	z, loc_10DD	; 64: DB
		cp	65h
		jp	z, loc_1102	; 65: DA
		cp	66h
		jp	z, loc_1109	; 66: BER
		cp	69h
		jp	c, loc_1110	; 67..68: EQU..ORG
		; else (PN..END)
		jp	loc_1113	; bergehen

; 00..16: CCF..SCF
loc_DA5:	call	sub_12A9
		call	sub_1128
		jp	loc_10B0

; 17: RST
loc_DAE:	call	sub_12AF
		call	sub_1136
		ret	nz
		ld	c, 0C7h	; ''
loc_DB7:	ld	a, d
		or	a
		jr	z, loc_DC5
		sub	8
		ld	d, a
		ld	a, c
		add	a, 8
		ret	c
		ld	c, a
		jr	loc_DB7
;
loc_DC5:	ld	a, c
		jp	loc_10B0

; 18..30: CPD..RETN
loc_DC9:	call	sub_12A9
		call	sub_1128
		jp	loc_10BA

; 31..36: DJNZ..JRZ
loc_DD2:	call	sub_12AF
		call	sub_113F
		ret	nz
		call	sub_1128
		jp	loc_10B7

; 37..38: IN..OUT
loc_DDF:	call	sub_12AF
		call	sub_1128
		ld	b, a
		call	sub_12BA
		jr	nz, loc_DFB
		rlca
		rlca
		rlca
		or	40h ; '@'
		ld	d, a
		ld	a, 0DBh	; ''
		cp	b
		jr	z, loc_DF7
		inc	d
loc_DF7:	ld	a, d
		jp	loc_10BA
;
loc_DFB:	call	sub_1136
		ret	nz
		ld	a, b
		jp	loc_10B7

; 39..49: CAC..JPZ
loc_E03:	call	sub_12AF
		call	sub_114F
		ret	nz
		call	sub_1128
		jp	loc_10C5

; 4A: EX
loc_E10:	call	sub_12F0
		jr	nz, loc_E25
		cp	1
		ret	nz
		ld	d, 0EBh
loc_E1A:	ld	hl, (word_3E2)
		call	sub_130B
		ret	nz
		ld	a, d
		jp	loc_10B0
;
loc_E25:	call	sub_1329
		ret	nz
		cp	3
		ret	nz
		ld	hl, (word_3E2)
		ld	d, 0E3h
		call	sub_1304
		jr	nz, loc_E1A
		jp	loc_10B7

; 4B..4C: POP..PUSH
loc_E39:	call	sub_12AF
		call	sub_1128
		ld	d, a
		call	sub_12FD
		jr	nz, loc_E4D
		rlca
		rlca
		rlca
		rlca
		or	d
		jp	loc_10B0
;
loc_E4D:	call	sub_1304
		ret	nz
		set	5, d
		jp	loc_10B7

; 4D..53: RL..SRL
loc_E56:	call	sub_12AF
		call	sub_1128
		ld	d, a
		call	sub_12D8
		jr	nz, loc_E69
loc_E62:	or	d
		ld	d, a
		ld	a, 0CBh	; ''
		jp	loc_10B7
;
loc_E69:	call	sub_133B
		ret	nz
		ld	c, 0CBh	; ''
		set	1, d
		set	2, d
		jp	loc_10CC

; 54..56: BIT..RES
loc_E76:	call	sub_1136
		ret	nz
		ld	a, d
		cp	8
		ret	nc
		rlca
		rlca
		rlca
		ld	d, a
		call	sub_1128
		or	d
		ld	d, a
		ld	hl, (word_3E2)
		call	sub_12D8
		jr	nz, loc_E69
		jr	loc_E62

; 57: JMP
loc_E91:	call	sub_12AF
		ld	d, 0E9h
		call	sub_12D8
		jr	nz, loc_EA2
		cp	6
		ret	nz
		ld	a, d
		jp	loc_10B0
;
loc_EA2:	call	sub_133B
		jr	nz, loc_EB2
		ld	c, a
		ld	a, e
		or	a
		jr	nz, loc_EB2
		ld	a, c
		jr	nz, loc_EB2
		jp	loc_10B7
;
loc_EB2:	call	sub_114F
		ret	nz
		ld	a, 0C3h
		jp	loc_10C5

; 58..59: INC..DEC
loc_EBB:	call	sub_12AF
		call	sub_1128
		ld	d, a
		call	sub_12D8
		jr	nz, loc_ECE
loc_EC7:	rlca
		rlca
		rlca
		or	d
		jp	loc_10B0
;
loc_ECE:	call	sub_133B
		jr	nz, loc_EDB
		ld	c, d
		set	4, c
		set	5, c
		jp	loc_10C3
;
loc_EDB:	dec	d
		ld	a, d
		cp	3
		jr	z, loc_EE3
		ld	d, 0Bh
loc_EE3:	call	sub_12F0
		rlca
		jr	z, loc_EC7
		call	sub_1304
		ret	nz
		set	5, d
		jp	loc_10B7

; 5A..5E: AND..CMP
loc_EF2:	call	sub_12AF
		call	sub_1128
		ld	d, a
		call	sub_12D8
		jr	nz, loc_F02
		or	d
		jp	loc_10B0
;
loc_F02:	set	1, d
		set	2, d
		call	sub_133B
		jr	nz, loc_F0F
		ld	c, d
		jp	loc_10C3
;
loc_F0F:	set	6, d
		ld	b, d
		call	sub_1136
		ret	nz
		ld	a, b
		jp	loc_10B7

; 5F..60: ADC..SBC
loc_F1A:	call	sub_130B
		jr	nz, loc_EF2
		ld	hl, (word_3E2)
		call	sub_12F0
		ret	nz
		rlca
		rlca
		rlca
		rlca
		ld	d, a
		call	sub_1128
		sub	3Eh ; '>'
		cp	4Ah ; 'J'
		jr	z, loc_F36
		ld	a, 42h ; 'B'
loc_F36:	or	d
		jp	loc_10BA

; 61: ADD
loc_F3A:	ld	d, 9
		call	sub_130B
		jr	z, loc_F62
		call	sub_1304
		jr	nz, loc_EF2
		ld	b, a
		ld	hl, (word_3E2)
		call	sub_1304
		ld	a, 2
		jr	z, loc_F58
		call	sub_12F0
		ret	nz
		cp	2
		ret	z
loc_F58:	rlca
		rlca
		rlca
		rlca
		or	d
		ld	d, a
		ld	a, b
		jp	loc_10B7
;
loc_F62:	ld	hl, (word_3E2)
		call	sub_12F0
		ret	nz
		rlca
		jp	loc_EC7

; 62: LD
loc_F6D:	call	sub_12D8
		jr	z, loc_F94
		call	sub_133B
		jr	z, loc_FC9
		ld	hl, (word_3E2)
		call	sub_12E9
		jr	z, loc_FDB
loc_F7F:	ld	hl, (word_3E0)
		call	sub_12F0
		jr	z, loc_FF1
		call	sub_1304
		jp	z, loc_101A
		call	sub_115F
		jp	z, loc_1029
		ret
;
loc_F94:	rlca
		rlca
		rlca
		ld	c, a
		ld	hl, (word_3E2)
		call	sub_12D8
		jp	z, loc_103B
		call	sub_1136
		jp	z, loc_1043
		ld	a, c
		cp	30h ; '0'
		jr	z, loc_F7F
		call	sub_133B
		jp	z, loc_1048
		ld	a, c
		cp	38h ; '8'
		ret	nz
		call	sub_1329
		jp	z, loc_1050
		call	sub_115F
		jp	z, loc_105D
		call	sub_1319
		jp	z, loc_1061
		ret
;
loc_FC9:	ld	hl, (word_3E2)
		ld	b, a
		call	sub_12BA
		jp	z, loc_1066
		ld	c, e
		call	sub_1136
		jp	z, loc_106A
		ret
;
loc_FDB:	ld	hl, (word_3E0)
		call	sub_1329
		jp	z, loc_1071
		call	sub_115F
		jp	z, loc_1075
		call	sub_1319
		jp	z, loc_1079
		ret
;
loc_FF1:	ld	hl, (word_3E2)
		rlca
		rlca
		rlca
		rlca
		ld	b, a
		cp	30h ; '0'
		jr	nz, loc_1009
		call	sub_130B
		jp	z, loc_107E
		call	sub_1304
		jp	z, loc_1082
loc_1009:	call	sub_114F
		jp	z, loc_1086
		call	sub_115F
		ret	nz
		ld	a, b
		cp	20h ; ' '
		jr	z, loc_108A
		jr	loc_108E
loc_101A:	ld	hl, (word_3E2)
		ld	b, a
		call	sub_114F
		jr	z, loc_1096
		call	sub_115F
		jr	z, loc_109B
		ret
;
loc_1029:	ld	hl, (word_3E2)
		call	sub_1304
		jr	z, loc_10A0
		call	sub_12F0
		ret	nz
		cp	2
		jr	z, loc_10A4
		jr	loc_10A8
;
loc_103B:	or	40h ; '@'
		or	c
		cp	76h ; 'v'
		ret	z
		jr	loc_10B0
;
loc_1043:	ld	a, 6
		or	c
		jr	loc_10B7
;
loc_1048:	ld	b, a
		ld	a, 46h ; 'F'
		or	c
loc_104C:	ld	c, a
		ld	a, b
		jr	loc_10C3
;
loc_1050:	ld	b, 0Ah
		cp	3
		ret	z
loc_1055:	or	b
		cp	b
		jr	z, loc_10B0
		xor	11h
		jr	loc_10B0
loc_105D:	ld	a, 3Ah ; ':'
		jr	loc_10C5
loc_1061:	ld	b, 50h ; 'P'
		or	b
		jr	loc_10BA
;
loc_1066:	or	70h ; 'p'
		jr	loc_104C
;
loc_106A:	ld	a, b
		ld	d, e
		ld	e, c
		ld	c, 36h ; '6'
		jr	loc_10CC
;
loc_1071:	ld	b, 2
		jr	loc_1055
;
loc_1075:	ld	a, 32h ; '2'
		jr	loc_10C5
;
loc_1079:	ld	b, 40h ; '@'
		or	b
		jr	loc_10BA
;
loc_107E:	ld	a, 0F9h	; ''
		jr	loc_10B0
;
loc_1082:	ld	d, 0F9h	; ''
		jr	loc_10B7
;
loc_1086:	ld	a, b
		inc	a
		jr	loc_10C5
;
loc_108A:	ld	a, 2Ah ; '*'
		jr	loc_10C5
;
loc_108E:	ld	a, 4Bh ; 'K'
		or	b
loc_1091:	ld	c, a
		ld	a, 0EDh	; ''
		jr	loc_10CC
;
loc_1096:	ld	c, 21h ; '!'
		ld	a, b
		jr	loc_10CC
;
loc_109B:	ld	c, 2Ah ; '*'
		ld	a, b
		jr	loc_10CC
;
loc_10A0:	ld	c, 22h ; '"'
		jr	loc_10CC
;
loc_10A4:	ld	a, 22h ; '"'
		jr	loc_10C5
;
loc_10A8:	rlca
		rlca
		rlca
		rlca
		or	43h ; 'C'
		jr	loc_1091

;----------------
loc_10B0:	ld	d, a
		ld	b, 1
		pop	hl
		pop	hl
		jr	loc_10D6
;
loc_10B7:	ld	e, a
		jr	loc_10BD
;
loc_10BA:	ld	e, 0EDh	; ''
		ld	d, a
loc_10BD:	ld	b, 2
		pop	hl
		pop	hl
		jr	loc_10D4
;
loc_10C3:	ld	d, e
		ld	e, c
loc_10C5:	ld	c, a
		ld	b, 3
		pop	hl
		pop	hl
		jr	loc_10D2
;
loc_10CC:	ld	b, 4
		pop	hl
		pop	hl
		ld	(hl), a
		inc	hl
loc_10D2:	ld	(hl), c
		inc	hl
loc_10D4:	ld	(hl), e
		inc	hl
loc_10D6:	ld	(hl), d
		inc	hl
		ld	a, b
		ld	(byte_399), a
		ret

; 64: DB
loc_10DD:	ld	a, (hl)
		cp	27h ; '''
		jr	z, loc_10E9
		call	sub_1136
		ret	nz
		ld	a, d
		jr	loc_10B0
;
loc_10E9:	call	sub_14A1
		ret	nc
		ld	a, b
		ld	(byte_399), a
		bit	3, (ix+0)
		jr	z, loc_1113
		ld	hl, (word_3E0)
		inc	hl
		pop	de
		pop	de
		call	sub_1625
		ex	de, hl
		ret

; 65: DA
loc_1102:	call	sub_114F
		ret	nz
		ld	a, e
		jr	loc_10B7

; 66: BER
loc_1109:	call	sub_1116
		pop	hl
		pop	hl
		add	hl, de
		ret

; 67..68: EQU..ORG
loc_1110:	call	sub_1121

; else (PN..END)
loc_1113:	pop	hl
		pop	hl
		ret

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

sub_1116:	call	sub_1136
		jp	nz, err_OPD
		ld	a, e
		ld	(byte_399), a
		ret

sub_1121:	call	sub_114F
		jp	nz, err_OPD
		ret
               
sub_1128:	push	hl
		ld	hl, tab_mc	; MC-Code-Tabelle
		ld	a, (byte_398)	; Token
		ld	c, a
		ld	b, 0
		add	hl, bc
		ld	a, (hl)		; MC-Code
		pop	hl
		ret

sub_1136:	call	sub_114F
		ret	nz
		ld	a, d
		or	a
		ret	nz
		ld	d, e
		ret

sub_113F:	call	sub_114F
		ret	nz
		dec	de
		dec	de
sub_1145:	ld	a, d
		ld	d, e
		bit	7, e
		jr	nz, loc_114D
		or	a
		ret

loc_114D:	inc	a
		ret

sub_114F:	push	hl
		call	sub_1172
		jr	nz, loc_115D
loc_1155:	ld	a, (hl)
		or	a
		jr	nz, loc_115D
		ld	de, (word_3E6)
loc_115D:	pop	hl
		ret

sub_115F:	ld	a, (hl)
		cp	'('
		ret	nz
		push	hl
		inc	hl
		call	sub_1172
		jr	nz, loc_115D
		ld	a, (hl)
		cp	')'
		jr	nz, loc_115D
		inc	hl
		jr	loc_1155

sub_1172:	push	bc
		push	de
		push	hl
		ld	hl, 0
		ld	(word_3E6), hl
		pop	hl
loc_117C:	push	hl
		ld	hl, byte_3E8
		ld	b, 0Ah
		call	empty		; fill B Bytes ab HL mit 00
		pop	hl
		call	sub_11A8
		jr	nc, loc_11A2
		bit	3, (ix+0)
		jr	z, loc_1196
		call	sub_125D
		jr	nc, loc_11A2
loc_1196:	ld	a, (hl)
		or	a
		jr	z, loc_119E
		cp	')'
		jr	nz, loc_117C
loc_119E:	cp	a
		pop	de
		pop	bc
		ret

loc_11A2:	ld	a, 1
		or	a
		pop	de
		pop	bc
		ret

sub_11A8:	ld	a, (hl)
		cp	'+'
		jr	z, loc_11D1
		cp	'-'
		jr	z, loc_11CE
loc_11B1:	cp	'L'
		jr	z, loc_11D5
		cp	'H'
		jr	z, loc_11D5
loc_11B9:	cp	'#'
		jr	z, loc_11F4
		cp	27h ; '''
		jr	z, loc_11FA
		call	sub_152C
		jr	c, sub_1209
		call	sub_1533
		jr	c, loc_1237
		jp	loc_125B

loc_11CE:	ld	(byte_3F0), a
loc_11D1:	inc	hl
		ld	a, (hl)
		jr	loc_11B1

loc_11D5:	ld	c, a
		inc	hl
		ld	a, (hl)
		cp	'('
		jr	nz, loc_11E4
		ld	a, c
		ld	(byte_3F1), a
		inc	hl
		ld	a, (hl)
		jr	loc_11B9

loc_11E4:	dec	hl
		jr	loc_11B9

;???
		ex	af, af'		;'
		ld	a, (device)	; device 0 console, 1 tape
		or	a
		ld	a, 0
		ld	(device), a	; device 0 console, 1 tape
		jr	nz, loc_125B
		ex	af, af'		;'
loc_11F4:	ld	(byte_3E8), a
		inc	hl
		jr	loc_124D

loc_11FA:	call	sub_14A1
		dec	b
		jr	nz, loc_125B
		dec	hl
		ld	a, (hl)
		ld	(word_3EE), a
		inc	hl
		inc	hl
		jr	loc_124D

sub_1209:	push	hl
		ld	b, 0
loc_120C:	inc	hl
		inc	b
		call	sub_129D
		jr	nz, loc_120C
		dec	hl
		dec	b
		ld	a, (hl)
		pop	hl
		cp	48h ; 'H'
		jr	z, loc_1225
		cp	42h ; 'B'
		jr	z, loc_122B
		inc	b
		call	sub_14AF
		jr	loc_122F

loc_1225:	call	sub_14D8
		inc	de
		jr	loc_122F

loc_122B:	call	sub_14F8
		inc	de
loc_122F:	jr	nc, loc_125B
		ld	(word_3EE), hl
		ex	de, hl
		jr	loc_124D

loc_1237:	push	hl
		ld	b, 0
loc_123A:	inc	hl
		inc	b
		call	sub_129D
		jr	nz, loc_123A
		pop	hl
		call	sub_1417
		jr	nc, loc_125B
		ld	de, byte_3E8
		call	sub_1625
loc_124D:	ld	a, (byte_3F1)
		or	a
		ccf
		ret	z
		ld	a, (hl)
		cp	')'
		jr	nz, loc_125B
		inc	hl
		scf
		ret

loc_125B:	or	a
		ret

sub_125D:	push	hl
		ld	hl, (word_3EE)
		ld	a, (byte_3E8)
		or	a
		jr	z, loc_1276
		cp	'#'
		jr	z, loc_1298
		call	sub_1473
		ld	bc, 5
		add	hl, bc
		ld	e, (hl)
		inc	hl
		ld	d, (hl)
		ex	de, hl
loc_1276:	ld	a, (byte_3F1)
		or	a
		jr	z, loc_1283
		cp	4Ch ; 'L'
		jr	z, loc_1281
		ld	l, h
loc_1281:	ld	h, 0
loc_1283:	ex	de, hl
		ld	hl, (word_3E6)
		ld	a, (byte_3F0)
		or	a
		jr	z, loc_1295
		sbc	hl, de
loc_128F:	ld	(word_3E6), hl
		scf
		pop	hl
		ret

loc_1295:	add	hl, de
		jr	loc_128F

loc_1298:	ld	hl, (unk_330)
		jr	loc_1276

sub_129D:	ld	a, (hl)
		or	a
		ret	z
		cp	'+'
		ret	z
		cp	'-'
		ret	z
		cp	')'
		ret

sub_12A9:	push	hl
		ld	hl, (word_3E0)
		jr	loc_12B3

sub_12AF:	push	hl
		ld	hl, (word_3E2)
loc_12B3:	ld	a, (hl)
		or	a
		jp	nz, err_OPD
		pop	hl
		ret

sub_12BA:	inc	hl
		ld	a, (hl)
		dec	hl
		or	a
		ret	nz
		ld	a, (hl)
		sub	41h ; 'A'
		jr	z, loc_12D5
		dec	a
		cp	4
		jr	nc, loc_12CB
		cp	a
		ret

loc_12CB:	sub	2
		cp	4
		ret	z
		sub	3
		cp	5
		ret

loc_12D5:	ld	a, 7
		ret

sub_12D8:	call	sub_12BA
		ret	z
		cp	6
		ret	z
		call	sub_1329
		ret	nz
		cp	2
		ret	nz
		ld	a, 6
		ret

sub_12E9:	call	sub_12BA
		ret	nz
		cp	7
		ret

sub_12F0:	push	hl
		push	bc
		call	sub_1360
loc_12F5:	jr	nz, loc_12F9
		ld	a, (hl)
		or	a
loc_12F9:	ld	a, b
		pop	bc
		pop	hl
		ret

sub_12FD:	push	hl
		push	bc
		call	sub_1377
		jr	loc_12F5

sub_1304:	push	hl
		push	bc
		call	sub_1380
		jr	loc_12F5

sub_130B:	call	sub_12F0
		ret	nz
		cp	2
		ret
		call	sub_12F0
		ret	nz
		cp	3
		ret

sub_1319:	push	hl
		push	bc
		ld	b, 7
		ld	a, (hl)
		inc	hl
		cp	'I'
		jr	z, loc_12F5
		ld	b, 0Fh
		cp	'R'
		jr	loc_12F5

sub_1329:	ld	a, (hl)
		cp	'('
		ret	nz
		push	hl
		push	bc
		inc	hl
		call	sub_1360
		jr	nz, loc_12F9
loc_1335:	ld	a, (hl)
		inc	hl
		cp	')'
		jr	loc_12F5

sub_133B:	ld	a, (hl)
		cp	'('
		ret	nz
		push	hl
		push	bc
		inc	hl
		call	sub_1380
		jr	nz, loc_12F9
		ld	e, 0
		ld	a, (hl)
		cp	')'
		jr	z, loc_1335
		call	sub_1172
		jr	nz, loc_12F9
		ld	c, d
		ld	de, (word_3E6)
		call	sub_1145
		ld	d, c
		jr	nz, loc_12F9
		jr	loc_1335

sub_1360:	call	sub_1391
		cp	'S'
		jr	z, loc_1398
loc_1367:	dec	b
		cp	'H'
		jr	z, loc_139C
		dec	b
		cp	'D'
		jr	z, loc_13A0
		dec	b
		cp	'B'
		jr	z, loc_13A4
		ret

sub_1377:	call	sub_1391
		cp	'A'
		jr	z, loc_13A8
		jr	loc_1367

sub_1380:	call	sub_1391
		cp	'I'
		ret	nz
		ld	a, c
		cp	'X'
		jr	z, loc_13AC
		cp	'Y'
		ret	nz
		ld	b, 0FDh
		ret

sub_1391:	ld	a, (hl)
		inc	hl
		ld	c, (hl)
		inc	hl
		ld	b, 3
		ret

loc_1398:	ld	a, c
		cp	'P'
		ret

loc_139C:	ld	a, c
		cp	'L'
		ret

loc_13A0:	ld	a, c
		cp	'E'
		ret

loc_13A4:	ld	a, c
		cp	'C'
		ret

loc_13A8:	ld	a, c
		cp	'F'
		ret

loc_13AC:	ld	b, 0DDh
		ret

sub_13AF:	push	hl
		push	de
		push	bc
		push	hl
		push	hl
		push	bc
		ld	hl, unk_3DC
		push	hl
		ld	b, 4
		ld	a, ' '
		call	fill		; fill B Bytes ab HL mit A
		pop	de
		pop	bc
		pop	hl
		call	sub_1625
		pop	de
		ld	hl, LstTok2	; zweibuchstabig
		ld	a, b
		cp	5
		jp	nc, err_MNE	; Kommando zu lang
	if codebase=0
		cp	1
		jp	z, err_MNE	; Kommando zu kurz
	endif
		cp	2
		jr	z, loc_13E3
		ld	hl, LstTok3	; 3buchstabig
		cp	3
		jr	z, loc_13E3
		ld	hl, LstTok4	; 4buchstabig
loc_13E3:	ld	a, (hl)
		or	a
		jp	z, err_MNE
		push	bc
		push	de
		call	sub_1610
		pop	de
		jr	z, loc_13F7
loc_13F0:	inc	hl
		djnz	loc_13F0
		pop	bc
		inc	hl
		jr	loc_13E3

loc_13F7:	pop	bc
		ld	a, (hl)
		scf
		pop	bc
		pop	de
		pop	hl
		ret

sub_13FE:	ld	a, (hl)
		call	sub_152C
		ret	nc
		ld	b, 0
		push	hl
loc_1406:	inc	hl
		inc	b
		ld	a, (hl)
		call	sub_152C
		jr	c, loc_1406
		pop	de
		ex	de, hl
		call	sub_14AF
		jp	nc, err_LNR
		ret

sub_1417:	ld	a, b
		or	a
		ret	z
		cp	6
		ret	nc
		push	hl
		push	bc
		ld	a, (hl)
		call	sub_1533
		jr	nc, loc_144E
		call	sub_12D8
		jr	z, loc_144E
		call	sub_12F0
		jr	z, loc_144E
		call	sub_12FD
		jr	z, loc_144E
		call	sub_1304
		jr	z, loc_144E
		call	sub_1319
		jr	z, loc_144E
		pop	bc
		push	bc
loc_1440:	ld	a, (hl)
		call	sub_1533
		call	nc, sub_152C
		jr	nc, loc_144E
		inc	hl
		djnz	loc_1440
		jr	loc_144F

loc_144E:	or	a
loc_144F:	pop	bc
		pop	hl
		ret

sub_1452:	push	de
		ld	(unk_34A), hl
		ld	hl, (tb_anf)
loc_1459:	call	sub_C81
		jr	nc, loc_1471
		push	hl
		ld	e, (hl)
		inc	hl
		ld	d, (hl)
		ld	hl, (unk_34A)
		ex	de, hl
		call	sub_1618
		pop	hl
		jr	c, loc_1471
		call	sub_C76
		jr	loc_1459
loc_1471:	pop	de
		ret

sub_1473:	push	de
		ld	hl, (tb_anf)
		call	sub_148A
		jp	nc, err_NDS
		push	hl
		call	sub_C76
		call	sub_148A
		jp	c, err_MDS
		pop	hl
		pop	de
		ret

sub_148A:	call	sub_C81
		ret	nc
		push	hl
		ld	de, 7
		add	hl, de
		ld	de, byte_3E8
		call	sub_1607
		pop	hl
		scf
		ret	z
		call	sub_C76
		jr	sub_148A

sub_14A1:	ld	b, 0FFh
loc_14A3:	inc	b
		inc	hl
		ld	a, (hl)
		cp	27h ; '''
		jr	nz, loc_14A3
		ld	a, c
		or	a
		ret	z
		scf
		ret

sub_14AF:	ex	de, hl
		ld	hl, 0
loc_14B3:	ld	a, (de)
		call	sub_152C
		ret	nc
		sub	30h ; '0'
		add	hl, hl
		ccf
		ret	nc
		push	bc
		ld	b, h
		ld	c, l
		add	hl, hl
		jr	c, loc_14D5
		add	hl, hl
		jr	c, loc_14D5
		add	hl, bc
		jr	c, loc_14D5
		ld	b, 0
		ld	c, a
		add	hl, bc
		jr	c, loc_14D5
		inc	de
		pop	bc
		djnz	loc_14B3
		scf
		ret

loc_14D5:	pop	bc
		ccf
		ret

sub_14D8:	ex	de, hl
		ld	hl, 0
loc_14DC:	ld	a, (de)
		call	sub_150F
		ret	nc
		add	hl, hl
		ccf
		ret	nc
		add	hl, hl
		ccf
		ret	nc
		add	hl, hl
		ccf
		ret	nc
		add	hl, hl
		ccf
		ret	nc
		push	bc
		ld	b, 0
		ld	c, a
		add	hl, bc
		pop	bc
		inc	de
		djnz	loc_14DC
		scf
		ret

sub_14F8:	ex	de, hl
		ld	hl, 0
loc_14FC:	ld	a, (de)
		call	sub_1521
		ret	nc
		add	hl, hl
		ccf
		ret	nc
		push	bc
		ld	b, 0
		ld	c, a
		add	hl, bc
		pop	bc
		inc	de
		djnz	loc_14FC
		scf
		ret

; hex-ascii->ziffer
sub_150F:	call	sub_152C
		jr	c, loc_151D
		cp	41h ; 'A'
		ccf
		ret	nc
		cp	47h ; 'G'
		ret	nc
		sub	7
loc_151D:	sub	30h ; '0'
		scf
		ret

; ascii 0/1->ziffer
sub_1521:	cp	30h ; '0'
		ccf
		ret	nc
		cp	32h ; '2'
		ret	nc
		sub	30h ; '0'
		scf
		ret

; isdecimal test ascii 0..9
sub_152C:	cp	3Ah ; ':'
		ret	nc
		cp	30h ; '0'
		ccf
		ret

; isalpha test ascii A..Z + 3 Sonderzeichen
sub_1533:	cp	5Bh ; '['
		ret	nc
		cp	41h ; 'A'
		ccf
		ret
		cp	' '
		ret	z
		cp	','
		ret	z
		cp	0Dh
		ret

;------------------------------------------------------------------------------
; Ausgabe HL dezimal
;------------------------------------------------------------------------------

outdez:		ld	bc, 10000
		call	sub_155C
		ld	bc, 1000
		call	sub_155C
		ld	bc, 100
		call	sub_155C
		ld	c, 10
		call	sub_155C
		ld	c, 1
sub_155C:	ld	a, 0FFh
loc_155E:	inc	a
		or	a
		sbc	hl, bc
		jr	nc, loc_155E
		add	hl, bc
		add	a, 30h ; '0'	; to ascii
		jr	loc_1581       	; outa + ret

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

; Ausgabe HL hexadezimal
outhl:		ld	a, h
		call	outhx		; Ausgabe A hexadezimal
		ld	a, l

; Ausgabe A hexadezimal
outhx:		push	af
		rrca
		rrca
		rrca
		rrca
		call	sub_1577
		pop	af
sub_1577:	and	0Fh
		add	a, 30h ; '0'
		cp	3Ah ; ':'
		jr	c, loc_1581
		add	a, 7
loc_1581:	jp	outa		; Zeichenausgabe

; Ausgabe Zeichenkette + Eingabe
input:		ld	c, PRNST	; Ausgabe einer	Zeichenkette zu	CONST
		call	BOS
sub_1589:	ld	c, RCONB	; Eingabe einer	Zeichenkette von CONST
		ld	de, CONBU
		call	BOS
		call	0F5B9h
		ret

sub_1595:	call	sub_1589
		jr	c, loc_15BE
sub_159A:	call	0F1EAh
		ld	hl, INTLN
		ld	d, 0
		ld	a, (hl)
		ld	e, a
		add	hl, de
		inc	hl
		ld	(hl), 0
		ld	hl, INTLN+1
		xor	a
		ld	(byte_3F1), a
		call	sub_1209
		ret	nz
		ex	de, hl
		ld	c, 0FFh
		ex	af, af'		;'
		jr	c, loc_15BD
		ex	af, af'		;'
		ret
;???
		db  0Eh
		db    0

loc_15BD:	ex	af, af'		;'
loc_15BE:	ld	a, 0Dh
		ret

sub_15C1:	call	sub_15EC
		ld	a, (hl)
		or	a
		jr	z, loc_15E5
		call	sub_13FE
		jr	nc, loc_15DF
		ld	d, h
		ld	e, l
		call	sub_1452
		jr	nc, loc_15DF
		push	hl
		ld	hl, (word_3E2)
		ld	a, (hl)
		or	a
		jr	z, loc_15E3
		call	sub_13FE
loc_15DF:	jp	nc, err_LNR
		ex	de, hl
loc_15E3:	pop	hl
		ret

loc_15E5:	ld	hl, (tb_anf)
		ld	de, 0FFFFh
		ret

sub_15EC:	ld	hl, unk_39C
		ld	bc, 0FFFFh
		xor	a
		cpir
		cpir
		ld	(word_3E0), hl
		push	hl
		cpir
		ld	(word_3E2), hl
		cpir
		ld	(word_3E4), hl
		pop	hl
		ret

sub_1607:	ld	a, (de)
		cp	(hl)
		ret	nz
		or	a
		ret	z
		inc	hl
		inc	de
		jr	sub_1607

sub_1610:	ld	a, (de)
		cp	(hl)
		ret	nz
		inc	de
		inc	hl
		djnz	sub_1610
		ret

sub_1618:	push	hl
		or	a
		sbc	hl, de
		ccf
		pop	hl
		ret

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

; fill B Bytes ab HL mit 00
empty:		xor	a

; fill B Bytes ab HL mit A
fill:		ld	(hl), a
		inc	hl
		djnz	fill		; fill B Bytes ab HL mit A
		ret
sub_1625:		ld	a, b
		or	a
		ret	z
		push	bc
		ld	c, b
		ld	b, 0
		ldir
		pop	bc
		ret

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

; call (hl)
callhl:		jp	(hl)


;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

; Ausgabe B Zeichen ab HL
print:		ld	a, (hl)
		call	outa		; Zeichenausgabe
		inc	hl
		djnz	print		; Ausgabe B Zeichen ab HL
		ret

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

; Ausgabe Space+CR
sub_1639:		ld	a, ' '
		call	outa		; Zeichenausgabe
		ld	a, 0Dh
		jp	outa		; Zeichenausgabe

;???
		or      a
		ret     pe
		xor     80h ; ''
		ret

;------------------------------------------------------------------------------
; Kommandos + Token
;------------------------------------------------------------------------------

; U880-Befehle 00..62h
; Pseudo-Assembleranweisungen 64h..6Ah
; interaktive Direkt-Kommandos (6Eh) 70h..7Dh

; zweibuchstabig
LstTok2:	db "LD", 62h
		db "OR", 5Ch
		db "JR", 32h
		db "RZ", 13h
		db "RR", 4Fh
		db "RP", 10h
		db "RM", 0Dh
		db "RL", 4Dh
		db "RC", 0Ch
		db "PN", 69h
		db "DA", 65h
		db "DB", 64h
		db "DI",   3
		db "EX", 4Ah
		db "IN", 37h
		db "EI",   4
		db "DR", 76h
		db "DS", 77h
		db "CM", 75h
		db    0

; dreibuchstabig
LstTok3:	db "ADC", 5Fh
		db "ADD", 61h
		db "AND", 5Ah
		db "BER", 66h
		db "BIT", 54h
		db "CAC", 39h
		db "CAM", 3Bh
		db "CAP", 3Eh
		db "CAZ", 41h
		db "CCF",   0
		db "CMP", 5Eh
		db "CPD", 18h
		db "CPI", 1Ah
		db "CPL",   1
		db "DAA",   2
		db "DEC", 59h
		db "END", 6Ah
		db "EQU", 67h
		db "EXX",   6
		db "IM0", 1Ch
		db "IM1", 1Dh
		db "IM2", 1Eh
		db "INC", 58h
		db "IND", 1Fh
		db "INF", 23h
		db "INI", 21h
		db "JMP", 57h
		db "JPC", 42h
		db "JPM", 43h
		db "JPP", 46h
		db "JPZ", 49h
		db "JRC", 33h
		db "JRZ", 36h
		db "LDD", 24h
		db "LDI", 26h
		db "NEG", 28h
		db "NOP",   8
		db "ORG", 68h
		db "OUT", 38h
		db "POP", 4Bh
		db "PUT", 73h
		db "RES", 55h
		db "RET",   9
		db "RLA", 0Ah
		db "RLC", 4Eh
		db "RLD", 2Dh
		db "RNC", 0Eh
		db "RNZ", 0Fh
		db "RPE", 11h
		db "RPO", 12h
		db "RRA", 14h
		db "RRC", 50h
		db "RRD", 2Eh
		db "RST", 17h
		db "RUN", 7Ch
		db "SBC", 60h
		db "SCF", 16h
		db "SET", 56h
		db "SLA", 51h
		db "SRA", 52h
		db "SRL", 53h
		db "SUB", 5Bh
		db "XOR", 5Dh
		db    0

; 4buchstabig
LstTok4:	db "CALL", 3Ah
		db "CANC", 3Ch
		db "CANZ", 3Dh
		db "CAPE", 3Fh
		db "CAPO", 40h
		db "CPDR", 19h
		db "CPIR", 1Bh
		db "DJNZ", 31h
		db "EXAF",   5
		db "HALT",   7
		db "INDR", 20h
		db "INIR", 22h
		db "JPNC", 44h
		db "JPNZ", 45h
		db "JPPE", 47h
		db "JPPO", 48h
		db "JRNC", 34h
		db "JRNZ", 35h
		db "LDDR", 25h
		db "LDIR", 27h
		db "OTDR", 2Ah
		db "OTIR", 2Ch
		db "OUTD", 29h
		db "OUTI", 2Bh
		db "PUSH", 4Ch
		db "RETI", 2Fh
		db "RETN", 30h
		db "RLCA", 0Bh
		db "RRCA", 15h
		db "WRIT", 7Ah
		db "STEP", 7Dh
		db "READ", 7Bh
		db "MCSV", 70h
		db "LIST", 79h
		db "KILL", 78h
		db "ASGN", 74h
		db "ADDR", 73h
		db    0

;------------------------------------------------------------------------------
; MC-Code-Tabelle (token -> code)
;------------------------------------------------------------------------------

tab_mc:		db  3Fh		; 00h CCF 
		db  2Fh		; 01h CPL 
		db  27h		; 02h DAA 
		db 0F3h		; 03h DI  
		db 0FBh		; 04h EI  
		db  08h		; 05h EXAF
		db 0D9h		; 06h EXX 
		db  76h		; 07h HALT
		db  00h		; 08h NOP 
		db 0C9h		; 09h RET 
		db  17h		; 0Ah RLA 
		db  07h		; 0Bh RLCA
		db 0D8h		; 0Ch RC  
		db 0F8h		; 0Dh RM  
		db 0D0h		; 0Eh RNC 
		db 0C0h		; 0Fh RNZ 
		db 0F0h		; 10h RP  
		db 0E8h		; 11h RPE 
		db 0E0h		; 12h RPO 
		db 0C8h		; 13h RZ  
		db  1Fh		; 14h RRA 
		db  0Fh		; 15h RRCA
		db  37h		; 16h SCF 
		db 0C7h		; 17h RST 
		db 0A9h		; 18h CPD 
		db 0B9h		; 19h CPDR
		db 0A1h		; 1Ah CPI 
		db 0B1h		; 1Bh CPIR
		db  46h		; 1Ch IM0 
		db  56h		; 1Dh IM1 
		db  5Eh		; 1Eh IM2 
		db 0AAh		; 1Fh IND 
		db 0BAh		; 20h INDR
		db 0A2h		; 21h INI 
		db 0B2h		; 22h INIR
		db  70h		; 23h INF 
		db 0A8h		; 24h LDD 
		db 0B8h		; 25h LDDR
		db 0A0h		; 26h LDI 
		db 0B0h		; 27h LDIR
		db  44h		; 28h NEG 
		db 0ABh		; 29h OUTD
		db 0BBh		; 2Ah OTDR
		db 0A3h		; 2Bh OUTI
		db 0B3h		; 2Ch OTIR
		db  6Fh		; 2Dh RLD 
		db  67h		; 2Eh RRD 
		db  4Dh		; 2Fh RETI
		db  45h		; 30h RETN
		db  10h		; 31h DJNZ
		db  18h		; 32h JR  
		db  38h		; 33h JRC 
		db  30h		; 34h JRNC
		db  20h		; 35h JRNZ
		db  28h		; 36h JRZ 
		db 0DBh		; 37h IN  
		db 0D3h		; 38h OUT 
		db 0DCh		; 39h CAC 
		db 0CDh		; 3Ah CALL
		db 0FCh		; 3Bh CAM 
		db 0D4h		; 3Ch CANC
		db 0C4h		; 3Dh CANZ
		db 0F4h		; 3Eh CAP 
		db 0ECh		; 3Fh CAPE
		db 0E4h		; 40h CAPO
		db 0CCh		; 41h CAZ 
		db 0DAh		; 42h JPC 
		db 0FAh		; 43h JPM 
		db 0D2h		; 44h JPNC
		db 0C2h		; 45h JPNZ
		db 0F2h		; 46h JPP 
		db 0EAh		; 47h JPPE
		db 0E2h		; 48h JPPO
		db 0CAh		; 49h JPZ 
		db 0E3h		; 4Ah EX  
		db 0C1h		; 4Bh POP 
		db 0C5h		; 4Ch PUSH
		db  10h		; 4Dh RL  
		db    0		; 4Eh RLC 
		db  18h		; 4Fh RR  
		db  08h		; 50h RRC 
		db  20h		; 51h SLA 
		db  28h		; 52h SRA 
		db  38h		; 53h SRL 
		db  40h		; 54h BIT 
		db  80h		; 55h RES 
		db 0C0h		; 56h SET 
		db 0E9h		; 57h JMP 
		db    4		; 58h INC 
		db    5		; 59h DEC 
		db 0A0h		; 5Ah AND 
		db  90h		; 5Bh SUB 
		db 0B0h		; 5Ch OR  
		db 0A8h		; 5Dh XOR 
		db 0B8h		; 5Eh CMP 
		db  88h		; 5Fh ADC 
		db  98h		; 60h SBC 
		db  80h		; 61h ADD 
		db  40h		; 62h LD  

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

; Eingabe Zeichen (mit Ausgabe)
inch:		push	bc
		ld	c, CONSI	; Eingabe eines	Zeichens von CONST
		call	BOS
		pop	bc

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

; Zeichenausgabe
	if codebase=0
outa:		push	bc
		push	de
		push	af
		cp	0Dh		; CR->CRLF
		jr	nz, outa1
		ld	c, CONSO
		ld	e, a
		call	BOS
		ld	a, 0Ah
outa1:		ld	c, CONSO	; Ausgabe eines	Zeichens zu CONST
		ld	e, a
		call	BOS
		pop	af
		push	af
		cp	8
		jr	nz, outa2
		ld	e, ' '
		call	BOS
		ld	e, 8
		call	BOS
outa2:		pop	af
		pop	de
		pop	bc
		ret
	else
outa:           push    bc
                push    de
                push    af
                cp      0Dh
                jr      z, outa2
outa1:          ld      c, 2
                ld      e, a
                call    5
                pop     af
                pop     de
                pop     bc
                ret
;
outa2:          ld      c, 2
                ld      e, a
                call    5
                ld      a, 0Ah
                jr      outa1
	endif

aDeviceTC:	db "DEVICE (T/(C))? ",0
aFilename:	db "FILENAME:",0

sub_18E7:	push	hl
		ld	de, aDeviceTC	; "DEVICE (T/(C))? "
		call	input		; Ausgabe Zeichenkette + Eingabe
		ld	a, 0
		jr	c, loc_18FC
		ld	a, (CONBU+2)
		cp	'T'
		ld	a, 0
		jr	nz, loc_18FC
		inc	a
loc_18FC:	ld	(device), a	; device 0 console, 1 tape
		or	a
		pop	hl
		ret	z
		push	hl
		ld	de, aFilename	; "FILENAME:"
		call	input		; Ausgabe Zeichenkette + Eingabe
		call	0F1EAh
		jr	z, loc_1953
		ex	af, af'		;'
		jr	nc, loc_1953
		ld	a, (INTLN)
		cp	9
		jr	nc, loc_1953
		call	sub_193F
		ld	hl, 0F000h
		ld	(AADR),	hl	; AADR
		ld	(EADR),	hl	; EADR
		ld	hl, 0FFFFh
		ld	(SADR),	hl	; SADR
		ld	hl, INTLN
		ld	(BUFADR), hl	; SBY
		ld	c, OPENW	; Erffnen Kassette schreiben
		call	BOS
		ld	hl, INTLN
		ld	b, 80h ; ''
		call	empty		; fill B Bytes ab HL mit 00
		pop	hl
		ret

sub_193F:	ld	de, FCB
		ld	a, 8
		call	0F588h
		ld	hl, 5854h	; TXT
		ld	(FTYP), hl
		ld	a, 'T'
		ld	(FTYP+2), a
		ret

loc_1953:	jp	err_IO

sub_1956:	push	hl
		ld	de, aDeviceTC	; "DEVICE (T/(C))? "
		call	input		; Ausgabe Zeichenkette + Eingabe
		ld	a, 0
		jr	c, loc_196B
		ld	a, (CONBU+2)
		cp	'T'
		ld	a, 0
		jr	nz, loc_196B
		inc	a
loc_196B:	ld	(device), a	; device 0 console, 1 tape
		or	a
		pop	hl
		ret	z
		push	hl
		push	de
		ex	de, hl
		ld	hl, (tb_pos)
		ld	(tb_pos), de
		push	hl
		sbc	hl, de
		ld	c, l
		ld	b, h
		pop	hl
		ld	(unk_75), bc
		jr	z, loc_1992
		ld	de, (tb_end)
		dec	hl
		lddr
		ld	(tb_end), de
loc_1992:	ld	de, aFilename	; "FILENAME:"
		call	input		; Ausgabe Zeichenkette + Eingabe
		jr	c, loc_19CC
		call	0F1EAh
		jr	z, loc_19CC
		ex	af, af'		;'
		jr	nc, loc_19CC
		ld	a, (INTLN)
		cp	9
		jr	nc, loc_19CC
		call	sub_193F
		ld	hl, INTLN
		ld	(DMA), hl
		ld	c, OPENR	; Erffnen Kassette lesen
		call	BOS
		jr	c, loc_19CC
		ld	hl, INTLN
		ld	(BUFADR), hl	; IO-Buffer-Adresse
		ld	(DMA), hl
		ld	c, READS	; Lesen	eines Blockes von Kassette
		call	BOS
		jr	c, loc_19CC
		pop	de
		pop	hl
		ret

loc_19CC:	call	sub_8CE
		jp	err_IO

loc_19D2:	push	bc
		ld	c, 1
		call	sub_19DD
		call	outa		; Zeichenausgabe
loc_19DB:	pop	bc
		ret

sub_19DD:	ld	a, (device)	; device 0 console, 1 tape
		or	a
		jp	z, BOS
		push	hl
		push	de
		ld	hl, (BUFADR)	; IO-Buffer-Adresse
		ld	bc, INTLN+80h
		sbc	hl, bc
		ld	hl, (BUFADR)	; IO-Buffer-Adresse
		jr	nz, loc_1A19
		ld	hl, INTLN
		ld	(DMA), hl
		ld	(BUFADR), hl	; IO-Buffer-Adresse
		ld	a, (BLNR)
		inc	a
		jr	nz, loc_1A06
		ld	a, 3
		jr	loc_1A1E

loc_1A06:	ld	c, READS	; Lesen	eines Blockes von Kassette
		call	BOS
		jr	nc, loc_1A19
		ld	c, CONSI
		call	BOS
		cp	3
		jp	z, err_IO
		jr	loc_1A06
loc_1A19:	ld	a, (hl)
		inc	hl
		ld	(BUFADR), hl	; IO-Buffer-Adresse
loc_1A1E:	pop	de
		pop	hl
		pop	bc
		jp	loc_19DB

; Ausgabe E (nur wenn Z-Flag gesetzt), Ausgabe A
loc_1A24:	push	bc
		push	de
		push	af
		call	sub_1A37
		ld	c, CONSO	; Ausgabe eines	Zeichens zu CONST
		call	z, BOS
		pop	af
		ld	e, a
		call	BOS
		pop	de
		pop	bc
		ret

sub_1A37:	ld	c, a
		ld	a, (device)	; device 0 console, 1 tape
		or	a
		ld	a, c
		jr	nz, loc_1A44
loc_1A3F:	cp	0Dh
		ld	e, 0Ah
		ret

loc_1A44:	ld	bc, (BUFADR)	; IO-Buffer-Adresse
		ld	(bc), a
		inc	bc
		ld	(BUFADR), bc	; IO-Buffer-Adresse
		push	hl
		ld	hl, INTLN+80h
		sbc	hl, bc
		pop	hl
		jr	nz, loc_1A3F
; Bufferende erreicht -	Block schreiben
		ld	bc, INTLN
		ld	(BUFADR), bc	; IO-Buffer-Adresse
		ld	(DMA), bc
		ld	c, WRITS	; Schreiben eines Blockes auf Kassette
		call	BOS
		push	hl
		ld	hl, INTLN
		ld	b, 80h ; ''
		call	empty		; fill B Bytes ab HL mit 00
		pop	hl
		ld	a, (INTLN+07Fh)
		jr	loc_1A3F

aStartadr_:	db "STARTADR.: ",0

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------

mcsv:		ld	a, (hl)
		or	a
		jr	z, loc_1AB6
		call	sub_B3A
		set	3, (ix+0)
		call	sub_15EC
		call	sub_114F
		jp	nz, err_OPD
		ld	(stack), de
		ld	hl, (word_3E2)
		ld	a, (hl)
		or	a
		jr	z, loc_1ABC
		call	sub_114F
		jp	nz, err_OPD
		ld	(device), de	; device 0 console, 1 tape
		ld	hl, (stack)
		ex	de, hl
		sbc	hl, de
		jp	c, err_OPD
		jr	loc_1AC2

loc_1AB6:	ld	hl, (mc_anf)
		ld	(stack), hl
loc_1ABC:	ld	hl, (mc_pos)
		ld	(device), hl	; device 0 console, 1 tape
loc_1AC2:	ld	de, aFilename	; "FILENAME:"
		call	input		; Ausgabe Zeichenkette + Eingabe
		jp	c, err_IO
		call	0F1EAh
		jp	z, err_IO
		ex	af, af'		;'
		jp	nc, err_IO
		ld	a, (INTLN)
		cp	9
		jp	nc, err_IO
		ld	de, FCB
		ld	a, 8
		call	0F588h
		ld	hl, 4F43h	; COM
		ld	(FTYP), hl
		ld	a, 4Dh ; 'M'
		ld	(FTYP+2), a
		ld	hl, (stack)
		ld	(AADR),	hl
		ld	hl, (device)	; device 0 console, 1 tape
		ld	(EADR),	hl
		ld	de, aStartadr_	; "STARTADR.: "
		call	input		; Ausgabe Zeichenkette + Eingabe
		jr	c, loc_1B14
		ld	hl, 82h	; ''
		set	3, (ix+0)
		call	sub_114F
		ex	de, hl
		ld	(SADR),	hl
		jr	loc_1B1A

loc_1B14:	ld	hl, (mc_anf)
		ld	(SADR),	hl
loc_1B1A:	ld	c, OPENW
		call	BOS
		call	0F310h
		ld	hl, (stack)
		ld	de, (device)	; device 0 console, 1 tape
		ld	(DMA), hl
loc_1B2C:	ld	c, WRITS
		call	BOS
		call	0F310h
		call	sub_1BB4
		ld	hl, (DMA)
		ld	bc, 80h
		add	hl, bc
		sbc	hl, de
		jr	c, loc_1B2C
		ld	c, CLOSW
		call	BOS
loc_1B47:	ld	de, aVerifyYN
		call	input		; Ausgabe Zeichenkette + Eingabe
		jr	c, loc_1B8F
		ld	a, (CONBU+2)
		cp	'N'
		jr	z, loc_1B8F
		ld	de, aRewind
		call	input		; Ausgabe Zeichenkette + Eingabe
loc_1B5C:	ld	c, OPENR
		ld	hl, CONBU
		ld	(DMA), hl
		call	BOS
		jr	nc, loc_1B74
		ld	c, CSTS
		call	BOS
		cp	3
		jr	z, loc_1B8F
		jr	loc_1B5C

loc_1B74:	ld	hl, CONBU
		ld	(DMA), hl
		ld	c, READS
		call	BOS
		jr	c, loc_1B8F
		or	a
		jr	nz, loc_1B8F
		ld	c, CSTS
		call	BOS
		cp	3
		jr	z, loc_1B8F
		jr	loc_1B74

loc_1B8F:	jp	0F2FEh

aVerifyYN:	db 0Ah
		db 0Dh,"VERIFY (Y/N)? ",0
aRewind:	db 0Eh,4,"< < REWIND !",0Eh,2,0

sub_1BB4:	call	0FD33h
		ei
		cp	3
		ret	nz
		call	inch		; Eingabe Zeichen (mit Ausgabe)
		jp	err_IO

		end

;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------
