;STC-USB-PLAYER VERSION FR KC87/Z9001
;-------------------------------------------------
;WERO, 12/2017
;VP 12/2025 Anpassung Arnold-Assembler
;	Umstellung auf CALL5-Funktionen fr alle EOS-Systeme
;-------------------------------------------------


; Anpassung Arnold-Assembler
	cpu	z80

DEFM	macro	x
	IFNB X
	       	DB  (X)
		shift
	        DEFM ALLARGS
        endif
	endm

DEFS	macro	a,b
	ifb	b
		ds	a
	else
		db	a dup(b)
	endif
	endm

     INTSYNTAX +$hex		; # --> $

hi              function x,(x>>8)&255
lo              function x, x&255

CONBU		equ	80h
fcb		equ	05Ch

;-------------------------------------------------
;IN STANDARD-INCLUDE:
;X0001:     EQU     38H         ;AY-BASISADRESSE
;X0002:     EQU     3CH         ;CTC-BASISADRESSE
;X0003:     EQU     0210H       ;INTERRUPTTABELLE CTC
;-------------------------------------------------
USBPIO:     EQU     0DCH        ;USB.PIO:   DC/DD/DE/DF
START:      EQU     4000H       ;PROGRAMMANFANG
WORK:       EQU     START+10H   ;BEGINN ARBEITSZELLEN
KAT:        EQU     2000H       ;3FFF = 8K FR 511 SONGS
FARB:       EQU     0E800H      ;FARBSPEICHER
ASCII:      EQU     0EC00H      ;ASCII-SPEICHER
BWS1:       EQU     0ED00H-2    ;SPALTE "000 VON ..."
;PROGRAMMKOPF FR USBX-----------------------------
            ORG     START-80H
            DEFM    "PLAY    "
            DEFM    "KCC"
            DEFW    0B800H      ;HIER LIEGT
            DEFW    0BCFFH      ;USB-LADEROUTINE
            DEFB    0
            DEFB    03          ;3 PARAMATER
            DEFW    START       ;ANFANGSADRESSE
            DEFW    SONG        ;ENDEADRESSE=SONGANFANG
            DEFW    START       ;STARTADRESSE
            DEFB    0
            DEFM    " EOS OS "  ;KENNUNG
            DEFS    64,0FFH     ;FREI
            DEFM    "*STC-EOS-PLAYER*"
            DEFM    "*KC87/Z9001*V.1*"
;PROGRAMMKOPF FR Z9001---------------------------
            JP      START0
            DEFM    "PLAY    ",0,0
;-------------------------------------------------
	ORG         WORK                ;ARBEITSZELLEN
            DEFS    128
;PLAYER-BEZGE
SNGADR:     EQU     WORK        ;WORD, ANFANGSADRESSE SONG
WDH:        EQU     WORK+02     ;BYTE, ANZAHL WIEDERHOLUNGEN
MAXI:       EQU     WORK+0DH    ;BYTE, ANZAHL PATTERN IM SONG
POSI:       EQU     WORK+35H    ;BYTE, ABGESPIELTE PATTERNANZAHL
LAUT_A:     EQU     WORK+3FH    ;BYTE, REG. 8=LAUTSTRKE KANAL A
LAUT_B:     EQU     WORK+40H    ;BYTE, REG. 9=LAUTSTRKE KANAL B
LAUT_C:     EQU     WORK+41H    ;BYTE, REG.10=LAUTSTRKE KANAL
;USB-BEZGE
DIRANZ:     EQU     WORK+72     ;ANZAHL BEI DIR
SPZ:        EQU     DIRANZ+2    ;SPALTENZHLER DIR
MENGE:      EQU     SPZ+1       ;4 BYTES LADEN /SICHERN
RAMADR:     EQU     MENGE+4     ;2 BYTES
INBUFF:     EQU     RAMADR+2    ;EINGABEPUFFER 13+2
NAMBUF:     EQU     INBUFF+15   ;PUFFER DATEINAME  13+2 ZEICHEN
DIRFLG:     EQU     NAMBUF+15   ;1 BYTE FLAG FR SERIENABSPIEL
KATPOS:     EQU     DIRFLG+1    ;2 BYTES AKT. POSI IM KATALOG
MAXWDH:     EQU     KATPOS+2    ;1 BYTE 1...9
SONGNR:     EQU     MAXWDH+1    ;2 BYTE 1...511
SNGEND:     EQU     SONGNR+2    ;2 BYTES LETZTE ADRESSE GELADENER SONG
BSP:        EQU     SNGEND+2    ;2 BYTES BWS-ADRESSE BEI PRINT
;n BYTES RESERVE
;-------------------------------------------------
PLAYER:
	INCLUDE    AYPLKC87.INC  ;AY-PLAYER-ENGINE
;NORMALVARIANTE MIT CTC AUF SOUNDKARTE
;BEZGE:
;PLAYER+0           ;SONG LADEN+ABSPIELEN
;PLAYER+6           ;SOUND AUS
;-------------------------------------------------
START0:     CALL    KOPF        ;TITEL
;;         CALL    SETPIO      ;USB-INIT+TEST
;;            JR      C,RAUS      ;FEHLER !
   	    CALL    CD_ROOT     ;WECHSEL ZURCK IN ROOT
            CALL    CD_STC      ;WECHSEL IN SONGVERZEICHNIS
            JP      NC,START2   ;OK, STC GEFUNDEN

            LD      DE,T_NOSTC  ;\STC-VERZEICHNIS EXISTIERT NICHT"
            CALL    PRNST
            CALL    CONSI
            JP      RAUS
;-------------------------------------------------
RESTART:    CALL    CONSI       ;ANHALTEN ZUM LESEN DER FEHLERMELDUNG
;--------------------------------------------------
START1:     CALL    KOPF        ;TITEL
START2:     ;HAUPTMEN-----------------------------
            LD      DE,0601H
            CALL    SETCU
            LD      DE,BEFEHLE
            CALL    PRNST
            ;ANFANGSBUCHSTABEN MARKIEREN:
            LD      HL,FARB +5*40+8     ;FARBRAM
            LD      DE,80
            LD      B,5
MARK:       LD      (HL),24H         ;GRN AUF ROT
            ADD     HL,DE
            DJNZ    MARK
            ;-------------------------------------
FNKT:       CALL    CONSI       ;ABFRAGE FUNKTION
            OR      20H         ;GRO=KLEIN
            CP      "l"         ;SONG LADEN?
            JR      Z,EINZEL    ;
            CP      "p"         ;Playliste
            JP      Z,BATCH
            CP      "a"         ;ALLES SPIELEN
            JP      Z,SERIE
            CP      "u"         ;USB-TEST	--> todo verzeichniswechsel
            JR      Z,START0
            CP      "e"         ;ENDE
            JR      NZ,FNKT
            ;PROGRAMM-ENDE----------------------------
HOME:       CALL    PLAYER+6    ;SONG STOPPEN
            CALL    CLS
HOME1:      CALL    CD_ROOT     ;WECHSEL ZURCK IN ROOT
            JR      NC,RAUS
            LD      DE,T_USBERR
            CALL    PRNST
            ;FR TEST PROGRAMMKOPF LSCHEN,
            ;ANSONSTEN WIRD IMMER ALTE AUS RAM GELADEN!!!
RAUS:       LD      HL,START
            LD      B,15
LOESCH:     LD      (HL),0
            INC     HL
            DJNZ    LOESCH
            RET                 ;ZURCK ZUM KC-OS
;EINZELABSPIEL----------------------------------
EINZEL:     CALL    CLS
            LD      DE,T_WEITER
            CALL    PRNST
EIN1:       LD      DE,T_NAM    ;AUFFORDERUNG EINGABE DATEINAME:
            CALL    PRNST
            LD      DE,INBUFF   ;EINGABEPUFFER VORBEREITEN:
            LD      A,8
            LD      (DE),A      ;INITIALISIEREN MAX. ZEICHENZAHL
            CALL    RCONB       ;EINGABE ZEICHENKETTE
            JP      C,START1    ;STOP-TASTE GEDRCKT
            ;EINGABE MIT <ET> QUITTIERT
            INC     DE
            LD      A,(DE)      ;LESEN EINGEGEBENE ZEICHENZAHL
            OR      A
            JP      NZ,EIN2
            ;LEERE ZEICHENKETTE (WAR NUR ENTER):DIR
            XOR     A
            LD      (DIRFLG),A  ;NORMALE BS-ANZEIGE
            CALL    CLS
            CALL    DIR         ;ANZEIGE USB-INHALTSVERZEICHNIS
            CALL    ISNULL      ;BESTAND?
            JR      NZ,EIN1     ;JA
            LD      DE,T_NIX
            CALL    PRNST
            JP      RESTART
EIN2:       ;DATEINAME OHNE ENDUNG
            LD      HL,INBUFF+2 ;BEGINN ZK
            LD      DE,NAMBUF   ;NACH HIER
            LD      B,0
            LD      C,A         ;ANZAHL ZEICHEN
            LDIR                ;UMKOPIEREN IN LADEPUFFER
            ;ANHNGEN .STC + 0H
            LD      A,"."
            LD      (DE),A
            INC     DE
            LD      HL,STC
            LDI     ;S
            LDI     ;T
            LDI     ;C
            LDI     ;0
            ;DATEINAME JETZT IN NAMBUF
            ;KONTROLLANZEIGE
            LD      DE,T_LADE
            CALL    PRNST
            CALL    INVERS      ;EIN
            LD      DE,NAMBUF
            CALL    PRNAM
            CALL    INVERS      ;AUS
            CALL    CUOFF
            ;LADEN---------------------------
            LD      HL,SONG     ;ZIELADRESSE
            LD      (RAMADR),HL
            LD      (WORK),HL   ;ALS ANFANGSADRESSE FR PLAYER
            CALL    _LADEUSB
            JP      C,START1    ;NICHT GEFUNDEN,ZURCK ZUM MEN
            ;ANZAHL WIEDERHOLUNGEN ABFRAGEN
            LD      DE,T_WIEDER
            CALL    PRNST
EIN3:       CALL    CONSI
            ;TEST (0)...1...8
            CP      0DH         ;NUR ENTER=KEINE
            JR      Z,EIN4
            CP      "8"+1
            JR      NC,EIN3     ;FALSCH
            CP      "0"
            JR      C,EIN3      ;FALSCH
            SUB     A,2FH       ;1...9
            JR      EIN5
EIN4:       LD      A,1         ;1 = KEINE WIEDERHOLUNG
EIN5:       LD      (WDH),A     ;ANZAHL!
            ;SONG STARTEN-----------------------
            CALL    SONG1       ;AB 1
            CALL    DIR1        ;MAX=1
	CALL    PLAYER+6    ;SONG STOPPEN
            CALL    PLAYER
            CALL    DESK        ;HIERDRIN 1 LIED
            JP      START1      ;FERTIG
;------------------------------------------------
DESK:       CALL    OBERFL      ;PLAYER-OBERFLCHE ZEICHNEN
            ;DATEINAME (SONGTITEL) ANZEIGEN------
            LD      DE,050FH    ;ZEILE 5,SPALTE 10
            CALL    SETCU
            CALL    INVERS      ;EIN
            LD      DE,NAMBUF
            CALL    PRNAM
            CALL    INVERS      ;AUS
            CALL    CUOFF
            ;SONG-ID----------------------------
            LD      DE,060FH    ;ZEILE 6,SPALTE 10
            CALL    SETCU
            LD      HL,SONG+7   ;FESTE POSI IM SONG!
            LD      B,18        ;LNGE IMMER 18 ZEICHEN
DESK1:      LD      A,(HL)
            CALL    CONSO
            INC     HL
            DJNZ    DESK1
            CALL    CUOFF       ;KURSOR AUS
            ;TEMPO-------------------------------
            LD      HL,BWS1
            LD      A,(SONG)    ;TEMPOWERT 01...0F
            CALL    DEZA
            ;MAX. MUSTERANZAHL------------------
            LD      HL,BWS1  +2*40 +8
            LD      A,(MAXI)
            CALL    DEZA

            ;SONG "1 VON "-----------------------
            LD      HL,BWS1  +8*40
            LD      DE,(SONGNR)
            CALL    DEZDE
            ;MAX. SONGANZAHL-------------------
            LD      HL,BWS1  +8*40 +8
            LD      DE,(DIRANZ)
            CALL    DEZDE
            ;TASTATURPUFFER LEEREN-------------
            XOR     A
            LD      (25H),A
DESK2:      ;SCHLEIFE WHREND ABSPIEL-----------
            ;LFD.MUSTERNUMMER--------------------
            LD      HL,BWS1+ 2*40
            LD      A,(POSI)
            CALL    DEZA
            ;PEGELANZEIGE BEDIENEN--------------
            LD      HL,BWS1 +4*40
            LD      A,(LAUT_A)
            CALL    PEGEL
            LD      HL,BWS1+ 5*40
            LD      A,(LAUT_B)
            CALL    PEGEL
            LD      HL,BWS1+ 6*40
            LD      A,(LAUT_C)
            CALL    PEGEL
            ;ANZAHL WIEDERHOL.-------------------
            LD      HL,BWS1 +5*64+15
            LD      A,(WDH)     ;1...9
            ADD     A,30H
            LD      (HL),A
            ;ABFRAGE TASTATUR--------------------
            CALL    CSTS
            CP      3          ;<STOP> ?
            JR      Z,DESK3    ;JA
            CP      0DH        ;<ENTER> ?
            JR      Z,DESK3    ;JA
            ;SONG FERTIG?------------------------
            LD      A,(WDH)     ;
            OR      A
            JR      NZ,DESK2   ;LIED WEITERSPIELEN
DESK3:      PUSH    AF
            CALL    PLAYER+6    ;JA, SONG STOPPEN
            CALL    CLS
            POP     AF
            RET
;PLAYLISTE ABSPIELEN------------------------------
BATCH:      CALL    CLS
            CALL    KAT0        ;KATALOG LEEREN
            LD      HL,T_BNAM   ;NAME
            LD      DE,NAMBUF   ;BATCHDATEI
            LD      BC,13
            LDIR
            LD      DE,T_STAPEL ;Playliste...
            CALL    PRNST

            LD      HL,KAT      ;ZIELADRESSE
            LD      (RAMADR),HL
            CALL    _LADEUSB
            JP      C,START1    ;KEINE BAT VORHANDEN
            CALL    CLS
            ;DATEIEN IM BATCHFILE (KATALOG) ZHLEN
            CALL    SONG1       ;START MIT 1
            CALL    DIR0        ;ANZAHL=0
            LD      HL,KAT      ;ANFANG KATALOG
BAT1:       LD      A,(HL)
            OR      A           ;ENDE?
            JP      Z,SERIE1    ;FERTIG
            CP      0DH
            CALL    Z,DIRPLUS   ;1 DATEI MEHR
            INC     HL
            JR      BAT1
;SERIENABSPIEL------------------------------------
SERIE:      CALL    CLS
            LD      DE,T_EINLES
            CALL    PRNST
            CALL    CUOFF
            CALL    KAT0        ;KATALOG LSCHEN
            LD      A,1
            LD      (DIRFLG),A  ;DIR ZEIGT NICHTS AN,
                                ;SONDERN SCHREIBT KATALOG
            CALL    SONG1       ;SONGNR AB 1
            CALL    DIR         ;EINLESEN
SERIE1:     CALL    ISNULL      ;BESTAND?
            JR      NZ,SERIE3   ;JA
            LD      DE,T_NIX    ;NEIN
SERIE2:     CALL    PRNST
            JP      RESTART

SERIE3:     ;>=511?
            LD      DE,0200H    ;512 DATEIEN
            OR      A
            SBC     HL,DE
            ADD     HL,DE
            LD      DE,T_ZUVIEL
            JR      NC,SERIE2
            ;AUS KATALOG SONGNAMEN NACHEINANDER HOLEN
            LD      HL,KAT      ;ANFANGSADRESSE KATALOG
            LD      (KATPOS),HL ;MAX. 4 K BEI 255 SONGS
            ;NAME HOLEN, KOPIEREN NACH NAMBUF=DATEINAME, 0D-TERMINIERT
SERIE4:     LD      HL,(KATPOS)
            LD      DE,NAMBUF
     	    LD      A,(HL)	;typ
	    OR	    A
	    JP      Z,START1    ;KEIN WEITERER NAME MEHR!
            INC     HL          ;TYP BERLESEN

      call	COPYFN      ;filename nach DE , Format "8.3"+0

SERIE7:     ;HL=ANFANG NCHSTER NAME!
            LD      (KATPOS),HL ;SETZEN
            ;DATEINAME IST IN NAMBUF
            LD      DE,0A0CH    ;MITTIG
            CALL    SETCU
            LD      DE,T_LADE   ;"LADEN"
            CALL    PRNST
            CALL    INVERS      ;EIN
            LD      DE,NAMBUF
            CALL    PRNAM       ;NAME AUSGEBEN
            CALL    INVERS      ;AUS
            LD      DE,0C0BH    ;POSI
            CALL    SETCU       ;VORBEREITEN FR EVTL. FEHLERMELDUNG
            CALL    CUOFF
            ;LADEN---------------------------
            LD      HL,SONG     ;LADEADRESSE
            LD      (RAMADR),HL ;DORTHIN!
            CALL    _LADEUSB    ;CARRY, WENN FEHLER
           ;; JP      C,RESTART
           JP	C,SERIE10	; NCHSTER SONG
            ;SONGANFANG BERGEBEN------------
            LD      HL,SONG     ;SONGANFANG
            LD      (SNGADR),HL ;BERGEBEN
            LD      A,1
            LD      (WDH),A     ;1XSPIELEN
	CALL    PLAYER+6    ;SONG STOPPEN
            CALL    PLAYER      ;SONG STARTEN
            CALL    DESK        ;OBERFLCHE
            ;HIER WEITER, WENN:
            ;SONG ZU ENDE
            ;ODER STOPP
            ;ODER ENTER
            CP      3                 ;WAR ^C ?
            JP      Z,START1          ;JA
            ;ENTER => NCHSTER SONG
            CP      0DH
            JR      Z,SERIE10       ;JA
            ;PAUSE--------------------------------
            LD      B,3
SERIE8:     PUSH    BC
            LD      DE,0A10H
            CALL    SETCU
            LD      DE,T_PAUSE
            CALL    PRNST
            LD      A,B
            ADD     A,30H
            CALL    CONSO   ;PAUSENWERT AUSGEBEN 3...0
            CALL    CUOFF
            LD      BC,0
SERIE9:     DEC     BC
            LD      A,B
            OR      C
            JR      NZ,SERIE9
            POP     BC
            DJNZ    SERIE8
            CALL    CLS
SERIE10:    LD      HL,(SONGNR)     ;LAUFENDE NR.
            INC     HL              ;ERHHEN
            LD      (SONGNR),HL
            JP      SERIE4

SONG1:      LD      HL,1        ;SONG-NR AUF 1 SETZEN
            LD      (SONGNR),HL
            RET
;PEGELANZEIGE-------------------------------------
;BALKENANZEIGE, LNGE in A
;DER REST BIS ZUR MAX. LNGE WIRD MIT LEERZEICHEN BERSCHRIEBEN
;Direktes Schreiben in BWS (Anfangspos in HL)
PEGEL:      LD      (BSP),HL    ;STARTPOSI BALKEN
            OR      A           ;0?
            LD      D,0FEH      ;SYMBOL BALKENZEICHEN NORMAL
            LD      C,16        ;MAX.
            JR      Z,P2        ;NUR 16X LEER!
            CP      16          ;HLLKURVE?
            JR      C,P0        ;<16        -> NORMAL
                                ;WAR >=16   -> HLLKURVE AKTIV
            LD      A,16        ;MAX. ANZEIGEN
            LD      D,0c7h      ;SYMBOL HLLKURVE
P0:         LD      B,A         ;ANZAHL
            LD      A,16        ;MAX.
            SUB     B           ;REST
            LD      C,A         ;ANZAHL LEERE MERKEN
            LD      A,D         ;SYMBOL
P1:         CALL    PRINT
            DJNZ    P1
            ;ALTEN RESTBALKEN LSCHEN
P2:         LD      B,C
            XOR     A
            CP      B
            RET     Z
P3:         LD      A," ";
            CALL    PRINT
            DJNZ    P3
            RET
;-------------------------------------------------
;SCHIRMAUSGABE DIREKT IN BWS (PUFFER BSP)
PRINT:      PUSH    HL
            LD      HL,(BSP)    ;AKT. ADRESSE holen
            LD      (HL),A      ;AUF SCHIRM SCHREIBEN
            INC     HL          ;virt. kursor weiter
            LD      (BSP),HL
            POP     HL
            RET
;SCHNELLERES CLS-----------------------------------
CLS:        ;FARBE
            LD      HL,FARB
            LD      (HL),20H
            LD      DE,FARB+1
            LD      BC,960
            LDIR
            ;ASCII
            LD      HL,ASCII
            LD      (HL),20H
            LD      DE,ASCII+1
            LD      BC,960
            LDIR
            LD      DE,0101H
            JP      SETCU       ;HOME
;-----------------------------------------------
INVERS:     LD      A,16H
            JP      CONSO
;BOS-FUNKTIONEN----------------------------------
RESET:      LD      C,0         ;SYSTEM-NEUSTART
            JR      BOS
CONSI:      LD      C,1         ;EINGABE EINES ZEICHENS VON CONST
            JR      BOS
CONSO:      PUSH    DE
            PUSH    BC
            LD      E,A
            LD      C,2         ;AUSGABE EINES ZEICHENS ZU CONST
            CALL    5
            POP     BC
            POP     DE
            RET
PRNST:      LD      C,9         ;ZK AUSGABE KC87
            JR      BOS         ;ENDE ZK=00
RCONB:      LD      C,10        ;EINGABE ZK
            JR      BOS
CSTS:       LD      C,11        ;TAST.STATUS ABFRAGEN
            JR      BOS
GETCU:      LD      C,17        ;KURSORPOS. ABFRAGEN
            JR      BOS
SETCU:      LD      C,18        ;CURSOR SETZEN (D=ZEILE, E=SPALTE)
            JR      BOS
CUOFF:      LD      C,29        ;CURSOR AUS
BOS:        JP      5
;-------------------------------------------------
;DEZIMALAUSGABE 000...999, DIREKT AUF BWS (ADR. IN HL)
;----------------------------------------
DEZDE:      ;WERT IN DE
            LD      (BSP),HL
            JR      DEZ1
DEZA:       ;Wert in A
            LD      (BSP),HL       ;STARTPOSI AUSGABE
            LD      L,A
            LD      H,0
            EX      DE,HL          ;DE=AUSGABEWERT
DEZ1:       LD      C,30H
            LD      HL,0063H        ;99
            AND     A
            SBC     HL,DE
            JP      C,DEZ2
            LD      A,C
            CALL    PRINT
            LD      HL,0009H        ;9
            AND     A
            SBC     HL,DE
            JP      C,DEZ2
            LD      A,C
            CALL    PRINT
DEZ2:       EX      DE,HL
DEZ3:       LD      DE,000AH
            CALL    DEZ4
            LD      A,L
            LD      H,B
            LD      L,C
            PUSH    AF
            LD      A,L
            OR      H
            CALL    NZ,DEZ3
            POP     AF
            ADD     A,30H            ;ZIFFER
            JP      PRINT
DEZ4:       LD      B,L
            LD      L,H
            LD      H,0
            CALL    DEZ5
            LD      H,L
            LD      L,B
            LD      B,C
DEZ5:       LD      C,0FFH
DEZ6:       AND     A
            SBC     HL,DE
            INC     C
            JP      NC,DEZ6
            ADD     HL,DE
            RET
;-----------------------------------------------
PRNAM:      LD      A,(DE)
            CP      00H       ;OHNE 0D-AUSGABE!
            RET     Z
            CALL    CONSO
            INC     DE
            JR      PRNAM
;-------------------------------------------------------
;PLAYEROBERFLCHE
OBERFL:     CALL    KOPF
            LD      DE,0501H    ;UNTER DEM KOPF:
            CALL    SETCU

            LD      DE,OBER
            CALL    PRNST
            CALL    LINE
            LD      DE,OBER2
            CALL    PRNST
            CALL    LINE
            LD      DE,OBER3
            CALL    PRNST
            CALL    LINE
            LD      DE,OBER4
            CALL    PRNST
            CALL    LINE
            LD      DE,OBER5
            CALL    PRNST
            CALL    LINE
            LD      A,0AAH
            CALL    CONSO
            ;BALKENFARBE (VORDERGRUND) SETZEN:
            LD      A,40H  ;BLAU AUF SW
            LD      B,16
            LD      HL,FARB+10*40+14
MARK2:      LD      (HL),A
            INC     HL
            DJNZ    MARK2
            LD      B,16
            LD      HL,FARB+11*40+14
MARK3:      LD      (HL),A
            INC     HL
            DJNZ    MARK3
            LD      B,16
            LD      HL,FARB+12*40+14
MARK4:      LD      (HL),A
            INC     HL
            DJNZ    MARK4
            RET
;-------------------------------------------------------
KAT0:       LD      HL,KAT          ;ANFANGSADRESSE KATALOG
            LD      (KATPOS),HL     ;MAX. 8 K BEI 511 SONGS
            LD      (HL),0          ;LSCHEN
            LD      DE,KAT+1        ;
            LD      BC,1FFFH        ;
            LDIR
            RET
;DATEIANZAHL (RCK)SETZEN, ERHHEN, PRFEN
DIR0:       PUSH    HL
            LD      HL,0
            JR      DIR2
DIR1:       PUSH    HL
            LD      HL,1
DIR2:       LD      (MENGE),HL
DIR3:       LD      (DIRANZ),HL
            POP     HL
            RET
DIRPLUS:    PUSH    HL
            LD      HL,(DIRANZ)
            INC     HL                ;ZHLEN
            JR      DIR3
ISNULL:     LD      HL,(DIRANZ)   ;ANZAHL SONGS
            LD      A,H
            OR      L
            RET
;--------------------------------------------------------
KOPF:       CALL    CLS
            LD      DE,0101H
            CALL    SETCU
            LD      DE,T1
            CALL    PRNST
            CALL    LINE
            LD      DE,T3
            CALL    PRNST
            LD      DE,T4
            CALL    PRNST
            CALL    LINE
            LD      DE,T5
            CALL    PRNST
            JP      CUOFF
;----------------------------------------------------
LINE:       LD      B,27
            LD      A,0A0H
LI2:        CALL    CONSO
            DJNZ    LI2
            RET
;----------------------------------------------------
T1:     DEFM  "     ",0A8H,0
T3:     DEFB  0A9H,0DH,0AH,0
T4:     DEFM  "     ",0A1H,"STC-EOS-PLAYER   KC87/Z9001",0A1H,0DH,0AH
        DEFM  "     ",0A1H,"VERS. 1.1    (C) WeRo '2017",0A1H,0DH,0AH
        DEFM  "     ",0A7H,0
T5:     DEFB  0AAH,0DH,0AH,0
;-----------------------------------------------------
BEFEHLE:
        DEFM  "       (L)ADEN EINZELSONG",0DH,0AH,0AH
        DEFM  "       (P)LAYLISTE  SPIELEN",0DH,0AH,0AH
        DEFM  "       (A)LLE SONGS SPIELEN",0DH,0AH,0AH
        DEFM  "       (U)SB STICKWECHSEL/INIT",0DH,0AH,0AH
        DEFM  "       (E)NDE",0DH,0AH,0AH
        DEFM  "        -> FUNKTION:",0
;----------------------------------------------------
OBER:   DEFM  "     ",0BH,0A3H,0AH,8,0A1H,"TITEL :                    "
        DEFM  0A1H,0BH,8,0A5H,0AH,0DH,0AH
        DEFM  "     ",0A1H,"ID    :                    ",0A1H,0DH,0AH
        DEFM  "     ",0A1H,"TEMPO :                    ",0A1H,0DH,0AH
        DEFM  "     ",0A3H,0
OBER2:  DEFM  0A5H,0DH,0AH
        DEFM  "     ",0A1H,"MUSTER:     VON            ",0A1H,0DH,0AH
        DEFM  "     ",0A3H, 0
OBER3:  DEFB  0A5H,0DH,0AH
        DEFM  "     ",0A1H,"KAN. A:                    ",0A1H,0DH,0AH
        DEFM  "     ",0A1H,"KAN. B:                    ",0A1H,0DH,0AH
        DEFM  "     ",0A1H,"KAN. C:                    ",0A1H,0DH,0AH
        DEFM  "     ",0A3H,0
OBER4:  DEFB  0A5H,0DH,0AH
        DEFM  "     ",0A1H,"SONG  :     VON       ( X) ",0A1H,0DH,0AH
        DEFM  "     ",0A3H,0
OBER5:  DEFB  0A5H,0DH,0AH
        DEFM  "     ",0A1H,"<STOP>=MENUE    <ET>=WEITER",0A1H,0DH,0AH
        DEFM  "     ",0A7H,0
;------------------------------------------------------
STC:        DEFM    "STC",0         ;SONG-DATEIERWEITERUNG
STCX:       DEFM    3,"STC"         ;UNTERVERZEICHNISNAME
ROOT:       DEFM    1,"/"           ;WURZELVERZEICHNIS
;----------------------------------------------------
T_MOMENT:   DEFM   " MOMENT...",0
T_USBERR:   DEFM   "USB-FEHLER!",0
T_NOTFND:   DEFM   " NICHT GEFUNDEN!",0
T_NOSTC:    DEFM   "      KEIN STC-VERZEICHNIS!",0DH,0AH,0
T_NIX:      DEFM   0DH,0AH,"KEINE SONGS IN /STC!",0
T_ZUVIEL:   DEFM   "ZU VIELE SONGS, NUR EINZELMODUS!",0
T_WEITER:   DEFM   0DH,0AH,"<ET>=DIR, <STOP>=ABBRUCH>",0
T_NAM:      DEFM   0DH,0AH,"DATEINAME (OHNE .STC) ? ",0
T_LADE:     DEFM   "LADEN: ",0
T_EINLES:   DEFM   "LESE SONGS EIN...",0
T_PAUSE:    DEFM   "PAUSE ",0
T_STAPEL:   DEFM   "PLAYLISTE...",0
T_WIEDER:   DEFM   0DH,0AH,"WIEDERHOLUNG (0)...8:",0
T_BNAM:     DEFM   "!PLAYLST.TXT",0DH,0
;******************************************************
;EOS-ROUTINEN
;******************************************************

dirz	db	"?STC",0	; entspricht *.STC

DIR:    ; OS-Funktion DIR (ohne anzeigen)
	ld	a,11100000b	; mit Suchmuster, ablegen im Speicher
	ld	de,dirz		; Suchmuster
	LD      HL,KAT      	;ANFANGSADRESSE KATALOG
	LD      (KATPOS),HL 	;MAX. 4 K BEI 255 SONGS
	ld	c,19		; DIRS
	call	5
	LD      (KATPOS),HL 	; Ende-Adr.
	;
	LD      IX,KAT 		; Pointer f. DIR
	; Ablage im Katalog als
;	1. Byte Typ (D ir/F ile), Name Format "8.3", 0 byte
;	Ende mit 0
;	HL = Ende Adr. Buffer

; A030   xx xx xx 46 53 31 2E 53 54 43 00 46 53 32 2E 53      FS1.STC.FS2.S
; A040   54 43 00 46 53 37 2E 53 54 43 00 46 53 38 2E 53   TC.FS7.STC.FS8.S
; A050   54 43 00 00    				   TC..

;INHALT USB ANZEIGEN
    	CALL    DIR0                ;DATEIZHLER
        XOR     A
        LD      (SPZ),A             ;POSITIONSZHLER SPALTE

DIR05A: LD      HL,INBUFF
	CALL    CHECKB              ;Typ, 0=ENDE
        RET	Z		; Ende-> Fertig

	;DATEINAME BAUEN
DIR05:  CALL    CHECKB              ;0=ENDE EINES NAMENS?
        LD      (HL),A
        INC     HL
        JP      NZ,DIR05            ;NEIN, WEITER LESEN

        ; nicht ntig, ist schon erfolgt
;;      DEC     HL
;;        ;NAME VORHANDEN, ENDUNG TESTEN
;;
;;        LD      DE,STC      ;FILTER STC
;;        INC     DE
;;        INC     DE
;;        LD      A,(DE)
;;        CP      (HL)
;;        JP      NZ,DIR09
;;        DEC     HL
;;        DEC     DE
;;        LD      A,(DE)
;;        CP      (HL)
;;        JP      NZ,DIR09
;;        DEC     HL
;;        DEC     DE
;;        LD      A,(DE)
;;        CP      (HL)
;;        JR      NZ,DIR09

        ;JA: NAME ERFLLT BEDINGUNG
        CALL    DIRPLUS     ;EINE MEHR

        LD      A,(MENGE)
        INC     A
        LD      (MENGE),A   ;ANZAHL PRO SCHIRM
        LD      A,(DIRFLG)
        OR      A
        JR      NZ,COP0
        ;NORMAL AUF SCHIRM AUSGEBEN, FORMATIERT IN 3 SPALTEN
        ;(USB) = SPALTENPOSITION
        CALL    GETCU       ;E=AKT. DRUCKSPALTE
        LD      HL,SPZ      ;SCHIRMPOSI 0..2
        INC     (HL)        ;1...3
        LD      A,(HL)
        CP      1           ;SPALTE 0 ?
        JR      NZ,SP0
        ;JA
SPX:    LD      E,1
        INC     D           ;NEUE ZEILE
        JR      SK
SP0:    CP      2           ;SPALTE 1?
        JR      NZ,SP1
        ;JA
        LD      E,14
        JR      SK
SP1:    ;CP     3           ;SPALTE 3?
        ;JR     NZ,SPX
        LD      E,27
        LD      (HL),0      ;VON VORN ANFANGEN
SK:     CALL    SETCU         ;NEUE DRUCKSPALTE
        LD      HL,INBUFF            ;NAMENSPUFFER
        CALL    TXTOUT               ;AUSGABE
        ;ANZAHLTEN, WENN SCHIRM VOLL
        LD      A,(MENGE)
        CP      60                   ;66 DATEIEN, DANN STOP
        JR      C,DIR09
        LD      DE,T_WEITER
        CALL    PRNST
        CALL    CONSI
        CP      3                 ;WAR STOPP
       ;; JR      Z,REST             ;NOCH REST ABHOLEN
       RET	Z
        CALL    CLS
        XOR     A
        LD      (SPZ),A      ;VON VORN ANFANGEN
        LD      (MENGE),A
        JR      DIR09
        ;IN KATALOG KOPIEREN
        ; nicht ntig, der Katalog steht schon
COP0:
;	 LD      DE,(KATPOS)          ;AKT. POSI IM KATALOG
;        LD      HL,INBUFF
;COP:    LD      A,(HL)               ;
;        CP      "."
;        JR      Z,COP1               ;NOCH STC+0D ANHNGEN
;        LDI
;        JR      COP
;COP1:   LD      (DE),A               ;. ABLEGEN
;        INC     DE
;        LD      HL,STC
;        LDI
;        LDI
;        LDI
;        LD      A,0DH
;        LD      (DE),A
;        INC     DE
;        LD      (KATPOS),DE          ;NEUE POS.

DIR09:  JP      DIR05A        	  ;NEIN

;------------------------------------------------------
USBERR4:LD      DE,T_NOTFND
        CALL    PRNST
        CALL    CONSI
        SCF                     ;FEHLERFLAG
        RET
;------------------------------------------------------
;USB-VERZEICHNISWECHSEL
;VERZEICHNISWECHSEL
CD_ROOT:LD      HL,ROOT
        JR      CD_X
CD_STC: LD      HL,STCX
CD_X:   jp      USB_CD          ;CD..
;-------------------------------------------------
;KOMMT MIT HL=ZEIGER AUF STRINGANFANG
USB_CD: LD	A,(HL)
	LD	B,A		; Anz. Zeichen
	INC	HL
	PUSH    HL
	POP	DE		; Text
	ld	C,32		; CHDIR
	CALL	5
        RET
;-----------------------------------------------
;ALS LETZTES ZEICHEN KOMM IMMER 00H
CHECKB: ld	a,(ix+0)
	inc	ix
        CP      00H                 ;VORGANG BEENDET?
        RET

;-----------------------------------------------
_LadeUSB:       ;LESEN
;in  NAMBUF steht Adresse des Dateinamens
;in (RAMADR) steht Speicheradresse, auf die einzulesen ist

	LD	DE,CONBU
	ld	a,15
	ld	(de),a		;#max zeichen
	inc	de
	ld	(de),a		;#anz zeichen
	inc	de

	LD	HL,NAMBUF	;ADRESSE DATEINAME
	;;LD	DE,CONBU
	LD	BC,15
	LDIR			; Name nach COMBU

	LD	A,'N'
	LD	(fcb+24),A	; Laden ohne Kopfblock
	LD	HL,(RAMADR)	; Ladeadresse
	LD	A,1		; Dateiname "Name[.Typ]" in CONBU
	ld	c,34		; CLOAD
	call	5
	JP	C,USBERR4           ;DATEI NICHT GEFUNDEN!
	RET

;-------------------------------------------------
; Dateiname kopieren
; in HL=Format "8.3",0 oder "12345678EEE",0
; kopieren nach DE als "8.3",0

COPYFN:	LD	BC,8
SERIE5:	LD	A,(HL)
	LDI
	CP	0H	;NAME FERTIG KOPIERT?
	RET	Z	;JA
	CP	'.'
	JR	Z,SERIE6	;wenn Punkt kopiert
	CP	' '		;Leerzeichen?
	JR	NZ,SERIE5B	;diese nicht kopieren
	DEC	DE
SERIE5B:	LD	A,B
	OR	C
	JR	NZ,SERIE5	;max 8 Zeichen
;folgt Punkt? nein, dann einfuegen
	LD	A,'.'
	CP	(HL)
	JR	Z,SERIE5
	LD	(DE),A
SERIE5A:	INC	DE
	JR	SERIE5
;nach punkt alles weiterkopieren
SERIE6:	ld	bc,0
	JR	SERIE5
	
;--------------------------------------------------
;Text ausgeben bis FF
TXTOUT: LD      A,(HL)          ;Zeichen holen
        CP      0H            ;Ende erreicht?
        RET     Z               ;ja
        CALL    CONSO           ;ausgeben auf Schirm
        INC     HL
        JP      TXTOUT           ;nchstes
;--------------------------------------------------
SONG:   ;HIER BEGINNT GELADENER SONG

	end
