;PLAYER-ENGINE:
;VORTEX TRACKER II V1.0 PT3 PLAYER FOR ZX SPECTRUM
;(C)2004,2007 S.V.BULBA <VOROBEY@MAIL.KHSTU.RU>
;HTTP://BULBA.UNTERGRUND.NET (HTTP://BULBA.AT.KZ)
;-------------------------------------------------
;ANPASSUNG FR Z9001: WERO 01/2018
;* USB-TREIBER FR LADEN DER SONGS
;* PLAYER (NACH BULBA) ALS INCLUDE
;* SPIELZEITBESTIMMUNG (NACH BULBA)
;* EINFACHE SPEKTRUMANZEIGE WIE IM SOUNDTRACKER 1.X
;-------------------------------------------------
;ASSEMBLER: ASIDE 
;
;VP 12/2025 Anpassung Arnold-Assembler
;	Umstellung auf CALL5-Funktionen fr alle EOS-Systeme
;-------------------------------------------------

; Anpassung Arnold-Assembler
	cpu	z80

DEFM	macro	x
	IFNB X
	       	DB  (X)
		shift
	        DEFM ALLARGS
        endif
	endm

DEFS	macro	a,b
	ifb	b
		ds	a
	else	
		db	a dup(b)
	endif	
	endm

     INTSYNTAX +$hex		; $ --> $

hi              function x,(x>>8)&255
lo              function x, x&255

CONBU		equ	80h
fcb		equ	05Ch

;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
CTCBAS: EQU 3CH                 ;CTC-BASISADRESSE
CTCKAN: EQU 0                   ;K0
CTCZK:  EQU      0C0H           ;ZEITKONSTANTE FR 2,5... MHZ
CTCINT: EQU 210H                ;INTERRUPTTABELLE CTC 

;USBPIO: EQU      0DCH           ;BASISADRESSE USB-PIO
AYBAS:  EQU       38H           ;AY-BASISADRESSE
KAT:    EQU     2000H           ;KATALOG-ANFANG
MAXKAT: EQU     4000H           ;-"-     Ende+1
PROGR:  EQU     4000H           ;LADEADRESSE/PROGRAMMANFANG
FARB:   EQU     0E800H          ;FARBSPEICHER       
BWS:    EQU     0EC00H          ;ASCII-BWS
;-------------------------------------------------
;PROGRAMMKOPF FR USBX-----------------------------
        ORG     PROGR-80H
        DEFM    "PLAYPT3 "
        DEFM    "KCC"
        DEFW    0B800H          ;HIER LIEGT 
        DEFW    0BCFFH          ;USB-LADEROUTINE
        DEFB    0
        DEFB    03              ;3 PARAMATER
        DEFW    PROGR           ;ANFANGSADRESSE
        DEFW    ENDE            ;ENDEADRESSE
        DEFW    START0          ;STARTADRESSE
        DEFB    0
        DEFM    " EOS OS "      ;KENNUNG
        DEFS    64,0FFH         ;FREI
        DEFM    "*PT3-EOS-PLAYER*"
        DEFM    "KC87/Z9001   V.1"
;PROGRAMMKOPF FR Z9001---------------------------
;4000
        JP      START0
        DEFM    "PLAYPT3 ",0,0  
;------------------------------------------------
	INCLUDE PT3TIME.INC             ;SPIELDAUERBERECHNUNG
;NAMENSBEZGE!
;(MODADR)                       ;BERGABE SONGADRESSE
;CALL CALC                      ;BERECHNUNG, RCKGABE: H=MINUTEN, L=SEKUNDEN
;(PT3TIME)                      ;RCKGABE SPIELDAUER ALS ANZAHL INTERRUPTS
;--------------------------------------------------
	Include PT3PLAY.INC             ;der Player
;Bezge:
;CALL PLAY          ;init CTC, init song, play
;CALL STOPP         ;Abspiel Stoppen, INT. aus
;CALL MUTE          ;stummschalten
;(MODADR)           ;WORD, SONGADRESSE
;(SETUP)            ;BYTE, setup und status flags
;(CrPsPtr)          ;WORD, Adresse mit Akt. Pattern
;(POSI)             ;BYTE, LFD. NR. in Positionsliste
TON_A:  EQU     AYREGS          ;TONHHE
TON_B:  EQU     AYREGS+2
TON_C:  EQU     AYREGS+4
;RAUSCH: EQU     AYREGS+6
;MIXER:  EQU     AYREGS+7 
VOL_A:  EQU     AYREGS+8        ;LAUTSTRKE
VOL_B:  EQU     AYREGS+9
VOL_C:  EQU     AYREGS+10
;HK_D:   EQU     AYREGS+11
;HK_F:   EQU     AYREGS+13
;PORTA:  EQU     AYREGS+14
;PORTB:  EQU     AYREGS+15
;-------------------------------------------------
MODNR:  DEFB    0               ;BYTE, MODUS: 0=EINZEL, 
                                ;1=PLAYLISTE,2=REIHE,3=ZUFALL
ASCII:  DEFW    0               ;WORD,  BWS-ADRESSE SEL. EINTRAG
TICKS:  DEFW    0               ;SPIELDAUER IN INTERRUPTS
SNR:    DEFW    0               ;WORD, AKT. SONGNUMMER
BSP:    DEFW    0               ;2 BYTES BWS-ADRESSE BEI PRINT
        DEFB    0               ;SPEKBU -1 WEGEN +/- HALBER BALKEN
SPEKBU: DEFB    0,0,0,0,0,0,0,0
        DEFB    0,0,0,0,0,0,0,0
        DEFB    0,0,0,0,0,0,0,0
        DEFB    0,0,0,0,0,0,0,0
        DEFB    0               ;SPEKBU +1 WEGEN +/- HALBER BALKEN
SEED:   DEFW    0               ;WORD, STARTWERT ZUFALLSGENERATOR
;USB-BEZGE
DIRANZ: DEFW    0               ;ANZAHL BEI DIR
MAX:    DEFW    0               ;WORD, AKT. TITELANZAHL
TMAX:   DEFW    0               ;WORD, ANZAHL FR ZUFALL
SPZ:    DEFB    0               ;SPALTENZHLER DIR
MENGE:  DEFW    0               ;DWORD,4 BYTES LADEN /SICHERN
        DEFW    0
RAMADR: DEFW    0               ;WORD, USB-LADEADRESSE
INBUFF: DEFS    15              ;EINGABEPUFFER 13+2
NAMBUF: DEFS    15              ;PUFFER DATEINAME  13+2 ZEICHEN
DIRFLG: DEFB    0               ;BYTE, FLAG FR SERIENABSPIEL
KATPOS: DEFW    0               ;WORD, AKT. POSI IM KATALOG
;-----------------------------------------------
START0: CALL    KOPF            ;TITEL
        LD      DE,T_INIT
        CALL    PRNST
        CALl    CUOFF
;;        CALL    SETPIO          ;USB-INIT+TEST
;;        JR      C,RAUS          ;FEHLER !
        LD      HL,ROOT
        CALL    USB_CD
        LD      HL,PT3X
        CALL    USB_CD          ;WECHSEL IN SONGVERZEICHNIS
        JP      C,FEHL          ;NICHT DA
        LD      HL,0            ;RCKSETZEN
        LD      (TMAX),HL       ;MAX. SONGANZAHL
        JR      START2          ;OK, PT3 GEFUNDEN
FEHL:   LD      DE,T_NOPT3      ;PT3-VERZEICHNIS EXISTIERT NICHT
        CALL    PRNST
        JP      RAUS
;-------------------------------------------------
RESTART:;ANHALTEN ZUM LESEN DER FEHLERMELDUNG
        XOR     A
        LD      (25H),A         ;Tastaturpuffer lschen
        CALL    CONSI       
START1: CALl    STOPP
        CALL    KOPF
        LD      A,R
        LD      (SEED+1),A      ;Zufallsgenerator
START2: ;HAUPTMEN-----------------------------     
        LD      DE,0601H
        CALL    SETCU
        LD      DE,BEFEHLE      ;MEN
        CALL    PRNST           ;ANZEIGEN
        ;ANFANGSBUCHSTABEN MARKIEREN:
        LD      HL,FARB +5*40+8 ;FARBRAM
        LD      DE,80
        LD      B,7
MARK:   LD      (HL),71h        ;WS auf RT
        ADD     HL,DE
        DJNZ    MARK
FNKT:   CALL    CONSI           ;ABFRAGE FUNKTION
        OR      20H             ;GRO=KLEIN           
        CP      "l"             ;EINZELSONG?
        JR      Z,EINZEL     
        CP      "p"             ;Playliste
        JP      Z,LISTE       
        CP      "a"             ;ALLES SPIELEN
        JP      Z,SERIE
        CP      "z"             ;ZUFALLSMODUS
        JP      Z,ZUFALL
        CP      "u"             ;USB-INIT
        JR      Z,START0
        cp      "i"
        JR      Z,INFO
        CP      "e"             ;ENDE
        JR      NZ,FNKT
        ;PROGRAMM-ENDE----------------------------
HOME:   CALL    STOPP           ;ENDE, INT DEAKTIVIEREN 
        CALL    CLEARSP         ;SPEKTRUM LSCHEN
        LD      HL,ROOT
        CALL    USB_CD
        CALL    CLS
RAUS:   EI
        RET                     ;ZURCK ZUM KC-OS    
;-------------------------------------------------
INFO:   CALL    CLS
        CALL    KOPF
        LD      DE,T_INFO     
        CALL    PRNST  
        JR      RESTART
;EINZELABSPIEL----------------------------------
EINZEL: XOR     A
        LD      (MODNR),A       ;Modus
        CALL    CLS
        LD      DE,T_WEITER
        CALL    PRNST
EIN1:   LD      DE,T_NAM        ;AUFFORDERUNG EINGABE DATEINAME:
        CALL    PRNST
        LD      DE,INBUFF       ;EINGABEPUFFER VORBEREITEN:
        LD      A,8
        LD      (DE),A          ;INITIALISIEREN MAX. ZEICHENZAHL
        CALL    RCONB           ;EINGABE ZEICHENKETTE
        JP      C,START1        ;STOP-TASTE GEDRCKT
        ;EINGABE MIT <ET> QUITTIERT
        INC     DE
        LD      A,(DE)          ;LESEN EINGEGEBENE ZEICHENZAHL
        OR      A
        JP      NZ,EIN2         
        ;LEERE ZEICHENKETTE (WAR NUR ENTER):DIR
        CALL    CLS
        XOR     A
        LD      (DIRFLG),A      ;NORMALE BS-ANZEIGE
        CALL    DIR             ;ANZEIGE USB-INHALTSVERZEICHNIS

        CALL    ISNULL          ;BESTAND?
        JR      NZ,EIN1         ;JA
        LD      DE,T_NIX
        CALL    PRNST
        JP      RESTART
EIN2:   ;DATEINAME OHNE ENDUNG, DIESEN KOPIEREN
        LD      HL,INBUFF+2     ;BEGINN ZK
        LD      DE,NAMBUF       ;NACH HIER
        LD      B,0
        LD      C,A             ;ANZAHL ZEICHEN
        LDIR                    ;UMKOPIEREN IN LADEPUFFER
        ;ANHNGEN ENDUNG .PT3 + 0H
        LD      A,"."
        LD      (DE),A
        INC     DE
        LD      HL,PT3
        LDI                     ;P
        LDI                     ;T
        LDI                     ;3
        LDI                     ;0
        ;DATEINAME JETZT IN NAMBUF
        ;KONTROLLANZEIGE
        CALL    CLS
        LD      DE,0A0CH        ;MITTIG
        CALL    SETCU
        LD      DE,T_LADE
        CALL    PRNST
        CALL    INVERS          ;EIN
        LD      DE,NAMBUF
        CALL    PRNAM
        CALL    INVERS          ;AUS
        CALL    CUOFF
        call    short           ;PAUSE
        ;LADEN---------------------------
        LD      HL,SONG         ;ZIEL IM RAM
        LD      (RAMADR),HL     ;LADEADRESSE
        LD      DE,0B0BH        ;MITTIG
        CALL    SETCU
        CALL    _LADEUSB
        JP      C,restart       ;NICHT GEFUNDEN,ZURCK ZUM MEN   
        ;SONG STARTEN-----------------------
        LD      HL,1
        LD      (SNR),HL
        LD      (max),HL
        CALL    OBER            ;HIERDRIN 1 LIED
        JP      START1          ;FERTIG
;------------------------------------------------
LISTE:  LD      A,1
        LD      (MODNR),A       ;MODUS
        CALL    CLS
        CALL    KAT0            ;KATALOG LEEREN
        LD      HL,T_BNAM       ;NAME 
        LD      DE,NAMBUF       ;BATCHDATEI
        LD      BC,13
        LDIR
        LD      DE,T_STAPEL ;Playliste...
        CALL    PRNST

        LD      HL,KAT          ;ZIELADRESSE
        LD      (RAMADR),HL
        CALL    _LADEUSB        ;PLAYLISTE LADEN
        JP      C,RESTART       ;KEINE VORHANDEN
        CALL    CLS
        ;DATEIEN IM BATCHFILE (KATALOG) ZHLEN
        CALL    DIR0            ;ANZAHL=0
        LD      HL,KAT          ;ANFANG KATALOG
LISTE1: LD      A,(HL)
        OR      A               ;ENDE?
        JR      Z,SERIE1        ;FERTIG
        CP      0DH
        CALL    Z,DIRPLUS       ;1 DATEI MEHR
        INC     HL
        JR      LISTE1
;------------------------------------------------
SERIE:  LD      A,2
        LD      (MODNR),A
        CALL    CLS
        LD      DE,T_EINLES 
        CALL    PRNST
        CALL    CUOFF
        CALL    KAT0            ;KATALOG LSCHEN
        LD      A,1
        LD      (DIRFLG),A      ;DIR ZEIGT NICHTS AN, 
                                ;SONDERN SCHREIBT KATALOG
        CALL    SONG1           ;SONGNR AB 1
        CALL    DIR             ;EINLESEN
SERIE1: CALL    ISNULL          ;BESTAND?
        JR      NZ,SERIE3       ;JA
        LD      DE,T_NIX        ;NEIN
SERIE2: CALL    PRNST
        JP      RESTART
SERIE3: CALL    SONG1           ;Beginn mit Songnr 1
        LD      HL,(DIRANZ)
        LD      (max),HL

        ;AUS KATALOG SONGNAMEN NACHEINANDER HOLEN
        LD      HL,KAT          ;ANFANGSADRESSE KATALOG
        LD      (KATPOS),HL     
        ;NAME HOLEN, KOPIEREN NACH NAMBUF=DATEINAME, 0-TERMINIERT
SERIE4: LD      HL,(KATPOS)
        LD      DE,NAMBUF

     	    LD      A,(HL)	;typ
	    OR	    A
	    JP      Z,START1    ;KEIN WEITERER NAME MEHR!
            INC     HL          ;TYP BERLESEN
     
      call	COPYFN      ;filename nach DE , Format "8.3"+0

SERIE7: 
        ;HL=ANFANG NCHSTER NAME!
        LD      (KATPOS),HL     ;SETZEN
        ;DATEINAME IST IN NAMBUF
        CALL    CLS

        LD      DE,0A0CH        ;MITTIG
        CALL    SETCU
        LD      DE,T_LADE       ;"LADEN"
        CALL    PRNST
        CALL    INVERS          ;EIN
        LD      DE,NAMBUF
        CALL    PRNAM           ;NAME AUSGEBEN
        CALL    INVERS          ;AUS
        CALL    CUOFF 
        call    short           ;Pause

        LD      DE,0C0BH        ;POSI
        CALL    SETCU           ;VORBEREITEN FR EVTL. FEHLERMELDUNG
        CALL    CUOFF  
        ;LADEN---------------------------          
        LD      HL,SONG         ;LADEADRESSE
        LD      (RAMADR),HL     ;DORTHIN! 
        CALL    _LADEUSB        ;CARRY, WENN FEHLER
;;        JP      C,RESTART   
       JP      C,SERIE10       ;vp: nchster

        CALL    OBER            ;HIERDRIN 1 LIED
        PUSH    AF
        CALL    STOPP
        POP     AF
        ;HIER WEITER, WENN SONG ZU ENDE/STOPP/+/-
        ;RCKGABEWERT TESTEN:
        CP      "M"             ;Men?
        JP      Z,START1        ;JA
        CP      "+"             ;Nchster
        JR      Z,SERIE10       ;JA
        cp      "-"
        jr      Z,SERIE13
        ;PAUSE--------------------------------
        CALL    CLS
        LD      B,3
SERIE8: PUSH    BC
        LD      DE,0A10H
        CALL    SETCU
        LD      DE,T_PAUSE
        CALL    PRNST
        LD      A,B
        ADD     A,30H
        CALL    CONSO           ;PAUSENWERT AUSGEBEN 3...0
        CALL    CUOFF
        LD      BC,0
SERIE9: DEC     BC
        LD      A,B
        OR      C
        JR      NZ,SERIE9
        POP     BC
        DJNZ    SERIE8
        CALL    CLS
SERIE10: LD     DE,(MAX)        ;SOVIEL SIND DA
        LD      HL,(SNR)        ;LAUFENDE NR.
        OR      A
        SBC     HL,DE
        ADD     HL,DE
        JP      NC,START1       ;WAR SCHON LETZTER
        INC     HL              ;ERHHEN
SERIE11: LD    (SNR),HL
        JP      SERIE4
SERIE13:;RCKWRTS--------------------------------
        LD      DE,1
        LD      HL,(SNR)
        OR      A
        SBC     HL,DE
        ADD     HL,DE
        JP      Z,START1        ;WAR SCHON 1, NICHT WEITER ZURCK!
        DEC     HL
        LD      (SNR),HL
        ;IM KATALOG EINEN EINTRAG ZURCK:
        LD      HL,(KATPOS)     ;STEHT AUF ANFANG NCHSTER NAME
        DEC     HL              ;AUF 0D (0A BEI PLAYLISTE)
        LD      A,0AH
        CP      (HL)
        JR      NZ,SERIE14
        DEC     HL              ;WAR PLAYLISTE
        ;HL= 0D DER AKT. DATEI
SERIE14:DEC     HL
        LD      A,(HL)
        CP      0               ;KATALOG-ANFANG?
        JP      Z,START1        ;JA, 1. WIRD SCHON GESPIELT
        CP      0DH
        JR      NZ,SERIE14
SERIE15:DEC     HL
        LD      A,(HL)
        CP      0               ;ZIEL=1. DATEI?
        JR      Z,SERIE16
        CP      0DH
        JR      NZ,SERIE15
SERIE16: INC     HL             ;1. ZEICHEN NAME
        LD      (KATPOS),HL
        JP      SERIE4
;-------------------------------------------------            
SONG1:  LD      HL,1            ;SONG-NR AUF 1 SETZEN
        LD      (SNR),HL
        RET 
;------------------------------------------------
ZUFALL: LD      A,3
        LD      (MODNR),A
        CALL    CLS
        ;GUCKEN, OB SCHON MAL GEZHLT:
        LD      HL,(TMAX)
        LD      A,H
        OR      L
        JR      NZ,ZUF2         ;JA, SUMME VORHANDEN
        ;NOCH NICHT, ERST ZHLEN:
        LD      DE,090CH    
        CALL    SETCU
        LD      DE,T_ZAEHLE     
        CALL    PRNST  
        CALL    CUOFF

        LD      A,2             ;NUR ZHLEN
        LD      (DIRFLG),A      ;
        CALL    DIR             ;DIR
        ;(DATANZ) IST BEFLLT
        LD      HL,(DIRANZ)
        LD      (TMAX),HL       ;ANZAHL MERKEN
        CALL    ISNULL          ;BESTAND?
        JR      NZ,ZUF1         ;JA
        LD      DE,0A0CH    
        CALL    SETCU
        LD      DE,T_NIX        ;NEIN
        CALL    PRNST
        JP      RESTART
        ;SUMME ANZEIGEN:
ZUF1:   PUSH    HL
        POP     DE
        LD      HL,BWS+8*40+21
        CALL    DEZDE
ZUF2:   LD      DE,0A0CH        ;MITTIG
        CALL    SETCU
        LD      DE,T_SUCHE     
        CALL    PRNST  
        CALL    CUOFF
        CALL    SHORT           ;KURZE PAUSE 
        LD      A,R
        LD      (SEED),A
        CALL    ZUFGEN          ;ZUFALLSZAHL
        INC     HL              ;DA 0...N-1
        LD      (ASCII),HL      ;NUMMER MERKEN
        ;PER DIR MIT NUMMER SONGNAME HOLEN
        LD      A,3             ;HOLEN DATEINAME
        LD      (DIRFLG),A      ;
        CALL    DIR             ;DIR
        ;IN INBUFF STEHT DATEINAME,OHNE 0D
        ;UMKOPIEREN NACH NAMBUF
        LD      HL,INBUFF
        LD      DE,NAMBUF
              call	COPYFN      ;filename nach DE , Format "8.3"+0
        ;ANZEIGE AUSGEWHLER ZUFALLSSONG
        CALL    INVERS          ;EIN
        LD      DE,NAMBUF
        CALL    PRNAM
        CALL    INVERS          ;AUS
        CALL    CUOFF
        CALL    SHORT           ;KURZE PAUSE
        LD      HL,SONG         ;LADEADRESSE
        LD      (RAMADR),HL     ;DORTHIN! 
        CALL    _LADEUSB        ;CARRY, WENN FEHLER
        JP      C,RESTART 
        LD      HL,(ASCII)
        LD      (SNR),HL        ;ZUFALLSNUMMER
        LD      HL,(TMAX)
        LD      (MAX),HL        ;GESAMTANZAHL
ZUF4:   CALL    OBER
        PUSH    AF
        CALL    STOPP
        POP     AF
        CP      "-"
        JP      Z,ZUF4          ;AKTUELLEN SONG NOCHMAL
        CP      "M"
        JP      Z,START1        ;ENDE, ZUM MEN
        ;WAR + ODER SONGENDE: 
        JP      ZUFALL          ;NEUER ZUFALLSSONG
;------------------------------------------------
;PLAYEROBERFLCHE
;ENDET MIT A='+', '-' ODER 'M' FR SONGSTEUERUNG
OBER:   XOR     A
        LD      (PAUSE),A      ;KEINE PAUSE
        LD      HL,SETUP       ;
        SET     0,(HL)         ;AUTO-LOOP aus
        ;SONGADRESSE
        LD       HL,SONG
        LD      (MODADR),HL ;FR PLAYER BERGEBEN
        ;OBERFLCHE------------------------------
        CALL    CLS
        LD      DE,0305H
        CALL    SETCU
        LD      DE,T_PLAY
        CALL    PRNST
        CALL    RAHMEN
        CALL    BALKCOL
        ;TASTENKRZEL MARKIEREN ;WS AUF RT 
        LD      A,71H
        LD      HL,FARB+17*40+10
        LD      (HL),A
        LD      HL,FARB+17*40+17
        LD      (HL),A
        LD      HL,FARB+21*40+5
        LD      (HL),A    
        LD      HL,FARB+21*40+17
        LD      (HL),A
        LD      HL,FARB+21*40+31
        LD      (HL),A
        ;DATEINAME-------------------------------
        LD      DE,030CH
        CALL    SETCU
        LD      DE,NAMBUF
        CALL    PRNAM           ;BIS 0D
         ;SONGNUMMER-----------------------------
        LD      DE,(SNR)        ;1...(MAX)
        LD      HL,BWS+17*40+12
        CALL    DEZDE
        ;MAXIMALANZAHL SONGS--------------------
        LD      DE,(MAX)        ;GESAMTANZAHL
        LD      HL,BWS+18*40+12
        CALL    DEZDE
        ;SONGTITEL------------------------------
        CALL    INVERS
        LD      DE,0505H
        CALL    SETCU
        LD      HL,(MODADR)
        LD      DE,30           ;BEGINN TITEL
        ADD     HL,DE
        CALL    PRINFO          ;32 BYTES
        ;Songautor-------------------------------
        LD      DE,0605h
        CALL    SETCU
        LD      HL,(MODADR)
        ld      de,66 
        add     hl,de
        CALL    PRINFO          ;32 BYTES
        call    INVERS
        call    cuoff
        ;SONGTEMPO------------------------------
        LD      HL,(MODADR)
        LD      DE,100          ;HIER TEMPO
        ADD     HL,DE
        LD      A,(HL)
        LD      HL,BWS+7*40+28+6
        CALL    DEZA
        ;POSITIONEN GESAMT------------------------
        LD      HL,(MODADR)
        LD      DE,101          ;ANZAHL MUSTER GESAMT
        ADD     HL,DE
        LD      A,(HL)
        LD      HL,BWS+7*40+16+3
        CALL    DEZA
        ;SPIELDAUER--------------------------------
        CALL    CALC
        PUSH    HL
        LD      A,H
        LD      HL,BWS+18*40+30     
        CALL    DEZA            ;DEZIMALANZEIGE MINUTEN
        LD      A,":"           ;TRENNER
        CALL    PRINT
        POP     HL
        LD      A,L
        LD      HL,BWS+18*40+33   
        CALL    DEZA            ;DEZIMALANZEIGE SEKUNDEN
        LD      HL,(PT3TIME)    ;
        LD      (TICKS),HL      ;MERKEN
        ;MODUS-----------------------------------------
        LD      DE,1517H
        CALL    SETCU
        LD      A,(MODNR)
        LD      DE,T_SINGL
        OR      A               ;EINZEL?
        JR      Z,OBER1
        LD      DE,T_LISTE        
        CP      1
        JR      Z,OBER1
        LD      DE,T_REIHE 
        CP      2
        JR      Z,OBER1 
        LD      DE,T_ZUFAL
OBER1:  CALL    INVERS
        CALL    PRNST
        CALL    INVERS
        CALL    CUOFF
        ;ABSPIEL STARTEN----------------------------
        CALL    PLAY
        EI                      ;INT FREIGEBEN, SONG STARTET
        HALT                    ;SYNCHR.
;SCHLEIFE FR ANZEIGE-----------------------
LOOP:   XOR A
        LD      (25H),A         ;TASTATURPUFFER LSCHEN
        ;NACH JEDEM 4. DURCHLAUF BALKENABFALL
        DEFB    3Eh             ;LD      A,02H
OBER2:  DEFB    2     
        INC     A
        AND     03H             ;0...3
        LD      (OBER2),A
        JP      NZ,OBER5        ;HALTEN
        ;SPEKTRUM-PUFFER: ABFALL DES LETZTEN WERTES
        LD      B,20H           ;32X
        LD      HL,SPEKBU       ;PUFFERANFANG
OBER3:  XOR     A               ;
        OR      (HL)            ;INHALT AN POSI=0?
        JP      Z,OBER4         ;JA, NCHSTEN
        DEC     (HL)            ;NEIN, HHE VERMINDERN
OBER4:  INC     HL    
        DJNZ    OBER3
        ;SPEKTRUMWERTE ERMITTELN+ANZEIGEN
OBER5:  LD      HL,(TON_A)      ;TONHHE A
        LD      A,(VOL_A)       ;LAUTSTRKE A
        CALL    SPEKT
        LD      HL,(TON_B)      ;TONHHE B
        LD      A,(VOL_B)       ;LAUTSTRKE B
        CALL    SPEKT
        LD      HL,(TON_C)      ;TONHHE C
        LD      A,(VOL_C)       ;LAUTSTRKE C
        CALL    SPEKT 
        CALL    SPEKANZ         ;SPEKTRUM ANZEIGEN
        ;ANZEIGE FORTSCHRITT
        LD      A,(POSI)        ;AKT. POSI
        LD      HL,BWS+7*40+12
        CALL    DEZA
        ;AKT. MUSTER-NR.
        LD      HL,(CRPSPTR)    ;ADRESSE MIT AKT. PATTERN
        LD      A,(HL)          ;PATTERN-NR.
        CALL    DIV3            ;./. 3
        LD      HL,BWS+7*40+24
        CALL    DEZA
        ;RESTZEITANZEIGE
        CALL    PT3T_EXIT       ;HOLEN
        LD      A,20            ;TEST AUF
        CP      H               ;BERLAUF?
        JR      c,xxx           ;JA!
        PUSH    HL
        LD      A,H
        LD      HL,BWS+17*40+30     
        CALL    DEZA            ;DEZIMALANZEIGE MINUTEN
        LD      A,":"           ;TRENNER
        CALL    PRINT
        POP     HL
        LD      A,L
        LD      HL,BWS+17*40+33   
        CALL    DEZA            ;DEZIMALANZEIGE SEKUNDEN
xxx:   ;SONGENDE BERCKSICHTIGEN
        LD      HL,SETUP
        BIT     7,(HL)          ;ENDE-BIT =1 GESETZT?
        JR      Z,OBER6         ;NOCH NICHT
        ;SONG ZUENDE
        RES     7,(HL)          ;ZURCKSETZEN 
        LD      A,1
        LD      (POSI),A
        BIT     0,(HL)          ;LOOP-BIT=0 GESETZT ?
        RET     NZ              ;KEIN LOOP
        ;LOOP:
        LD      HL,(TICKS)      ;GESAMTZEIT
        LD      (PT3TIME),HL    ;ALS NEUE RESTZEIT
OBER6:  ;TASTATURABFRAGE
        CALL    CSTS            ;TASTATURSTATUS
        CP      "L"             ;LOOP EIN/AUS
        CALL    Z,LOOP_EA
        CP      "P"
        CALL    Z,PAU_EA        ;PAUSE E/A
        CP      "-"
        RET     Z
        CP      "+"
        RET     Z
        CP      "M"             ;MEN
        RET     Z
        JP      LOOP
;-------------------------------------------------
;TITEL+AUTOR ANZEIGEN (32 BYTES)
PRINFO: LD      B,32            ;30 BYTES
TI:     LD      A,(HL)
        CALL    CONSO           ;ZEICHEN AN SCHIRM
        INC     HL
        DJNZ    TI
        JP      CUOFF
;-------------------------------------------------
PAU_EA: ;PAUSE EIN/AUS
        PUSH    AF
        LD      A,(PAUSE)
        CPL
        LD      (PAUSE),A
        OR      A
        LD      DE,T_AUS        ;"AUS"
        JR      Z,PAU1          ;NEIN
        CALL    STOPP1          ;STUMMSCHALTEN
        CALL    CLEARSP         ;SPEKTRUM LSCHEN
        LD      DE,T_EIN        ;"EIN"
PAU1:   LD      HL,BWS+21*40+24
PAU2:   CALL    TXTOUT
        POP     AF
        RET
;-----------------------------------------
LOOP_EA:PUSH    AF
        LD      A,(SETUP)
        XOR     1               ;LOOP_BIT
        LD      (SETUP),A       ;INVERTIEREN
        ;ANZEIGE LOOP EIN/AUS
        LD      HL,BWS+21*40+11
        OR      A               ;0=EIN ?
        LD      DE,T_EIN        ;ja
        JR      Z,PAU2 
        LD      DE,T_AUS        ;"AUS"
        JR      PAU2            ;AUSGABE TEXT
;-------------------------------------------------
;DEZIMALANZEIGE DE, 4STELLIG
;POSITION IN HL
DEZDE:  LD      (BSP),HL        ;AUSGABE-POSITION
        LD      C,30H           ;KEINE VORNULL-UNTERDRCKUNG!
        LD      HL,03E7h        ;999
        AND     A
        SBC     HL,DE
        JR      C,DEZ3
        LD      A,C
        CALL    PRINT           ;AUSGEBEN AUF SCHIRM
        JR      DEZ1
        ;DEZIMALANZEIGE  A=AUSGABEWERT
;HL=SCHIRMPOSITION ZEILE,SPALTE
DEZA:   LD      (BSP),HL
        LD      C,30H
        LD      E,A
        LD      D,0
        JR      DEZ2
DEZ1:   LD      C,30H
        LD      HL,0063H        ;99
        AND     A
        SBC     HL,DE
        JR      C,DEZ3
        LD      A,C
        CALL    PRINT         ;AUSGEBEN AUF SCHIRM
DEZ2:   LD      HL,0009H        ;9
        AND     A
        SBC     HL,DE
        JP      C,DEZ3
        LD      A,C
        CALL    PRINT           ;AUSGEBEN AUF SCHIRM
DEZ3:   EX      DE,HL
DEZ4:   LD      DE,000AH
        CALL    DEZ5
        LD      A,L
        LD      H,B
        LD      L,C
        PUSH    AF
        LD      A,L
        OR      H
        CALL    NZ,DEZ4
        POP     AF
        ADD     A,30H            ;ZIFFER
        CALL    PRINT           ;AUSGEBEN AUF SCHIRM
        RET                     ;AUSGEBEN AUF SCHIRM
DEZ5:   LD      B,L
        LD      L,H
        LD      H,0
        CALL    DEZ6
        LD      H,L
        LD      L,B
        LD      B,C
DEZ6:   LD      C,0FFH
DEZ7:   AND     A
        SBC     HL,DE
        INC     C
        JP      NC,DEZ7
        ADD     HL,DE
        RET
;-------------------------------------------------
;A:=A/3
DIV3:   LD      D,A
        LD      E,3
        XOR     A
        LD      B, 8
_LOOP:  SLA     D
        RLA
        CP      E
        JR      C, $+4
        SUB     E
        INC     D
        DJNZ    _LOOP
        LD      A,D
        RET
;Spektrum-----------------------------------------
;PUFFER LSCHEN
CLEARSP:LD       HL,SPEKBU-1
        LD       (HL),0
        LD       DE,SPEKBU
        LD       BC,34
        LDIR
        CALL     SPEKANZ
        RET
;SPEKTRUMWERTE ERMITTELN-------------------------
;KOMMT MIT  
; A= LAUTSTRKE (0...15+)   = AKT. BALKENHHE
;HL= TONHHE  (0FFF...0001) = BALKENPOSITION

SPEKT:  RRA                     ;./. 2
        AND     7               ;0...7 LAUTSTRKE
        LD      B,A             ;MERKEN
        SCF
        CCF
        RL      L
        RL      H               ;HL=FREQUENZWERT *2
        RL      L               ;NOCHMAL, SO
        RL      H               ;BESSERER VERLAUF
        
        LD      A,H             ;NUR HIGH-TEIL
        AND     1FH             ;0...31
        LD      L,A
        LD      H,0
        ;HL=0...1F  = 32 FREQUENZ-STUFEN        
        ;NICHTLINEAR, OBEN SEHR GEDRNGT!
        ;AUF ENTSPRECHENDER TABELLENPOSITION WIRD 
        ;NUN DIE AKTUELLE LAUTSTRKE ABGELEGT:
        ;DIE DREI KANLE VERODERT
        LD      DE,SPEKBU       ;PUFFERANFANG
        ADD     HL,DE           ;AKT. POSI
        ;LD     B,A             ;LAUT
        LD      A,B
        OR      (HL)            ;MIT ALTEM WERT VERODERN
        LD      (HL),A          ;ABLEGEN
        ;RECHTS UND LINKS DANEBEN NOCH JEWEILS HALBE SULE
        ;DAMIT WIRD DER LINKE STARK GEDEHNTE NIEDERFREQUENTE
        ;BEREICH BESSER "GEFLLT"
        INC     HL              ;NCHSTES
        SRL     B               ;B:= B/2
        LD      A,B
        OR      (HL)
        LD      (HL),A          ;RECHTS DANEBEN
        DEC     HL
        DEC     HL
        LD      A,B
        OR      (HL)
        LD      (HL),A          ;LINKS DANEBEN
        RET
;-------------------------------------------------
SPEKANZ:;SPEKTRUM-PUFFER IST BEFLLT, JETZT DARSTELLEN
;METHODE ABHNGIG VON BWS-BEHANDLUNG 
        LD      B,20H           ;32 BNDER
        LD      HL,SPEKBU       ;ANFANG
SPANZ1: PUSH    BC
        LD      A,(HL)          ;PUFFERWERT HOLEN
        INC     HL
        PUSH    HL              ;NCHSTEN
        ;1 BALKEN DARSTELLEN
        LD       HL,BWS+15*40+3 ;LAGE SPEKTRUM LINKS UNTEN
        LD       E,B            ;DE= N*+100H   0...7 
        LD       D,0
        ADD      HL,DE          ;BALKEN RECHTS DANEBEN
        LD       DE,40          ;ABSTAND SENKRECHT
        OR       A
        JR       Z,SPANZ3       ;KEIN BALKEN
        ;JE NACH AMPLITUDE MEHRERE KLTZER:
        LD      B,A             ;PUFFERWERT = BALKENHHE
SPANZ2: LD      (HL),0B4H       ;KLOTZ ZEICHNEN
        SBC     HL,DE           ;1 ZEILE HHER
        DJNZ    SPANZ2
        ;RESTL. KLTZER LSCHEN
SPANZ3: LD       B,A            ;AKT. HHE
        LD       A,7            ;MAX
        SUB      B
        LD       B,A            ;RESTHHE
        OR       A
        JR       Z,SPANZ5       ;NICHTS ZU LSCHEN
SPANZ4: LD       (HL),' '       ;LSCHEN
        SBC      HL,DE          ;1 ZEILE HHER
        DJNZ     SPANZ4         
        ;NCHSTER BALKEN
SPANZ5: POP     HL
        POP     BC
        DJNZ    SPANZ1          ;32X
        RET
;-------------------------------------------------
LINEH:  LD      B,32            ;LINIE 32x '-' HORIZoNTAL
LH1:    LD      (HL),A
        INC     HL
        DJNZ    LH1
        RET
;-------------------------------------------------
LINEV:  LD      B,22            ;LINIE 20x "|" VERTIKAL
        LD      DE,40
LV1:    LD      (HL),A
        ADD     HL,DE
        DJNZ    LV1
        RET
;-------------------------------------------------
RAHMEN: LD      HL,BWS+1*40+3
        LD      A,0A1H
        CALL    LINEV
        LD      HL,BWS+1*40+36
        CALL    LINEV
        LD      HL,BWS+1*40+3
        LD      (HL),0A8H
        INC     HL
        LD      A,0A0H
        CALL    LINEH
        LD      (HL),0A9H

        LD      HL,BWS+3*40+3
        LD      (HL),0A3H
        INC     HL
        CALL    LINEH
        LD      (HL),0A5H

        LD      HL,BWS+6*40+3
        LD      (HL),0A3H
        INC     HL
        CALL    LINEH
        LD      (HL),0A5H

        LD      HL,BWS+8*40+3
        LD      (HL),0A3H
        INC     HL
        CALL    LINEH
        LD      (HL),0A5H

        LD      HL,BWS+16*40+3
        LD      (HL),0A3H
        INC     HL
        CALL    LINEH
        LD      (HL),0A5H

        LD      HL,BWS+19*40+3
        LD      (HL),0A3H
        INC     HL
        CALL    LINEH
        LD      (HL),0A5H

        LD      HL,BWS+22*40+3
        LD      (HL),0A7H
        INC     HL
        CALL    LINEH
        LD      (HL),0AAH
        
        LD      HL,BWS+16*40+20
        LD      (HL),0A4h
        LD      HL,BWS+17*40+20
        LD      (HL),0A1h
        LD      HL,BWS+18*40+20
        LD      (HL),0A1h
        LD      HL,BWS+19*40+20
        LD      (HL),0A2h
        RET
;-------------------------------------------------
;SCHIRMAUSGABE DIREKT IN BWS (PUFFER BSP)
PRINT:  PUSH    HL
        LD      HL,(BSP)        ;ZIELADRESSE HOLEN
        LD      (HL),A          ;AUF SCHIRM SCHREIBEN
        INC     HL              ;VIRT. KURSOR WEITER
        LD      (BSP),HL    
        POP     HL
        RET        
;BALKENFARBE--------------------------------------
;BEREICH SPEKTRUM: BLAU ALS VORDERGRUNDFARBE
BALKCOL:LD      A,40H           ;BLAU AUF SW
        LD      DE,40
        LD      HL,FARB+8*40+4
        LD      B,7
MARK1:  PUSH    BC     
        ADD     HL,DE 
        PUSH    HL              ;ANFANG MERKEN
        LD      B,32
MARK2:  LD      (HL),A
        INC     HL
        DJNZ    MARK2
        POP     HL              ;ANFANG
        POP     BC
        DJNZ    MARK1
        RET
;------------------------------------------------
;ZUFALLSGENERATOR
;SEED WIRD BEIM PROGRAMMSTART GESETZT (R-REGISTER)
ZUFGEN: LD      DE,(SEED)       ;STARTWERT
        LD      A,D
        LD      H,E
        LD      L,253
        OR      A
        SBC     HL,DE
        SBC     A,0
        SBC     HL,DE
        LD      D,0
        SBC     A,D
        LD      E,A
        SBC     HL,DE
        JR      NC,RAND
        INC     HL
RAND:   LD      (SEED),HL      ;SEED GGF. FR NCHSTEN LAUF
        ;HL= PSEUDO-ZUFALLSZAHL 0000...FFFF
        ;BEGRENZEN AUF (TMAX) : DIVISION, REST NEHMEN!
        LD      DE,(TMAX)
        LD      A,H
        LD      C,L
        ;DIV_AC_DE, REST IN HL
        LD      HL, 0
        LD      B, 16
Z_LOOP: DEFB    0CBh,31h       ;"SLL C"=UNDOKUMENTIERTER OP-CODE
        RLA
        ADC     HL, HL
        SBC     HL, DE
        JR      NC, $+4
        ADD     HL, DE
        DEC     C
        DJNZ    Z_LOOP
        ;REST=HL=BEGRENZTE ZAHL 0...(DATANZ-1)
        RET
;SCHNELLERES CLS-----------------------------------
CLS:    ;FARBE
        LD      HL,FARB
        LD      (HL),20H    ;GRN AUF WEI
        LD      DE,FARB+1
        LD      BC,960
        LDIR
        ;ASCII
        LD      HL,BWS
        LD      (HL),20H    ;LEERZEICHEN
        LD      DE,BWS+1
        LD      BC,960
        LDIR
        LD      DE,0101H
        CALL    SETCU       ;HOME
        JP      CUOFF
;-----------------------------------------------
INVERS: LD      A,16H
        JP      CONSO
;BOS-FUNKTIONEN----------------------------------
RESET:  LD      C,0         ;SYSTEM-NEUSTART
        JR      BOS
CONSI:  LD      C,1         ;EINGABE EINES ZEICHENS VON CONST         
        JR      BOS
CONSO:  PUSH    HL
        PUSH    DE
        PUSH    BC
        LD      E,A
        LD      C,2         ;AUSGABE EINES ZEICHENS ZU CONST 
        CALL    5
        POP     BC
        POP     DE
        POP     HL
        RET
PRNST:  LD      C,9         ;ZK AUSGABE KC87
        JR      BOS         ;ENDE ZK=00
RCONB:  LD      C,10        ;EINGABE ZK
        JR      BOS
CSTS:   LD      C,11        ;TAST.STATUS ABFRAGEN
        JR      BOS
GETCU:  LD      C,17        ;KURSORPOS. ABFRAGEN
        JR      BOS
SETCU:  LD      C,18        ;CURSOR SETZEN (D=ZEILE, E=SPALTE)
        JR      BOS             
CUOFF:  LD      C,29        ;CURSOR AUS
BOS:    JP      5 
;-------------------------------------------------
;TEXT AB DE DIREKT AUSGEBEN AUF BWS, BIS 0
;KOMMT MIT HL=ANFANGSADRESSE SCHIRM
TXTOUT: LD      (BSP),HL 
TXT1:   LD      A,(DE)      ;ZEICHEN HOLEN
        OR      A           ;ENDE ERREICHT?
        RET     Z           ;JA
        CALL    PRINT       ;AUSGEBEN AUF SCHIRM
        INC     DE
        JR      TXT1        ;NCHSTES
;-------------------------------------------------
;TEXT AUSGEBEN BIS FF
TOUT:   LD      A,(HL)      ;ZEICHEN HOLEN
        CP      0H          ;ENDE ERREICHT?
        RET     Z           ;JA
        CALL    CONSO       ;AUSGEBEN AUF SCHIRM
        INC     HL
        JR      TOUT        ;NCHSTES
;--------------------------------------------------
KOPF:   CALL    CLS
        LD      DE,0101H
        CALL    SETCU
        LD      DE,T1
        CALL    PRNST
        CALL    LINE
        LD      DE,T3
        CALL    PRNST
        LD      DE,T4
        CALL    PRNST
        CALL    LINE
        LD      DE,T5
        CALL    PRNST
        JP      CUOFF
;----------------------------------------------------
LINE:   LD      B,29        
        LD      A,0A0H 
LI2:    CALL    CONSO  
        DJNZ    LI2
        RET
;-----------------------------------------------------
T1:     DEFM "     ",0A8H,0
T3:     DEFB 0A9H,0DH,0AH,0
T4:     DEFM "     ",0A1H,"PT3-EOS-PLAYER     KC87/Z9001",0A1H,0DH,0AH
        DEFM "     ",0A1H,"VERS.1.1           WeRo '2018",0A1H,0DH,0AH
        DEFM "     ",0A7H,0
T5:     DEFB 0AAH,0DH,0AH,0
;-----------------------------------------------------
BEFEHLE:DEFM "       (L)ADEN EINZELSONG",0DH,0AH,0AH 
        DEFM "       (P)LAYLISTE  SPIELEN",0DH,0AH,0AH
        DEFM "       (A)LLE SONGS SPIELEN",0DH,0AH,0AH 
        DEFM "       (Z)UFALLSABSPIEL",0DH,0AH,0AH 
        DEFM "       (U)SB STICKWECHSEL/INIT",0DH,0AH,0AH
        DEFM "       (I)NFO",0DH,0AH,0AH           
        DEFM "       (E)NDE",0DH,0AH,0AH  
        DEFM "        -> FUNKTION:",0
;----------------------------------------------------
T_PLAY: DEFM "DATEI:",0dh,0ah,0ah,0ah,0ah,0ah
        DEFM "    MUSTER:    von    (#..) TEMPO:" 
        DEFM 0DH,0ah,0ah,0ah,0ah,0ah,0ah,0ah,0ah,0ah,0ah
        DEFM "    SONG:(-)    (+)    DAUER:",0DH,0ah
        DEFM "     von:                von:",0DH,0ah,0ah
        DEFM "               ",16h,"MODUS: ",16h,0DH,0AH
        DEFM "    (L)OOP:aus  (P)AUSE:aus   (M)ENU",0
;-----------------------------------------------------
T_INFO: DEFM 0DH,0AH
        DEFM "UNTER VERWENDUNG FOLGENDER GRUNDROUTINEN",0dh,0ah,0ah
        DEFM "*PT3 PLAYER ZX SPECTRUM : S. BULBA, 2007"
        DEFM "*PT3 DURATION CALCULATOR: S. BULBA, 2005"
        DEFM "*SPEKTRUMANZEIGE (ST1.x): 'BZYK',   1992",0
;-------------------------------------------------------
T_EIN:  DEFM "ein",0
T_AUS:  DEFM "aus",0
T_SINGL:DEFM "EINZEL",0
T_LISTE:DEFM "LISTE",0
T_REIHE:DEFM "REIHE",0
T_ZUFAL:DEFM "ZUFALL",0
T_INIT: DEFM 0ah,"      INIT USB...",0
T_NOPT3:DEFM "      KEIN PT3-VERZEICHNIS!",0DH,0AH,0
T_NIX:  DEFM "KEINE SONGS IN /PT3!",0
PT3:	DEFM "PT3",0	;Endung
PT3X:   DEFM 3,"PT3"        ;UNTERVERZEICHNISNAME
ROOT:   DEFM 1,"/"          ;WURZELVERZEICHNIS
T_USBERR:   DEFM " USB-FEHLER!",0
T_NOTFND:   DEFM " NICHT GEFUNDEN!",0
T_WEITER:   DEFM 0DH,0AH,"<ET>=DIR, <STOP>=ABBRUCH>",0
T_NAM:      DEFM 0DH,0AH,"DATEINAME (OHNE .PT3) ? ",0
T_ZAEHLE:   DEFM "ZAEHLEN...",0
T_LADE:     DEFM "LADEN: ",0
T_SUCHE:    DEFM "SUCHEN... ",0
T_MOMENT:   DEFM 16h," MOMENT...",16h,0
T_BNAM:     DEFM "!PLAYLST.TXT",0DH,0
T_STAPEL:   DEFM "PLAYLISTE...",0
T_EINLES:   DEFM "LESE SONGS EIN...",0
T_ZUVIEL:   DEFM "ZU VIELE SONGS.",0
T_PAUSE:    DEFM "PAUSE ",0
;------------------------------------------------------
KAT0:   LD      HL,KAT          ;ANFANGSADRESSE KATALOG
        LD      (KATPOS),HL     ;MAX. 8 K BEI 511 SONGS
        DEC     HL              ;VORBYTE AUCH!
        LD      (HL),0          ;LSCHEN
        LD      DE,KAT          ;
        LD      BC,1FFFH        ;
        LDIR 
        RET
;-------------------------------------------------
;DATEIANZAHL (RCK)SETZEN, ERHHEN, PRFEN
DIR0:   PUSH    HL
        LD      HL,0
        JR      DIR2
DIR1:   PUSH    HL
        LD      HL,1
DIR2:   LD      (MENGE),HL
DIR3:   LD      (DIRANZ),HL
        POP     HL
        RET
;--------------------------------------------
DIRPLUS:PUSH    HL
        LD      HL,(DIRANZ)
        INC     HL              ;ZHLEN
        JR      DIR3
;--------------------------------------------
ISNULL: LD      HL,(DIRANZ)     ;ANZAHL SONGS
        LD      A,H
        OR      L               ;=0?
        RET
;-----------------------------------------------
PRNAM:  LD      A,(DE)
        CP      0H             ;OHNE 0!
        RET     Z
        CALL    CONSO
        INC     DE
        JR      PRNAM 
;-----------------------------------------------------
SHORT:  ;Anzeigepause
        PUSH    BC
        LD      BC,08000h
SHORT1: DEC     BC
        LD      A,B
        OR      C
        JR      NZ,SHORT1
        POP     BC
        RET
;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
;EOS-ROUTINEN
;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$


dirz	db	"?PT3",0	; entspricht *.PT3

DIR:    ; OS-Funktion DIR (ohne anzeigen)
	ld	a,11100000b	; mit Suchmuster, ablegen im Speicher
	ld	de,dirz		; Suchmuster
	LD      HL,KAT      	;ANFANGSADRESSE KATALOG
	LD      (KATPOS),HL 	;MAX. 4 K BEI 255 SONGS
	ld	c,19		; DIRS
	call	5
	LD      (KATPOS),HL 	; Ende-Adr.
	;
	LD      IX,KAT 		; Pointer f. DIR
	; Ablage im Katalog als 
;	1. Byte Typ (D ir/F ile), Name Format "8.3", 0 byte
;	Ende mit 0
;	HL = Ende Adr. Buffer

; 2000   46 4B 52 49 53 54 49 4E 41 2E 50 54 33 00 46 4B   FKRISTINA.PT3.FK
; 2010   52 4F 53 48 4B 41 2E 50 54 33 00 46 4C 45 4E 41   ROSHKA.PT3.FLENA
; 2020   2E 50 54 33 00 46 4D 41 43 48 4F 2E 50 54 33 00   .PT3.FMACHO.PT3.
; 2030   46 4E 4F 50 4F 57 45 52 2E 50 54 33 00 46 4F 49   FNOPOWER.PT3.FOI
; 2040   4C 2E 50 54 33 00 46 54 45 41 52 53 2E 50 54 33   L.PT3.FTEARS.PT3
; 2050   00 46 54 52 59 2E 50 54 33 00 00 00 FF 00 FF 00   .FTRY.PT3.......


;-----------------------------------------------
;INHALT USB ANZEIGEN/KATALOGISIEREN/ZHLEN(HOLEN
;KOMMT MIT(DIRFLG) = 0   -> ANZEIGE AUF SCHIRM
;                    1   -> KATALOGISIEREN
;                    2   -> NUR ZHLEN
;                    3   -> N-TEN DATEINAME HOLEN
;                           N IN (ASCII)
;DIR:
	CALL    DIR0                ;DATEIZHLER
        XOR     A
        LD      (SPZ),A             ;POSITIONSZHLER SPALTE

DIR05A: LD      HL,INBUFF
	CALL    CHECKB              ;Typ, 0=ENDE
        RET	Z		; Ende-> Fertig

	;DATEINAME BAUEN
DIR05:  CALL    CHECKB              ;0=ENDE EINES NAMENS?
        LD      (HL),A
        INC     HL
        JP      NZ,DIR05            ;NEIN, WEITER LESEN

        ; nicht ntig, ist schon erfolgt
;;        DEC     HL
;;        ;NAME VORHANDEN, ENDUNG TESTEN
;;        LD      DE,PT3         ;FILTER PT3
;;        INC     DE
;;        INC     DE
;;        LD      A,(DE)
;;        CP      (HL)
;;        JP      NZ,DIR09
;;        DEC     HL
;;        DEC     DE
;;        LD      A,(DE)
;;        CP      (HL)
;;        JP      NZ,DIR09
;;        DEC     HL
;;        DEC     DE
;;        LD      A,(DE)
;;        CP      (HL)
;;        JP      NZ,DIR09
;;        ;JA: NAME ERFLLT BEDINGUNG
        CALL    DIRPLUS         ;EINE MEHR
        LD      A,(MENGE)
        INC     A  
        LD      (MENGE),A   ;ANZAHL PRO SCHIRM
        ;GUCKEN, WELCHER MODUS-----------------
        LD      A,(DIRFLG)   
        OR      A               ;ANZEIGEN?
        JR      Z,D_ANZ         ;JA
        CP      2               ;ZHLEN?
        JP      Z,DIR09         ;JA
        CP      1               ;KATALOGISIEREN?
        JP      Z,D_COP         ;JA.
        ;N-TEN NAMEN HOLEN: TEST (DIRANZ)=(ASCII)
        LD      HL,(DIRANZ)     ;AKT. ANZAHL
        LD      DE,(ASCII)      ;ZUFALLSZAHL
        OR      A
        SBC     HL,DE           ;ERREICHT?
;;        JP      Z,REST1         ;JA, REST ABHOLEN+RAUS
	RET	Z
        JP      DIR09           ;WEITER SUCHEN
D_ANZ: ;NORMAL AUF SCHIRM AUSGEBEN, FORMATIERT IN 3 SPALTEN
        ;(USB) = SPALTENPOSITION
        CALL    GETCU           ;E=AKT. DRUCKSPALTE
        LD      HL,SPZ          ;SCHIRMPOSI 0..2
        INC     (HL)            ;1...3
        LD      A,(HL)
        CP      1               ;SPALTE 0 ?
        JR      NZ,SP0 
        ;JA
SPX:    LD      E,1
        INC     D               ;NEUE ZEILE
        JR      SK
SP0:    CP      2               ;SPALTE 1?
        JR      NZ,SP1
        ;JA
        LD      E,14
        JR      SK
SP1:    ;SPALTE 2
        LD      E,27
        LD      (HL),0          ;VON VORN ANFANGEN
SK:     CALL    SETCU           ;NEUE DRUCKSPALTE
        LD      HL,INBUFF       ;NAMENSPUFFER
        CALL    TOUT            ;AUSGABE
        ;ANZAHLTEN, WENN SCHIRM VOLL
        LD      A,(MENGE)
        CP      60              ;60 DATEIEN, DANN STOP
        JR      C,DIR09 
        LD      DE,T_WEITER
        CALL    PRNST
        CALL    CONSI           ;WEITER ODER STOPP?
        CP      3               ;WAR STOPP
;;        JR      Z,REST          ;NOCH REST ABHOLEN 
        RET	Z
        CALL    CLS
        XOR     A
        LD      (SPZ),A         ;VON VORN ANFANGEN
        LD      (MENGE),A
        JR      DIR09
        ;IN KATALOG KOPIEREN
        ; nicht ntig, der Katalog steht schon
D_COP:  
;;	LD      DE,(KATPOS)     ;AKT. POSI IM KATALOG
;;        LD      HL,INBUFF
;;COP:    LD      A,(HL)      
;;        CP      "."
;;        JR      Z,COP1          ;NOCH PT3+0D ANHNGEN
;;        LDI
;;        JR      COP
;;COP1:   LD      (DE),A          ;. ABLEGEN
;;        INC     DE
;;        LD      HL,PT3
;;        LDI
;;        LDI
;;        LDI
;;        LD      A,0DH
;;        LD      (DE),A
;;        INC     DE
;;        LD      (KATPOS),DE     ;NEUE POS.
;;        ;BEGRENZUNG KATALOGGRE!
;;        ;DE= AKT. KATALOGADRESSE
;;        LD      HL,MAXKAT-13     ;8000
;;        OR      A
;;        SBC     HL,DE
;;        JR      NC,DIR09        ;NOCH IM BEREICH
;;        ;ZUVIELE!
;;        LD      DE,T_ZUVIEL
;;        CALL    PRNST
;;        CALL    CUOFF
;;        ;DIR-REST ABHOLEN
;;        JR      REST1

DIR09:  JP      DIR05A        	  ;NEIN

;-------------------------------------------------
USBERR4:LD      DE,T_NOTFND
        CALL    PRNST
        SCF                     ;FEHLERFLAG
        RET
;------------------------------------------------------
;ALS LETZTES ZEICHEN KOMM IMMER 00H
CHECKB: ld	a,(ix+0)
	inc	ix
        CP      00H                 ;VORGANG BEENDET?
        RET   
;------------------------------------------------------
	 ;KOMMT MIT HL=ZEIGER AUF STRINGANFANG (ENDE=0H)
USB_CD: LD	A,(HL)
	LD	B,A		; Anz. Zeichen
	INC	HL
	PUSH    HL
	POP	DE		; Text
	ld	C,32		; CHDIR
	CALL	5
        RET
;------------------------------------------------------
_LADEUSB:   ;DATEI PER USB LADEN
;IN  NAMBUF STEHT ADRESSE DES DATEINAMENS
;IN (RAMADR) STEHT SPEICHERADRESSE, AUF DIE EINZULESEN IST
	LD	DE,CONBU
	ld	a,15
	ld	(de),a		;#max zeichen
	inc	de
	ld	(de),a		;#anz zeichen
	inc	de

	LD	HL,NAMBUF	;ADRESSE DATEINAME
	;;LD	DE,CONBU
	LD	BC,15
	LDIR			; Name nach COMBU

	LD	A,'N'
	LD	(fcb+24),A	; Laden ohne Kopfblock
	LD	HL,(RAMADR)	; Ladeadresse
	LD	A,1		; Dateiname "Name[.Typ]" in CONBU
	ld	c,34		; CLOAD
	call	5
	JP	C,USBERR4           ;DATEI NICHT GEFUNDEN!
	RET
;-------------------------------------------------
; Dateiname kopieren
; in HL=Format "8.3",0 oder "12345678EEE",0
; kopieren nach DE als "8.3",0

COPYFN:	LD	BC,8
SERIE5:	LD	A,(HL)
	LDI
	CP	0H	;NAME FERTIG KOPIERT?
	RET	Z	;JA
	CP	'.'
	JR	Z,SERIE6	;wenn Punkt kopiert
	CP	' '		;Leerzeichen?
	JR	NZ,SERIE5B	;diese nicht kopieren
	DEC	DE
SERIE5B:	LD	A,B
	OR	C
	JR	NZ,SERIE5	;max 8 Zeichen
;folgt Punkt? nein, dann einfuegen
	LD	A,'.'
	CP	(HL)
	JR	Z,SERIE5
	LD	(DE),A
SERIE5A:	INC	DE
	JR	SERIE5
;nach punkt alles weiterkopieren
SERIE6:	ld	bc,0
	JR	SERIE5


;-------------------------------------------------
SONG:   ;AB HIER STEHT PT3-DATEI
ENDE:
