	cpu	z80

; Hardcopy 
; Drucker K6313 oder Epson LX86
; 7000-7DFF HARDC und ZG-ROMA
; B800-BFFF Druckertreiber V24A3
; ZG-ROMA (US, Klammern) oder ZG-ROM (Umlaute) in Adressbereich 7600H-7DFFH einlesen
; eigene Grafikzeichen 7A00-7DFF


BUFF:	EQU	7000H		; mind 400h

SEQU:	EQU	BUFF+30H	
BITI:	EQU	SEQU+6	
ZGB:	EQU	7A00H	

	ORG	7200H	
	LD	C,5		; LISTO
	LD	E,27		; ESC 
	CALL	5	
	LD	E,'1'		; 1
	CALL	5	
	LD	HL,SEQU1	
	LD	DE,SEQU	
	LD	BC,6	
	LDIR		
	LD	HL,0EC00H	; BWS
	LD	B,24		; Anz. Zeilen
MX1:	PUSH	BC	
	LD	DE,BUFF	
	LD	BC,40		; Anz Zeichen/Zeile
	LDIR		
	PUSH	HL	
	CALL	PRZ		; PrintZeile
	POP	HL	
	POP	BC	
	DJNZ	MX1	
	RET		
; Leerzeichen (8x 00) 
SPACE:	LD	B,8	
	XOR	A	
X11:	LD	(DE),A	
	INC	DE	
	DJNZ	X11	
	JR	X5	
; PrintZeile
PRZ:	LD	HL,BITI	
	LD	DE,BUFF	
	EX	DE,HL	
	LD	B,40		; Anz Zeichen/Zeile
X4:	PUSH	BC	
	LD	A,(HL)	
	CP	A, 32		; A < ' '?	
	JR	C, SPACE	; Steuerzeichen als Space ausgeben
	JR	GRDR		; Grafikdruck
;
X5:	POP	BC	
	INC	HL	
	DJNZ	X4	
	LD	HL,SEQU	
	LD	B,2	
MX2:	PUSH	BC	
	LD	B,163	
X15:	PUSH	BC	
	LD	C,5		; LISTO
	LD	E,(HL)	
	CALL	5	
	INC	HL	
	POP	BC	
	DJNZ	X15	
	POP	BC	
	DJNZ	MX2	
	; Zeilenvorschub
	LD	C,5		; LISTO
EXN:	LD	E,0AH		; LF+CR
	CALL	5	
	LD	E,0DH	
	JP	5	

; Grafikdruck
; in: HL=BUFF
GRDR:	PUSH	HL
	PUSH	DE	
	LD	A,(HL)	
	SUB	32	
	LD	E,A	
	LD	D,0	
	LD	HL,ZGB-768	; 768=32*24
				; Buchstabencodes ab 20h
	LD	B,8	
X7:	ADD	HL,DE	
	DJNZ	X7	
	POP	DE	
	;
	EX	DE,HL	
	LD	B,8	
X9:	PUSH	BC	
	PUSH	HL	
	LD	A,(DE)	
	LD	B,8	
X10:	SLA	A	
	RL	(HL)	
	INC	HL	
	DJNZ	X10	
	POP	HL	
	POP	BC	
	INC	DE	
	DJNZ	X9	
	;
	LD	DE,8	
	ADD	HL,DE	
	EX	DE,HL	
	POP	HL	
	JR	X5	
	
	NOP		
	NOP		

SEQU1:	DB	' '	
	DB	27	
	DB	'*'	
	; ORG	+0A0h
MAR:	DB	5	; Druckmodus (1..6)
	DB	64	
	DB	1	

	ORG	ZGB+400H	
	DB	00	

	end
	