; Sprungvektortabelle
		jp	_boot
		jp	_wboot
		jp	_const
		jp	0F009h		; Z9001-OS: conin
		jp	_conout
		jp	0F00Fh		; Z9001-OS: list
		jp	0F012h		; Z9001-OS: punch
		jp	0F015h		; Z9001-OS: reader
		jp	_home
		jp	_seldsk
		jp	_settrk
		jp	_setsec
		jp	_setdma
		jp	_read
		jp	_write
		jp	0F02Dh		; Z9001-OS: listst
		jp	_sectran

;korrespondierende Umsetzungstabelle fr Aufuf der Schattenbios-Funktionen
_boot:		call	csbios		; Aufruf im Schattenbios
_wboot:		call	csbios		; Aufruf im Schattenbios
		call	csbios		; Aufruf im Schattenbios
		call	csbios		; Aufruf im Schattenbios
		call	csbios		; Aufruf im Schattenbios
		call	csbios		; Aufruf im Schattenbios
		call	csbios		; Aufruf im Schattenbios
		call	csbios		; Aufruf im Schattenbios
_home:		call	csbios		; Aufruf im Schattenbios
_seldsk:	call	csbios		; Aufruf im Schattenbios
_settrk:	call	csbios		; Aufruf im Schattenbios
_setsec:	call	csbios		; Aufruf im Schattenbios
_setdma:	call	csbios		; Aufruf im Schattenbios
_read:		jp	_read1
_write:		jp	_write1
		call	csbios		; Aufruf im Schattenbios
_sectran:	call	csbios


;-----------------------------------------------------------------------------
; call shadow bios function
;-----------------------------------------------------------------------------

csbios:		pop	hl		; HL = Returnadr. vom Stack = E236 (_wboot)  ...
		push	de		; DE sichern
		ld	de, _wboot
		or	a
		sbc	hl, de
		ld	de, sbios	; Adr. Schattenbios
		add	hl, de		; HL = orig.Return - adr(_wboot) + adr(sbios)
					; damit	HL = Adr. im Schattenbios
		pop	de		; DE restaurieren
csbios1:	ld	(stackp), sp	; Zwischenspeicher Stackpointer
		shadow_oni
		ld	sp, biosstack	; Adr. BIOS-Stackbereich
		ld	(csbios2+1), hl	; Memory Patch nachfolgender CALL-Befehl
csbios2:	call	0		; Call berechnete Adresse (HL)
		ld	sp, (stackp)	; Zwischenspeicher Stackpointer
		shadow_offi
		or	a
		ret

;-----------------------------------------------------------------------------
; wboot beenden und Bergabe der Kontrolle ans CCP
;-----------------------------------------------------------------------------

wboot3u:	shadow_offi
wboot3u1:	jp	CCP+0003h	; CLEAR: CCP-Aufruf mit	Lschen	des Befehlsbuffers

;-----------------------------------------------------------------------------
; write disk
;-----------------------------------------------------------------------------

_write1:	ld	hl, (ddma)
		ld	de, rwbuffer
		push	bc
		ld	bc, 80h		; Lnge Record
		ldir
		pop	bc
		ld	hl, uwrite	; WRITE	im Schattenbios
		jr	csbios1

;-----------------------------------------------------------------------------
; read disk
;-----------------------------------------------------------------------------

_read1:		shadow_oni
		ld	(stackp), sp	; Zwischenspeicher Stackpointer
		ld	sp, biosstack	; Adr. BIOS-Stackbereich
		call	uread		; READ im Schattenbios
		ld	sp, (stackp)	; Zwischenspeicher Stackpointer
		shadow_offi
		ld	hl, rwbuffer
		ld	de, (ddma)
		ld	bc, 80h		; Lnge Record
		ldir
		or	a
		ret

;-----------------------------------------------------------------------------
; console status
;-----------------------------------------------------------------------------

_const:		call	0F006h		; Z9001-OS: Abfrage Status CONST
		or	a
		ret	z
		ld	a, 0FFh
		ret

;-----------------------------------------------------------------------------
; BAT-Gertereiber fr CRT
;-----------------------------------------------------------------------------

_BATC:		or	a
		jp	nz, 0F7B4h	; Z9001-OS: BAT, Steuerprogramm fr Batch-Mode von CONST
		ld	hl, (0F016h)	; Z9001-OS: Adresse des UP READER (Eingabe Zeichen von Reader)
		inc	hl
		inc	hl
		jp	(hl)

;-----------------------------------------------------------------------------
; Dummy-Gertetreiber, gibt stets Dateiende (^Z) zurck
;-----------------------------------------------------------------------------

_dummyin:				; ^Z; Eingabeende
		ld	a, 1Ah
		ret

;-----------------------------------------------------------------------------
; console character out
;-----------------------------------------------------------------------------

_conout:	ld	a, (_con_esc)
		cp	0FFh		; normale Ausgabe?
		jr	z, _conout3
;		
		ld	hl, (_con_escp)	; Pointer in Liste
		res	7, c		; Bit 7 lschen
		inc	c		; + 1
		ld	(hl), c		; Zeichen merken
		dec	hl
		ld	(_con_escp), hl	; Pointer rcksetzen
		ld	hl, _con_esc	; Anzahl weiterer Kommando-Zeichen 
		dec	(hl)		; = 0?
		jr	nz, _conout2	; nein
;		
		dec	(hl)		; Anzahl weiterer Kommando-Zeichen - 1 setzen
		
		ld	hl, _conout1	; return-Adresse
		push	hl		; auf Stack
		ld	hl, (0F069h)	; Z9001-OS: Adr. Setzen log. Cursor
		push	hl		; auf Stack
		ld	l, 3		;  L=3, Anfangswert fuer Cursorrufe (OS-BOS)
		ld	de, (_con_escp1)	; DE := Zeile/Spalte
		ret			; und Cursor setzen
;
_conout1:	ld	hl, _con_escp2	; Pointer in Liste
		ld	(_con_escp), hl	; auf Anfang-1 setzen
;
_conout2:	or	a
		ret
;
_conout3:	ld	a, (25h)	; KEYBU	(Tastaturbuffer)
		cp	13h		; PAUSE-Taste?
		jr	nz, _conout4
		push	bc
		call	0F009h		; Z9001-OS: Eingabe Zeichen von CONST, PAUSE-Taste holen
		call	0F009h		; Z9001-OS: Eingabe Zeichen von CONST, Warten auf Tastendruck
		pop	bc
_conout4:	ld	a, 1Bh		; ESC?
		cp	c
		jp	nz, 0F00Ch	; Z9001-OS: Ausgabe Zeichen zu CONST
; Cursor-Positionierung 1Bh Zeile+128 Spalte+128 (kompatibel zum PC 1715)
		ld	a, 2		;escape flag setzen
		ld	(_con_esc), a
		jr	_conout1

_con_esc:	db 	0FFh		; Anzahl weiterer ESC-Kommando-Zeichen
_con_escp:	dw	_con_escp1	; Pointer in Liste der ESC-Kommando-Zeichen
_con_escp1:	db	0		; Parameterliste (Ringpuffer Lnge 2), hier Cursor-Zeile
_con_escp2:	db	0		; und Cursor-Spalte


;---------------------
bmode:		db 	0		; Bios-Mode: 'U'-Arbeit	im Upper Bios, 00-Arbeit im Schatten-Bios

;-----------------------------------------------------------------------------
; TTY-Treiber fr CONS
;-----------------------------------------------------------------------------

_TTYC:		ld	l, a
		ld	a, (bmode)	; Bios-Mode: 'U'-Arbeit	im Upper Bios, 00-Arbeit im Schatten-Bios
		or	a
		ld	a, l
		jp	z, uttyc
		shadow_oni
		call	uttyc
		shadow_offi
		ret

;-----------------------------------------------------------------------------
; CRT-Treiber fr CONS
;-----------------------------------------------------------------------------

_CRTC:		ld	l, a
		ld	a, (bmode)	; Bios-Mode: 'U'-Arbeit	im Upper Bios, 00-Arbeit im Schatten-Bios
		or	a
		ld	a, l
		jp	z, ucrtc
		shadow_oni
		call	ucrtc
		shadow_offi
		ret

;-----------------------------------------------------------------------------
; UP2 Gertreiber fr PUNCH
;-----------------------------------------------------------------------------

_up2:		ld	l, a
		ld	a, (bmode)	; Bios-Mode: 'U'-Arbeit	im Upper Bios, 00-Arbeit im Schatten-Bios
		or	a
		ld	a, l
		jp	z, uup
		shadow_oni
		call	uup
		shadow_offi
		ret

;-----------------------------------------------------------------------------
; CRT-Gertetreiber fr	LIST
;-----------------------------------------------------------------------------

_CRTL:		ld	l, a
		ld	a, (bmode)	; Bios-Mode: 'U'-Arbeit	im Upper Bios, 00-Arbeit im Schatten-Bios
		or	a
		ld	a, l
		jp	z, ucrtl
		shadow_oni
		call	ucrtl
		shadow_offi
		ret

	if S6010=1
;-----------------------------------------------------------------------------
; UBIOS S6010-Treiber f. PUNCH
;-----------------------------------------------------------------------------


_UP6010:        ld      l, a
                ld      a, (bmode)	; Bios-Mode: 'U'-Arbeit	im Upper Bios, 00-Arbeit im Schatten-Bios
                or      a
                ld      a, l
                jp      z, UP6010
                shadow_oni
                call    UP6010
                shadow_offi
                ret

;-----------------------------------------------------------------------------
; UBIOS S6010-Treiber f. READER
;-----------------------------------------------------------------------------

_UR6010:        ld      l, a
                ld      a, (bmode)	; Bios-Mode: 'U'-Arbeit	im Upper Bios, 00-Arbeit im Schatten-Bios
                or      a
                ld      a, l
                jp      z, UR6010
                shadow_oni
                call    UR6010
                shadow_offi
                ret
	endif		

;-----------------------------------------------------------------------------
; UL Gertretiber fr LIST
;-----------------------------------------------------------------------------

_UL:		ld	l, a
		ld	a, (bmode)	; Bios-Mode: 'U'-Arbeit	im Upper Bios, 00-Arbeit im Schatten-Bios
		or	a
		ld	a, l
		jp	z, uul
		shadow_oni
		call	uul
		shadow_offi
		ret

;-----------------------------------------------------------------------------
; PUN-Gertetreiber fr	PUNCH
;-----------------------------------------------------------------------------

_pun:		ld	l, a
		ld	a, (bmode)	; Bios-Mode: 'U'-Arbeit	im Upper Bios, 00-Arbeit im Schatten-Bios
		or	a
		ld	a, l
		jp	z, upunch
		shadow_oni
		call	upunch
		shadow_offi
		ret
