;-----------------------------------------------------------------------------
; CPA-Disk-Parameter
;-----------------------------------------------------------------------------

;Disk-Parameter-Header
dph0:		dw	0		; XLT	translation table
		dw	0
		dw	0
		dw	0
		dw	dirbuf		; DIRBUF
		dw	dpb0		; DPB
		dw	CSV0		; CSV
		dw	ALV0		; ALV

dph1:		dw	0		; XLT	translation table
		dw	0
		dw	0
		dw	0
		dw	dirbuf		; DIRBUF
		dw	dpb1  		; DPB
		dw	CSV1		; CSV
		dw	ALV1		; ALV

dphtab:		dw	dph0
		dw	dph1

;Disk-Parameter-Blcke
dpb0:		if lw1='S4'
;200K-Laufwerk: 40 Spuren SS, SD
		dw   40			; SPT	40 Sektoren/Spur
		db    3                 ; BSH	= log2(blocksize/128)
					;  => blocksize = (2^3)*128 = 1024
		db    00000111b         ; BLM	= 2^BSH-1
		db    0                 ; EXM
		dw 200-1                ; DSM	max. 200 Blcke
					;  => also 200*1024 = 200K disc
		dw  64-1                ; DRM	max 64 Dir. Eintrge
		db 11000000b            ; AL0	also 2 Blcke (64*32 / 1024)
		db    0                 ; AL1	fr DIR reservieren
		dw   16                 ; CKS	= (DRM+1)/4
		dw    0                 ; OFF	0 reservierte Spuren
;
		db      00000000b	; DPB-Steuerinformationen
					; bit 5=1 Double sided zu betreiben
		db    	3 		; Sektorlaengencode
		db    	7 		; Puffermaske 8*128
		db    	1 		; Zahl der Stepimpulse
		db    	0  		; keine Weiter-Numm. auf Rueckseite
		db  	40		; benutzte Zahl phys. Spuren
		db    	0		; phys. LW-Nr. (0 --> A:)
		db  	40		; Gesamtzahl physische Spuren (wird in FORMATZ abgefragt)
		db  	13*10		; Schrittzeit fuer 80 Tr. SS LW
		db  	00011000b	; vom Laufwerkstyp abhaengige Flags
					; bit 0=0 bei SS, =1 bei DS
					; bit 3=0 bei SD (FM), =1 bei DD (MFM)
					; bit 4=0 bei 8", =1 bei 5"
					; bit 5=0 bei nicht 80-Spur, =1 bei 80-Spur
					; bit 6=0 ohne, =1 mit Verify nach Schreiben
					; bit 7=0 bei max 26 ,=1 bei max 52 Sekt./Spur (8" MFM)
		elseif lw1='D4'
		dw	40		; SPT	40 Sektoren/Spur
		db 	4		; BSH	= log2(blocksize/128)
					;  => blocksize = (2^4)*128 = 2048
		db 	00001111b	; BLM	= 2^BSH-1
		db 	1		; EXM
		dw	190-1		; DSM	max. 400 Blcke
					;  => also 400*2048 = 800K disc
		dw	128-1		; DRM	max 192 Dir. Eintrge
		db 	11000000b	; AL0	also 3 Blcke (192*32 / 2048)
		db 	0		; AL1	fr DIR reservieren
		dw	32		; CKS	= (DRM+1)/4
		dw	4		; OFF	0 reservierte Spuren
;Erweiternung DBP des Z9001-CBIOS
		db  	00100000b 	; DPB-Steuerinformationen
					; bit 5=1 Double sided zu betreiben
		db    	3 		; Sektorlaengencode
		db    	7 		; Puffermaske 8*128
		db    	1 		; Zahl der Stepimpulse
		db    	0  		; keine Weiter-Numm. auf Rueckseite
		db  	40		; benutzte Zahl phys. Spuren
		db    	0  		; (dbp+15h) phys. LW-Nr. (0 --> A:)
		db  	40		; Gesamtzahl physische Spuren (wird in FORMATZ abgefragt)
		db	130		; Schrittzeit fuer 80 Tr. DS LW
		db	00011001b	; vom Laufwerkstyp abhaengige Flags
					; bit 0=0 bei SS, =1 bei DS
					; bit 3=0 bei SD (FM), =1 bei DD (MFM)
					; bit 4=0 bei 8", =1 bei 5"
					; bit 5=0 bei nicht 80-Spur, =1 bei 80-Spur
					; bit 6=0 ohne, =1 mit Verify nach Schreiben
					; bit 7=0 bei max 26 ,=1 bei max 52 Sekt./Spur (8" MFM)
		elseif	lw1='S8'		
		dw	40		; SPT	40 Sektoren/Spur
		db 	4		; BSH	= log2(blocksize/128)
					;  => blocksize = (2^4)*128 = 2048
		db 	00001111b	; BLM	= 2^BSH-1
		db 	1		; EXM
		dw	200-1		; DSM	max. 400 Blcke
					;  => also 400*2048 = 800K disc
		dw	128-1		; DRM	max 192 Dir. Eintrge
		db 	11000000b	; AL0	also 3 Blcke (192*32 / 2048)
		db 	0		; AL1	fr DIR reservieren
		dw	32		; CKS	= (DRM+1)/4
		dw	0		; OFF	0 reservierte Spuren
;Erweiternung DBP des Z9001-CBIOS
		db  	00000000b 	; DPB-Steuerinformationen
					; bit 5=1 Double sided zu betreiben
		db    	3 		; Sektorlaengencode
		db    	7 		; Puffermaske 8*128
		db    	1 		; Zahl der Stepimpulse
		db    	0  		; keine Weiter-Numm. auf Rueckseite
		db  	80		; benutzte Zahl phys. Spuren
		db    	0  		; (dbp+15h) phys. LW-Nr. (0 --> A:)
		db  	80		; Gesamtzahl physische Spuren (wird in FORMATZ abgefragt)
		db	130		; Schrittzeit fuer 80 Tr. DS LW
		db	00111000b	; vom Laufwerkstyp abhaengige Flags
					; bit 0=0 bei SS, =1 bei DS
					; bit 3=0 bei SD (FM), =1 bei DD (MFM)
					; bit 4=0 bei 8", =1 bei 5"
					; bit 5=0 bei nicht 80-Spur, =1 bei 80-Spur
					; bit 6=0 ohne, =1 mit Verify nach Schreiben
					; bit 7=0 bei max 26 ,=1 bei max 52 Sekt./Spur (8" MFM)

		elseif	lw1='D8'
;800K-Laufwerk 80 Spuren DS, DD
		dw	40		; SPT	40 Sektoren/Spur
		db 	4		; BSH	= log2(blocksize/128)
					;  => blocksize = (2^4)*128 = 2048
		db 	00001111b	; BLM	= 2^BSH-1
		db 	0		; EXM
		dw	400-1		; DSM	max. 400 Blcke
					;  => also 400*2048 = 800K disc
		dw	192-1		; DRM	max 192 Dir. Eintrge
		db 	11100000b	; AL0	also 3 Blcke (192*32 / 2048)
		db 	0		; AL1	fr DIR reservieren
		dw	48		; CKS	= (DRM+1)/4
		dw	0		; OFF	0 reservierte Spuren
;Erweiternung DBP des Z9001-CBIOS
		db  	00100000b 	; DPB-Steuerinformationen
					; bit 5=1 Double sided zu betreiben
		db    	3 		; Sektorlaengencode
		db    	7 		; Puffermaske 8*128
		db    	1 		; Zahl der Stepimpulse
		db    	0  		; keine Weiter-Numm. auf Rueckseite
		db  	80		; benutzte Zahl phys. Spuren
		db    	0  		; (dbp+15h) phys. LW-Nr. (0 --> A:)
		db  	80		; Gesamtzahl physische Spuren (wird in FORMATZ abgefragt)
		db	4*10		; Schrittzeit fuer 80 Tr. DS LW
		db	00111001b	; vom Laufwerkstyp abhaengige Flags
					; bit 0=0 bei SS, =1 bei DS
					; bit 3=0 bei SD (FM), =1 bei DD (MFM)
					; bit 4=0 bei 8", =1 bei 5"
					; bit 5=0 bei nicht 80-Spur, =1 bei 80-Spur
					; bit 6=0 ohne, =1 mit Verify nach Schreiben
					; bit 7=0 bei max 26 ,=1 bei max 52 Sekt./Spur (8" MFM)
		endif

;translation tab dbp0
		db	1,2,3,4,5,6,7,8,9,10,11,12,13,14
		db	15,16,17,18,19,20,21,22,23,24,25,26


dpb1:		if lw2='S4'
;200K-Laufwerk: 40 Spuren SS, SD
		dw   40			; SPT	40 Sektoren/Spur
		db    3                 ; BSH	= log2(blocksize/128)
					;  => blocksize = (2^3)*128 = 1024
		db    00000111b         ; BLM	= 2^BSH-1
		db    0                 ; EXM
		dw 200-1                ; DSM	max. 200 Blcke
					;  => also 200*1024 = 200K disc
		dw  64-1                ; DRM	max 64 Dir. Eintrge
		db 11000000b            ; AL0	also 2 Blcke (64*32 / 1024)
		db    0                 ; AL1	fr DIR reservieren
		dw   16                 ; CKS	= (DRM+1)/4
		dw    0                 ; OFF	0 reservierte Spuren
;
		db      00000000b	; DPB-Steuerinformationen
					; bit 5=1 Double sided zu betreiben
		db    	3 		; Sektorlaengencode
		db    	7 		; Puffermaske 8*128
		db    	1 		; Zahl der Stepimpulse
		db    	0  		; keine Weiter-Numm. auf Rueckseite
		db  	40		; benutzte Zahl phys. Spuren
		db    	1		; phys. LW-Nr. (0 --> A:)
		db  	40		; Gesamtzahl physische Spuren (wird in FORMATZ abgefragt)
		db  	13*10		; Schrittzeit fuer 80 Tr. SS LW
		db  	00011000b	; vom Laufwerkstyp abhaengige Flags
					; bit 0=0 bei SS, =1 bei DS
					; bit 3=0 bei SD (FM), =1 bei DD (MFM)
					; bit 4=0 bei 8", =1 bei 5"
					; bit 5=0 bei nicht 80-Spur, =1 bei 80-Spur
					; bit 6=0 ohne, =1 mit Verify nach Schreiben
					; bit 7=0 bei max 26 ,=1 bei max 52 Sekt./Spur (8" MFM)
		elseif lw2='D4'
		dw	40		; SPT	40 Sektoren/Spur
		db 	4		; BSH	= log2(blocksize/128)
					;  => blocksize = (2^4)*128 = 2048
		db 	00001111b	; BLM	= 2^BSH-1
		db 	1		; EXM
		dw	190-1		; DSM	max. 400 Blcke
					;  => also 400*2048 = 800K disc
		dw	128-1		; DRM	max 192 Dir. Eintrge
		db 	11000000b	; AL0	also 3 Blcke (192*32 / 2048)
		db 	0		; AL1	fr DIR reservieren
		dw	32		; CKS	= (DRM+1)/4
		dw	4		; OFF	0 reservierte Spuren
;Erweiternung DBP des Z9001-CBIOS
		db  	00100000b 	; DPB-Steuerinformationen
					; bit 5=1 Double sided zu betreiben
		db    	3 		; Sektorlaengencode
		db    	7 		; Puffermaske 8*128
		db    	1 		; Zahl der Stepimpulse
		db    	0  		; keine Weiter-Numm. auf Rueckseite
		db  	40		; benutzte Zahl phys. Spuren
		db    	1  		; (dbp+15h) phys. LW-Nr. (0 --> A:)
		db  	40		; Gesamtzahl physische Spuren (wird in FORMATZ abgefragt)
		db	130		; Schrittzeit fuer 80 Tr. DS LW
		db	00011001b	; vom Laufwerkstyp abhaengige Flags
					; bit 0=0 bei SS, =1 bei DS
					; bit 3=0 bei SD (FM), =1 bei DD (MFM)
					; bit 4=0 bei 8", =1 bei 5"
					; bit 5=0 bei nicht 80-Spur, =1 bei 80-Spur
					; bit 6=0 ohne, =1 mit Verify nach Schreiben
					; bit 7=0 bei max 26 ,=1 bei max 52 Sekt./Spur (8" MFM)
		elseif	lw2='S8'		
		dw	40		; SPT	40 Sektoren/Spur
		db 	4		; BSH	= log2(blocksize/128)
					;  => blocksize = (2^4)*128 = 2048
		db 	00001111b	; BLM	= 2^BSH-1
		db 	1		; EXM
		dw	200-1		; DSM	max. 400 Blcke
					;  => also 400*2048 = 800K disc
		dw	128-1		; DRM	max 192 Dir. Eintrge
		db 	11000000b	; AL0	also 3 Blcke (192*32 / 2048)
		db 	0		; AL1	fr DIR reservieren
		dw	32		; CKS	= (DRM+1)/4
		dw	0		; OFF	0 reservierte Spuren
;Erweiternung DBP des Z9001-CBIOS
		db  	00000000b 	; DPB-Steuerinformationen
					; bit 5=1 Double sided zu betreiben
		db    	3 		; Sektorlaengencode
		db    	7 		; Puffermaske 8*128
		db    	1 		; Zahl der Stepimpulse
		db    	0  		; keine Weiter-Numm. auf Rueckseite
		db  	80		; benutzte Zahl phys. Spuren
		db    	1  		; (dbp+15h) phys. LW-Nr. (0 --> A:)
		db  	80		; Gesamtzahl physische Spuren (wird in FORMATZ abgefragt)
		db	130		; Schrittzeit fuer 80 Tr. DS LW
		db	00111000b	; vom Laufwerkstyp abhaengige Flags
					; bit 0=0 bei SS, =1 bei DS
					; bit 3=0 bei SD (FM), =1 bei DD (MFM)
					; bit 4=0 bei 8", =1 bei 5"
					; bit 5=0 bei nicht 80-Spur, =1 bei 80-Spur
					; bit 6=0 ohne, =1 mit Verify nach Schreiben
					; bit 7=0 bei max 26 ,=1 bei max 52 Sekt./Spur (8" MFM)

		elseif	lw2='D8'
;800K-Laufwerk 80 Spuren DS, DD
		dw	40		; SPT	40 Sektoren/Spur
		db 	4		; BSH	= log2(blocksize/128)
					;  => blocksize = (2^4)*128 = 2048
		db 	00001111b	; BLM	= 2^BSH-1
		db 	0		; EXM
		dw	400-1		; DSM	max. 400 Blcke
					;  => also 400*2048 = 800K disc
		dw	192-1		; DRM	max 192 Dir. Eintrge
		db 	11100000b	; AL0	also 3 Blcke (192*32 / 2048)
		db 	0		; AL1	fr DIR reservieren
		dw	48		; CKS	= (DRM+1)/4
		dw	0		; OFF	0 reservierte Spuren
;Erweiternung DBP des Z9001-CBIOS
		db  	00100000b 	; DPB-Steuerinformationen
					; bit 5=1 Double sided zu betreiben
		db    	3 		; Sektorlaengencode
		db    	7 		; Puffermaske 8*128
		db    	1 		; Zahl der Stepimpulse
		db    	0  		; keine Weiter-Numm. auf Rueckseite
		db  	80		; benutzte Zahl phys. Spuren
		db    	1  		; (dbp+15h) phys. LW-Nr. (0 --> A:)
		db  	80		; Gesamtzahl physische Spuren (wird in FORMATZ abgefragt)
		db	4*10		; Schrittzeit fuer 80 Tr. DS LW
		db	00111001b	; vom Laufwerkstyp abhaengige Flags
					; bit 0=0 bei SS, =1 bei DS
					; bit 3=0 bei SD (FM), =1 bei DD (MFM)
					; bit 4=0 bei 8", =1 bei 5"
					; bit 5=0 bei nicht 80-Spur, =1 bei 80-Spur
					; bit 6=0 ohne, =1 mit Verify nach Schreiben
					; bit 7=0 bei max 26 ,=1 bei max 52 Sekt./Spur (8" MFM)
		endif

; translation tab dbp1
		db	1,2,3,4,5,6,7,8,9,10,11,12,13,14
		db	15,16,17,18,19,20,21,22,23,24,25,26

ubiosend:	equ	$
romend:		equ	$-ubios+memubios

;-----------------------------------------------------------------------------
; BIOS-RAM
;-----------------------------------------------------------------------------

stackp:		dw	?		; Zwischenspeicher Stackpointer
ddma:		dw	?		; aktuelle DMA-Adresse
dirbuf:		db	128 dup (?)	; Bereich 128 Byte

; max. Werte f. autom. Formaterkennung
		if lw1='S4'
ALV0:		db	25 dup (?)	;max mgliches DSM/8+1
CSV0:		db	16 dup (?)	;max mgliches CKS
		elseif lw1='D4'
ALV0:		db	50 dup (?)	;max mgliches DSM/8+1
CSV0:		db	32 dup (?)	;max mgliches CKS
		elseif lw1='S8'
ALV0:		db	25 dup (?)	;max mgliches DSM/8+1
CSV0:		db	32 dup (?)	;max mgliches CKS
		elseif lw1='D8'
ALV0:		db	50 dup (?)	;max mgliches DSM/8+1
CSV0:		db	64 dup (?)	;max mgliches CKS
		endif

		if lw2='S4'
ALV1:		db	25 dup (?)	;max mgliches DSM/8+1
CSV1:		db	16 dup (?)	;max mgliches CKS
		elseif lw2='D4'
ALV1:		db	50 dup (?)	;max mgliches DSM/8+1
CSV1:		db	32 dup (?)	;max mgliches CKS
		elseif lw2='S8'
ALV1:		db	25 dup (?)	;max mgliches DSM/8+1
CSV1:		db	32 dup (?)	;max mgliches CKS
		elseif lw2='D8'
ALV1:		db	50 dup (?)	;max mgliches DSM/8+1
CSV1:		db	64 dup (?)	;max mgliches CKS
		endif


rwbuffer:	db	80h dup (?)	;128 Byte Buffer fr _read/_write
