;-----------------------------------------------------------------------------
; Z9001-BIOS fr CPA, 1989 Dr. Schwarzenberg
; reass 2004/2006 Volker Pohlers. Modulare Neufassung 2025
;
; Das Bios ist recht umfangreich und umfasst Gertetreiber fr ...
; und fr 2 Floppylaufwerke 200k..800K, die am Robotron/Rossendorf-Floppy-Modul
; angeschlossen sind. Desweiteren wird unbedingt ein spezielles 64K-RAM-Modul
; bentigt, da das Bios den 2. Speicherbereich 4000H-7FFFH fr sich benutzt.
;
; Speicherbelegung (CCP auf cc00)
;
; 4000-7FFF 	(2. Bank) Shadow Bios
;	4000-55FF CCP+BDOS-Kopie,
;	5600..Start-1 SBIOS,
;	danach IO-Buffer fr FDC
; cc00-d3ff	CPA-CCP
; d400-e1ff	BDOS
; e200-e7ff	Upper BIOS + BIOS RAM
;
; Ablauf des CPM-Starts
;
; 1. vom Boot-Loader wird @cpmz9 (init+ccp+bdos+sbios+binit+ubios) nach 8000h geladen
;    und auf 8000H+1600H = 9600H gestartet. Das ist die initiale Adr. von SBIOS,
;    deshalb steht hier ein JP 9FF0h
; 2. init transportiert ccp+bdos+sbios+binit+ubios nach 4000h in die 2. Speicherbank
; 3. binit wird nach 180h geladen, ubios nach e200h geladen.
; 3. binit wird gestartet und initialisiert die Gertetreiber, testet den Speicher,
;    gibt die Startmeldung aus, kopiert einen Startbefehl in den CCP-Befehlspuffer
;    und springt zu WBOOT im Shadow Bios.
; 4. wboot kopiert CCP, (damit wird in cpmz9ok obiger Startbefehl wieder berschrieben...)
;    initialisiert CPA-RAM 0000h ff. und startet schlussendlich den CCP.
; 5. der Speicher ab Start=fdcbuffer in Shadow-Ram wird als IO-Buffer der FDC-Operationen genutzt,
;    die Teile binit und ubios werden also im Shadow-Ram berschrieben
;
; Verbindung zum OS
;
; das ganze Bios ist recht stark mit dem Z9001-OS verknpft (Gertetreiber und
; Gertetreiberverwaltung).
;
; s. auch 00cpm.txt, KCCPM.TXT, README.TXT
;-----------------------------------------------------------------------------

		cpu	z80
		page	0

		title	"CPMZ9 BIOS"

;-----------------------------------------------------------------------------
; Konfiguration
; CPMSD8
; Unterschied zum Original: im Orig.Loader steht flschlich Port 68h statt 05h
;-----------------------------------------------------------------------------

; FDC-U8272-Modul (Rossendorf, Robotron)
; Untersxchiedlichen Hardware fr TC, unterschiedliche Ports
FDCPORTS	EQU 	'ROSSENDORF'	; 'ROSSENDORF' - Ports 10h, 11h, 12h
					; 'ROBOTRON' - Ports 98h, 99h, 0A0h
;

; SCP-Kennnung
; 5 Zeichen, nach BIOS-Einsprungtabelle
; wird genutzt, um System zu identifizieren (analog zu SCP und CP/A)
scpcod		equ	'CPM9Z'		; Standard 'CPM9Z'

; Codeerzeugung Sonderzeichen via List-Taste
lstcod		equ	0		; 0 - Version 1 (List+s)
					; 1 - Version 2 (neuer, List+=)

; Codeerzeugung seldsk
selcod		equ	0		; 0 - Version 1 (lter)
					; 1 - Version 2 (neuer)

ptsetdma	equ	1		; vgl. a. CPMZ9_v1.asm

; erweiterte Initialisierung (binit)
inicod		equ	0		; 0 - Version 1 (neuer)
					; 1 - Version 2 (lter)

; Gertetreiber f. Schreibmaschine S6010
S6010		equ	0		; 0 - keine I/O-Treiber f. S6010
					; 1 - I/O-Treiber fr S6010

; Laufwerkstypen
lw1		equ	'D8'		; Laufwerkstyp S - Singe-Side/D - Double-Side
lw2		equ	'D8'		; 4 - 40/8 - 80-Spuren, also S4, D4, S8, D8

; Schrittratenzeit, Kopfladezeit
stab1		equ  	11101111b	; XXXX=Schrittratenzeit SRT,XXXX= Kopfladezeit HUT
stab2		equ	11111111b	; XXXXXXX=Kopfladezeit HLT,X=no dma ND

; Startadresse CCP
CCP		equ	0CC00h		; base of ccp

; CCP-Version
ccpcod		equ	0		; 0 - Version 1 (ccp1, neuer)
					; 1 - Version 2 (ccp1r, lter)

; Startkommando
; wird bei Kaltstart vom CCP ausgefhrt (geht nur bei inicod=0)
cldkdo		equ	'CLOCK'		; Default Rossendorf: 'CLOCK'

; geschaltetes System (Zusatz-RAM 4000-7FFF)
shadow16k	equ	1		; 0 - kein geschaltetes System (TODO)
					; 1 - extra RAM

; Copyrightschutztest, s. a. copyprot
cpprot		equ	1		; 0 - kein Copyright-Schutz
					; 1 - Copyrightschutz

; freier Speicherplatz nach biosfdc.inc (wofr???)
; hier als Parameter zur Erzeugung binrcompatibler Versionen
fdcspace	equ	1		; 0 - keine freien Bytes nach biosfdc
					; 1 - 42 freie Bytes  nach biosfdc

; Versionsdatum fr Init-Meldung
reldate		equ	'06.02.89'

;-----------------------------------------------------------------------------

SHADOWRAM	equ	4000H		; Adresse Shadow-Memory fr CCP-Kopie und shadow bios
LOADADRESS	equ	8000H		; Hierhin wird das Programm durch den Loader geladen


;Ports

		if shadow16k=1
;Version von U.- Zander
;rambank_wo	equ	71h	; RAM-Modul U. Zander, toggle w/o <-> r/w
;				; ebenso Lesen von 0F800h (BOOT-Modul zuschalten)
;rambank1        equ	72h  	; ShadowRAM deaktivieren; 	vp 04h
;rambank2        equ	73h  	; ShadowRAM aktivieren;		vp 05h


; die Version von U.- Zander war ursprnglich fr andere Port-Adressen des 64K-RAM
; mittlerweile (2008) verwendet U. Zander auch die originalen robotron-Adressen
rambank1        equ	04h  	; ShadowRAM deaktivieren
rambank2        equ	05h  	; ShadowRAM aktivieren
rambank_wo	equ	06h	; RAM-Modul write/only
		endif

CTC0		equ	80h	; System CTC0
CTC1		equ	81h	; System CTC1
CTC3		equ	83h	; System CTC3

PIO1AD		equ	88h	; System PIO1AD
PIO1BD		equ	89h	; System PIO1BD	Anwenderport
PIO1BC		equ	8bh	; System PIO1BC Anwenderport

;-----------------------------------------------------------------------------

		include	biosnuc.inc

		end
