;**************************************************************
;	zeichenorientierte Geraete
;**************************************************************

;-----------------------------------------------------------------------------
; PUN-Gertetreiber fr	PUNCH
; Z9001-System-Gertetreiber
; Ausgabe Zeichen auf Console als "(xx)" (Hexzahl)
;-----------------------------------------------------------------------------

upunch:		ld	a, c
		ld	de, upunch1+1
		call	hexa		; A nach hex konvertieren, Eintragen nach (DE),	2x inc DE
		ld	c, '('
		call	_conout		; _conout im upper Bios
upunch1:	ld	bc, 0		; Wert wird durch hexa gepatcht
		push	bc
		call	_conout		; _conout im upper Bios
		pop	bc
		ld	c, b
		call	_conout		; _conout im upper Bios
		ld	c, ')'
		jp	_conout		; _conout im upper Bios


; Hilfsprogramm, genutzt in UL-, und CRT-Treiber
stopkey:	call	0FD33h		; Z9001-OS DECO0: Abfrage Tastaturmatrix
		ei
		sub	3		; STOP-Taste ?
		or	a
		ret	nz
		ld	(25h), a	; Tastaturbuffer
		scf
		ret

;-----------------------------------------------------------------------------
; TTY-Treiber fr CONS
; Z9001-System-Gertetreiber
; Beep + Gross<=>Klein-Wandlung
;-----------------------------------------------------------------------------

uttyc:		cp	1		; Kommandocode 'Eingabe Zeichen' ?
uttyc1:		scf			; nein, dann alle anderen Kommandocodes vom OS bearbeiten
		ccf
		jp	nz, 0F8F1h	; Z9001-OS CRT:	Steuerprogramm des CRT-Treibers

; Kommandocode 'Eingabe Zeichen'
uttyc2:		call	0F8F1h		; Z9001-OS CRT:	Steuerprogramm des CRT-Treibers
		call	bell
		ld	hl, lstflag

		IF lstcod=0

		cp	1Ch		; LIST-Taste
		jr	nz, uttyc3
		ld	a, 1
		ld	(hl), a		; LIST merken in lstflag
		jr	uttyc2
uttyc3:		bit	0, (hl)		; listflag gesetzt?
		jr	z, uttyc4
		ld	(hl), 0		; listflag rcksetzen

		ELSE

		bit	0, (hl)		; listflag gesetzt?
		jr	nz, uttyc10	; ja
		cp	1Ch		; jetzt LIST-Taste gedrckt?
		jr	nz, uttyc10	; nein
		ld	a, 1		; LIST merken in lstflag
		ld	(hl), a
		jr	uttyc		; und nchstes Zeichen holen

uttyc10:	bit	0, (hl)		; listflag gesetzt?
		jr	z, uttyc4	; nein -> weiter mit Gro<->Klein
		ld	(hl), 0		; listflag rcksetzen
		cp	1Ch		; nochmal LIST-Taste?
		ret	z		; das ignorieren
		cp	'P'		; 'P' ?
		jr	nz, uttyc12
; LIST+P Hardcopy ein/aus
		ld	a, (15h)	; LISW Schalter fr Hardcopy. 0 kein Copy, 1 Copy
		xor	1
		ld	(15h), a	; LISW Schalter fr Hardcopy. 0 kein Copy, 1 Copy
uttyc11:	ld	a, 1
		jr	uttyc

uttyc12:	cp	'N'
		jr	nz, uttyc18
; LIST+N Bildschirmkopie
		push	de
		ld	hl, 0EC00h	; Adr. Bildwiederholspeicher
		in	a, (PIO1AD)
		bit	2, a		; 20-Zeilen-Modus?
		ld	a, 20		; Anz. Zeilen
		jr	nz, uttyc13
		add	a, 4		; sonst +4
uttyc13:	ld	d, a
uttyc14:	ld	e, 40		; Anzahl Spalten
;
uttyc15:	ld	c, (hl)
		push	de
		push	hl
		call	0F00Fh		; Z9001-OS: list
		pop	hl
		pop	de
		jr	c, uttyc17
		inc	hl
		dec	e
		jr	nz, uttyc15
		push	hl
		push	de
		ld	c, 0Dh		; CR
		call	0F00Fh		; Z9001-OS: list
		jr	c, uttyc16
		ld	c, 0Ah		; LF
		call	0F00Fh		; Z9001-OS: list
uttyc16:	pop	de
		pop	hl
		jr	c, uttyc17
		dec	d
		jr	nz, uttyc14
uttyc17:	pop	de
		jr	uttyc11
; Ende
uttyc18:	equ	$

		ENDIF

; Sondertaste? vorher wurde LIST gedrckt
		ld	hl, lsttab	; Tabelle Extrazeichen (LIST+char)
		ld	bc, lsttabe-lsttab
		cpir			; suche	Sondertaste
		jr	nz, uttyc4
		ld	bc, lsttabe-lsttab-1
		add	hl, bc
		ld	a, (hl)		; Sonderzeichen	holen

; Zeichenkonvertierung Gro<->Klein
uttyc4:		ld	hl, uttyc6	; Returnadresse
		push	hl
		cp	'A'
		jr	c, uttyc5
		cp	'Z'+1
		jr	nc, uttyc5
		or	20h
		ret
uttyc5:		cp	'a'
		ret	c
		cp	'z'+1
		ret	nc
		sub	20h
		ret
uttyc6:		or	a
		ret

;
lstflag:	db	0		; wenn vorher LIST gedrckt, dann steht hier 1 bzw. 1Ch

;
lsttab:		db	'8'		; Tabelle Extrazeichen (LIST+char)
		db	'9'
		db	','
		db	'.'
		db	'I'
		db	'?'
		IF lstcod=0
		db	's'
		ELSE
		db	'='
		ENDIF
lsttabe:
;
		db	'['
		db	']'
		db	'{'
		db	'}'
		db	'|'
		db	5Ch		; '\'
		db	'~'

;-----------------------------------------------------------------------------
; CRT-Treiber fr CONS
; Z9001-System-Gertetreiber
; nur  Tastatur-Beep
;-----------------------------------------------------------------------------

ucrtc:		cp	1		; Kommandocode 'Eingabe Zeichen' ?
		IF lstcod=0
		jr	nz, uttyc1	; nein, dann alle anderen Kommandocodes vom OS bearbeiten
		ELSE
		jp	nz, uttyc1
		ENDIF
		call	0F8F1h		; Z9001-OS CRT:	Steuerprogramm des CRT-Treibers
;
; Tastaturbeep
bell:		di
		push	af
		push	bc
		ld	b, 0
		ld	c, 14h
		ld	a, 00000111b	; Interrupt aus, Zeitgeber Mode, Vorteiler 16, negative	Flanke,
					; Start	sofort,	Konstante folgt, Kanal Reset
		out	(CTC0), a	; CTC0
		ld	a, 96h		; Zeitkonstante
		out	(CTC0), a
		in	a, (PIO1AD)
		set	7, a
		out	(PIO1AD), a	; Lautsprecher an
bell1:		djnz	bell1
		dec	c
		jr	nz, bell1
		res	7, a
		out	(PIO1AD), a	; Lautsprecher aus
		ld	a, 00000011b
		out	(CTC0), a	; CTC0 Reset
		pop	bc
		pop	af
		ei
		ret


;-----------------------------------------------------------------------------
; Treiber f. Schreibmaschine SM6010
	if S6010=1
		include	bios6010.inc
	endif	
;-----------------------------------------------------------------------------



;-----------------------------------------------------------------------------
; UP2 Gertreiber fr PUNCH
; Z9001-System-Gertetreiber
; V24-User-Port 9600 Bd
; User-Pio, Bit7 (in) DTR Drucker bereit? 1=kein Senden. Bit 0 (out) serielle Daten
; s.a. mp 10/87, S. 311 ff.
;-----------------------------------------------------------------------------

uup:		push	af		; Kommandocode merken
		ld	a, 12		; Zeitconstante TC fr 9600 baud
		jr	ucrtl1

;-----------------------------------------------------------------------------
; CRT-Gertetreiber fr	LIST
; Z9001-System-Gertetreiber
; V24-User-Port 1200 Bd
; User-Pio, Bit7 (in) DTR Drucker bereit? 1=kein Senden. Bit 0 (out) serielle Daten
; s.a. mp 10/87, S. 311 ff.
;-----------------------------------------------------------------------------

ucrtl:		push	af		; Kommandocode merken
		ld	a, 126		; Zeitconstante TC fr 1200 baud
ucrtl1:		ld	(ucrtl4+1), a
		ld	a, 11001111b
		out	(PIO1BC), a	; PIO1B	init Bitmode
		ld	a, 10000000b
		out	(PIO1BC), a	; Bit7 Eingabe,	Bit6-Bit0 Ausgabe
;
		pop	af		; Kommandocode
		inc	a		; FF? (Initialisieren)
		ret	z		; dann fertig
		dec	a		; 0?  (Abfrage Status)
		jr	nz, ucrtl2	; nein
;
		in	a, (PIO1BD)	; PIO1B	lesen
		or	7Fh		; Bit 7=0
		cpl
		ret
; Zeichenausgabe
ucrtl2:		call	stopkey
		jr	nc, ucrtl3	; Sprung, wenn STOP-Taste nicht	gedrckt
		ld	(15h), a	; LISW,	Schalter fr Hardcopy
		ret
;
ucrtl3:		in	a, (PIO1BD)	; PIO1B	lesen
		add	a, a		; Drucker bereit?
		jr	c, ucrtl2	; warten, solange Bit7 gesetzt
		ld	a, c		; Zeichen nach A
		cp	7Fh
		jr	nz, ucrtl4
		ld	a, 1Bh
ucrtl4:		ld	e, 126		; Zeitkonstante, Wert wird verndert (ucrtl1)
		ld	b, 9		; 1 Startbit + 8 Datenbits
		di
		or	a		; Cy=0
		rla			; Start-Bit
ucrtl5:		out	(PIO1BD), a	; Bit ausgeben, PIO1B schreiben
		call	ucrtl6		; kurze	Pause, Zeitwert	in E
		rra			; nchstes Bit
		djnz	ucrtl5
		or	1		; Stopbit
		out	(PIO1BD), a	; PIO1B	schreiben
		ei
; Bit-Wartezeit, kurze Pause, Zeitwert in E
ucrtl6:		push	de
ucrtl7:		dec	e
		jr	nz, ucrtl7
		pop	de
		ret

;
_0_572Fh:	db	0		; Unklar, ungenutzt, CP/A-Reste???? s. binit6

;-----------------------------------------------------------------------------
; UL Gertetreiber fr LIST
; Z9001-System-Gertetreiber
; Centronics User-Port
; s.a. mp 10/87, S. 311 ff.
; 7 Datenbits verfueghar, PIO bit7 wird zur Bildung des Centronics-/STR0BE-Signals verwendet.
; /ACKNLG vom Drucker wird ueber den CTC-Kanal erfasst.
;-----------------------------------------------------------------------------

uul:		inc	a		; Kommandocode FF (Initialisieren)?
		ret	z		; ja
		dec	a		; Kommandocode 0?  (Abfrage Status)
		cpl
		ret	z		; ja
;
		ld	a, 11001111b
		out	(PIO1BC), a	; Bit-Mode
		xor	a		; alles Ausgabe
		out	(PIO1BC), a
		ld	a, 01010111b	; Zhler, pos. Flanke
		out	(CTC1), a	; Init. CTC
		out	(CTC1), a
;
		ld	a, c		; Zeichen
		or	80h		; /Strobe = high
		cp	0FFh		; Zeichen 7F->1Bh
		jr	nz, uul1
		ld	a, 9Bh
uul1:		out	(PIO1BD), a	; Zeichen ausgeben
		push	ix		; kurze Wartezeit
		pop	ix
		and	7Fh		; /Strobe = low
		out	(PIO1BD), a
		or	80h		; /Strobe = high
		out	(PIO1BD), a
uul2:		call	stopkey		; STOP-Taste?
		ret	c
		in	a, (CTC1)
		cp	57h		; /ACKNLG?
		jr	z, uul2		; nein, warten
		xor	a
		ret
