; Die S6010 wird vermutlich ber ein normales V24-Modul mit anderen Adressen
; angeschlossen und dient als Tastatur und Drucker

SIODA		equ	20h		; SIODA SIO-Kanal Daten
SIOKD		equ	22h		; SIOKD SIO-Kanal Kommandos
CTC		equ	24h		; Adr CTC Kanal 0

;-----------------------------------------------------------------------------
; SBIOS S6010-Treiber f. PUNCH
;-----------------------------------------------------------------------------

UP6010:		or	a
		jr	nz, UP6010_1
		in	a, (SIOKD)
		and	4
		ret
;
UP6010_1:	dec	a
		dec	a
		scf
		ret	nz
;
UP6010_2:	in	a, (SIOKD)
		bit	2, a		; Sender Puffer leer ?
		jr	nz, UP6010_3
		call	stopkey
		ret	c
		jr	UP6010_2
;
UP6010_3:	ld	a, (UR6010_b1)
		cp	1
		jr	nz, UP6010_4
		set	7, c
UP6010_4:	ld	a, c
		cp	2
		jr	nz, UP6010_5
		ld	a, 8
UP6010_5:	cp	1
		ld	(UR6010_b1), a
		ret	z
		cp	7Fh
		jr	nz, UP6010_6
		ld	a, 1Bh
UP6010_6:	out	(SIODA), a
		ld	hl, 1F00h
;
UP6010_7:	dec	hl
		ld	a, h
		or	l
		jr	nz, UP6010_7
		or	a
		ret

;-----------------------------------------------------------------------------
; SBIOS S6010-Treiber f. READER
;-----------------------------------------------------------------------------

UR6010:		or	a
		jr	nz, UR6010_1
		call	UR6010_u1
		ld	hl, 12Ch	; ???
		call	UP6010_7
		call	UR6010_u2
		in	a, (SIOKD)
		and	1		; Zeichen im Empfngerpuffer ?
		ret

UR6010_1:	dec	a
		scf
		ret	nz

		ld	hl, UR6010_b2
		xor	a
		cp	(hl)
		jr	z, UR6010_2
		ld	a, (hl)
		ld	(hl), 0
		or	a
		ret

UR6010_2:	call	UR6010_u1
UR6010_3:	in	a, (SIOKD)
		rrca
		jr	c, UR6010_4
		call	stopkey
		ld	a, 1Ah
		jr	c, UR6010_8
		jr	UR6010_3
UR6010_4:	ld	a, 1
		out	(SIOKD), a
		in	a, (SIOKD)
		and	70h
		jr	z, UR6010_5
		ld	a, 30h
		out	(SIOKD), a
		scf
		ret

UR6010_5:	call	UR6010_u2
		in	a, (SIODA)
		cp	0Ah
		jr	z, UR6010_2
		cp	1Bh
		jr	nz, UR6010_6
		ld	a, 7Fh
		jr	UR6010_8
UR6010_6:	cp	80h
		jr	c, UR6010_8
		ld	hl, UR6010_tab
		ld	bc, 3
		cpir
		jr	nz, UR6010_7
		ld	bc, 2
		add	hl, bc
		ld	a, (hl)
		jr	UR6010_8
UR6010_7:	ld	hl, UR6010_b2
		ld	(hl), a
		ld	a, 1
UR6010_8:	or	a
		ret

UR6010_tab:	db  8Ah
		db  82h
		db  87h
;
		db    3
		db  1Ah
		db  1Bh
;
UR6010_u1:	ld	a, 15h
		out	(SIOKD), a
		ld	a, 0EAh
		out	(SIOKD), a
		ret
;
UR6010_u2:	ld	a, 5
		out	(SIOKD), a
		ld	a, 0E8h
		out	(SIOKD), a
		ret

UR6010_b1:	db 	0
UR6010_b2:	db	0

