; File Name   :	d:\hobby3\ac1-2010\hrcpm12\checkcpm\Check+CPM-Umgebung_2000_25FF_2000.BIN
; Base Address:	0000h Range: 2000h - 25A5h Loaded length: 05A5h

		cpu	z80undoc

		include	ac1-2010.asm

		org 2000h

;------------------------------------------------------------------------------
; Umschaltport + auszugebende Werte fr Umschaltung AC1<->CPM
;------------------------------------------------------------------------------

port_scch:	db  14h			; Umschaltport ACC
cpm_scch:	db 4			; CP/M-Mode Bit2
ac1_scch:	db    0			; AC1-Mode
port_fa:	db  1Eh			; Umschaltport FA
cpm_fa:		db 1			; CP/M-Mode Bit0
ac1_fa:		db    0			; AC1-Mode

;------------------------------------------------------------------------------
; Testtabelle
; je Test Testnr, Testcode, 2 Adressen
; die Adressen werden nach HL, BC geladen
; beim Direktstart eines einzelnen Tests knnen diese Adressen in der 
; Kommandozeile berschrieben werden
;------------------------------------------------------------------------------

testtab:	
; Umschaltung AC1<->CPM Mod
		db    1			; test nr
		dw testumsch		; Testprogramm
		dw 0, 0			; aadr, eadr
; Check	CPM-RAM
		db    2
		dw cpm_ram_an
		dw 0, 0
;
		db    3
		dw cpm_ram_an
		dw 800h, 800h
;
		db    4
		dw cpm_ram_an
		dw 1000h, 1000h
;
		db    5
		dw cpm_ram_an		
		dw 1800H, 1800H
; Schreiben/Lesen AC1<->CPM
		db    6
		dw rdwrA
		dw 0,  0
;
		db    7
		dw rdwrA
		dw 800h, 800h
;
		db    8
		dw rdwrA
		dw 1000h, 1000h
;
		db    9
		dw rdwrA
		dw 1FFFh, 0
; Schreiben/Lesen AC1<->CPM
		db  0Ah
		dw rdwrB
		dw 1000h, 1FFFh
; Durchschreiben  AC1-->CPM
		db  0Bh
		dw wr_through		
		dw 0, 0FFFh
; Trennung RAM
		db  0Ch
		dw trennung		
		dw 1000h, 1FFFh
; Check	AC1-RAM
		db  0Dh
		dw ac1_ram_ab		
		dw 1000h, 0FFFFh
; Check	CPM-RAM
		db  0Eh
		dw cpm_ram_ab		
		dw 0, 0FFFFh


;------------------------------------------------------------------------------
; Start	mit 't'
;------------------------------------------------------------------------------

aT:		db 0,9,'t',0Dh


;------------------------------------------------------------------------------
; Hauptprogramm
;------------------------------------------------------------------------------

check:		ld	sp, 2600h
		ld	d, 0Eh		; letzte TestNr.
		inc	d
		ld	a, (ARG1)	; ARG1; Kdo-Argument 1
		ld	e, a
		or	a
		jp	nz, single	; Einzeltest
; alles testen
		; Ausgabe Titel
		rst	prnst		; Ausgabe String
		db 0Ch,"Check CPM-Umgebung SCCH(14H) & FA-Modus",0A8h
		ld	a, (port_fa)	; Umschaltport FA
		call	OUTHEX		; Ausgabe A hexadezimal
		rst	prnst		; Ausgabe String
		db "H)",0Fh,"HR 30.03.11",0Dh,0Dh
		db "Start mit: t <CR> startet alle Test's nacheinander",0Dh
		db 0Fh,"   t TestNr. AADR EADR <CR> fuer Einzeltest's",0Dh,0Dh
		db "Nach Test 01 sind auf Adr.2600H je 13Byte AC1 CPM-RAM 0H & 1800H",0Dh,8Dh
		;
		ld	a, 1		; Start	mit 1. Test
check1:		push	de
		push	af
		ld	de, 7		; Lnge	Test-Record
		ld	b, a
		ld	ix, testtab-7
check2:		add	ix, de
		djnz	check2		; ix=Pos. in Testtab
		ld	de, check5	; Returnadr.
		push	de		; auf Stack
		ld	e, (ix+1)	; de=Testcode
		ld	d, (ix+2)
		ld	hl, (ARG2)	; ARG2; Kdo-Argument 2
		ld	a, h
		or	l
		jr	nz, check3
		ld	l, (ix+3)	; hl=aadr oder ARG2
		ld	h, (ix+4)
check3:		ld	bc, (ARG3)	; ARG3; Kdo-Argument 3
		ld	a, b
		or	c
		jr	nz, check4
		ld	c, (ix+5)	; bc=eadr oder ARG3
		ld	b, (ix+6)
check4:		ld	a, (ix+0)
		push	de
		ret
check5:		pop	af
		pop	de
		inc	a		; erhoehe TestNr.
		cp	d		; vgl. mit letzter Test?
		jr	nz, check1	; nein
check6:		call	ac1mode		; AC1-Modus
		jp	GETCO1		; GETCO1; Sprung zur Monitoreingabeschleife

;Einzeltest
single:		ld	a, e		; A=TestNr.
		cp	d
		jr	nc, check6
		ld	d, a
		inc	d		; letzte TestNr. = Test+1
		jr	check1

;------------------------------------------------------------------------------
; Test01 Umschaltung AC1<->CPM Mode je 13Byte RAM	ab Adr.#2600H
;------------------------------------------------------------------------------

testumsch:	rst	prnst		 ; Ausgabe String
		db "Test01 Umschaltung AC1<->CPM Mod",0E5h
		; auf 2600h AC1 ablegen
		ld	hl, 0
		ld	de, 2600h
		ex	de, hl
		ld	(hl), 'A'
		inc	hl
		ld	(hl), 'C'
		inc	hl
		ld	(hl), '1'
		inc	hl
		ex	de, hl
		ld	bc, 0Dh
		ldir
		call	cpmmode		; CP/M-Modus
		ld	hl, 0
		ld	(hl), 'C'
		inc	hl
		ld	(hl), 'P'
		inc	hl
		ld	(hl), 'M'
		ld	hl, 0
		ld	bc, 10h
		ldir
		ld	hl, 0
		ld	de, 1000h
		ld	bc, 10h
		ldir
		call	ac1mode		; AC1-Modus
		ld	hl, 1800h
		ld	de, 2620h
		ex	de, hl
		ld	(hl), 'A'
		inc	hl
		ld	(hl), 'C'
		inc	hl
		ld	(hl), '1'
		inc	hl
		ex	de, hl
		ld	bc, 0Dh
		ldir
		call	cpmmode		; CP/M-Modus
		ld	hl, 1800h
		ld	(hl), 'C'
		inc	hl
		ld	(hl), 'P'
		inc	hl
		ld	(hl), 'M'
		inc	hl
		ld	hl, 1800h
		ld	bc, 10h
		ldir
		ld	hl, 1000h
		ld	bc, 10h
		ldir
		call	ac1mode		; AC1-Modus
		rst	prnst		; Ausgabe String
		db " je 13Byte RAM ab Adr.#2600", 0C8h
		call	o_ok		; Ausgabe "OK"
		ret

;------------------------------------------------------------------------------
; Test02 Check CPM-RAM an Adresse: 0000H =00
; Test03 Check CPM-RAM an Adresse: 0800H =00
; Test04 Check CPM-RAM an Adresse: 1000H =00
; Test05 Check CPM-RAM an Adresse: cupos =00
;------------------------------------------------------------------------------

cpm_ram_an:	call	chkram_an	; Check	CPM-RAM
		ret

;------------------------------------------------------------------------------
; Test06 Schreiben/Lesen AC1<->CPM 0000H..0000
; Test07 Schreiben/Lesen AC1<->CPM 0800H..0800
; Test08 Schreiben/Lesen AC1<->CPM 1000H..1000
; Test09 Schreiben/Lesen AC1<->CPM 1FFFH..1FFF
; Teste ein Byte auf aadr
;------------------------------------------------------------------------------

rdwrA:		call	sub_24C0	; Ausgabe Test+Schreiben/Lesen AC1<->CPM+aadr
		call	sub_24E7	; Lesen/Schreiben Adr HL
		call	OUTHL		; OUTHL; Ausgabe HL hexadezimal
		call	c, o_ok		; Ausgabe "OK"
		ret

;------------------------------------------------------------------------------
; Test0A Schreiben/Lesen AC1<->CPM 1000H..1FFF
; Teste Bereich aadr..min(eadr,1FFFh)
;------------------------------------------------------------------------------

rdwrB:		call	sub_24C0	; Ausgabe Test+Schreiben/Lesen AC1<->CPM+aadr
		push	hl
		xor	a
		ld	hl, 2000h	; eadr < 2000h?
		sbc	hl, bc
		pop	hl
		jr	nc, rdwrB1	; ja
		ld	bc, 2000h	; sonst eadr max. 2000h
rdwrB1:		push	bc
		call	sub_24E7	; Lesen/Schreiben Adr HL
		pop	bc
		call	outhlx		; Ausgabe HL und Cursor zurcksetzen
		jr	nc, rdwrB2	; Abbruch bei Fehler
		xor	a
		push	hl
		sbc	hl, bc		; eadr erreicht?
		pop	hl
		inc	hl		; nchste Adr.
		jr	nz, rdwrB1	; nein, nchste Adr.
		;
		call	o_ok		; Ausgabe "OK"
		jr	rdwrB3
		;
rdwrB2:		rst	prnst		; Ausgabe String
		db 8Dh
rdwrB3:		ret

;------------------------------------------------------------------------------
; Test0B Durchschreiben  AC1-->CPM 0000H..0000H
;------------------------------------------------------------------------------

wr_through:	call	o_test		; Ausgabe "Test"+Nr.
		rst	prnst		; Ausgabe String
		db " Durchschreiben  AC1-->CPM",0A0h
		call	OUTHL		; Ausgabe HL hexadezimal
		rst	prnst		; Ausgabe String
		db "H.", 0AEh		; "H.."
		ld	d, 0
		call	sub_2549
		call	c, o_ok		; Ausgabe "OK"
		jr	c, wr_through1
		call	OUTHL		; OUTHL; Ausgabe HL hexadezimal
		rst	prnst		; Ausgabe String
		db 'H',7,8Fh
		call	o_defekt	; Ausgabe "defekt!"
		rst	prnst		; Ausgabe String
		db  8Dh	; 
wr_through1:	ret

;------------------------------------------------------------------------------
; Test0C Trennung RAM's  AC1<->CPM 1000H..1FFF
;------------------------------------------------------------------------------

trennung:	ld	d, 1
		call	o_test		; Ausgabe "Test"+Nr.
		rst	prnst		; Ausgabe String
		db " Trennung RAM's  AC1<->CPM",0A0h
		call	OUTHL		; OUTHL; Ausgabe HL hexadezimal
		rst	prnst		; Ausgabe String
		db "H.", 0AEh		; "H.."
		call	sub_2549
		call	c, o_ok		; Ausgabe "OK"
		jr	c, trennung1
		call	OUTHL		; OUTHL; Ausgabe HL hexadezimal
		rst	prnst		; Ausgabe String
		db 'H',7,8Fh
		call	o_defekt	; Ausgabe "defekt!"
		rst	prnst		; Ausgabe String
		db 8Dh
		cp	0FFh
		jr	nz, trennung1
		rst	prnst		; Ausgabe String
		db "Achtung ! CPM-RAM schreibt auf AC1-RAM durch !",0Dh,8Dh
trennung1:	ret

;------------------------------------------------------------------------------
; Test0D Check AC1-RAM ab	Adresse: 1000H..FFFF
;------------------------------------------------------------------------------

ac1_ram_ab:	call	o_test		; Ausgabe "Test"+Nr.
		db 0DFh," Check AC1-RAM ab Adresse:",0A0h
		xor	a
		call	chkram_ab
		ret

;------------------------------------------------------------------------------
; Test0E Check CPM-RAM ab	Adresse: 0000H..FFFF
;------------------------------------------------------------------------------

cpm_ram_ab:	call	o_test		; Ausgabe "Test"+Nr.
		rst	prnst		; Ausgabe String
		db " Check CPM-RAM ab Adresse:",0A0h
		call	chkram_ab
		rst	prnst		; Ausgabe String
		db  8Dh	; 
		ret

;------------------------------------------------------------------------------
; Umschaltung auf CP/M-Modus bzw. AC1-Modus
;------------------------------------------------------------------------------

; CP/M-Modus
cpmmode:	push	af
		push	bc
		push	de
		ld	a, (cpm_fa)	; CP/M-Mode
		ld	e, a
		ld	a, (cpm_scch)	; CP/M-Mode
		ld	d, a
		jr	ac1mode1
; AC1-Modus
ac1mode:	push	af
		push	bc
		push	de
		ld	a, (ac1_fa)	; AC1-Mode
		ld	e, a
		ld	a, (ac1_scch)	; AC1-Mode
		ld	d, a
ac1mode1:	ld	a, (port_scch)	; Umschaltport ACC
		ld	c, a
		out	(c), d
		ld	a, (port_fa)	; Umschaltport FA
		ld	c, a
		out	(c), e
		pop	de
		pop	bc
		pop	af
		ret

;------------------------------------------------------------------------------
; Wait 
;------------------------------------------------------------------------------
;??? ungenutzt
wait:		push	bc
		ld	bc, 8000h
wait1:		dec	c
		jr	nz, wait1
		djnz	wait1
		pop	bc
		ret

;------------------------------------------------------------------------------
; UP's
;------------------------------------------------------------------------------
; Ausgabe "OK"
o_ok:		rst	prnst		; Ausgabe String
		db 6,0Ah		; "OK"
		db 8,8,'O',0CBh
		scf
		ret

; Ausgabe "defekt!"
o_defekt:	rst	prnst		; Ausgabe String
		db "defekt",0A1h
		ret

; Ausgabe "Test"+Nr.
o_test:		rst	prnst		; Ausgabe String
		db "Tes",0F4h
		call	OUTHEX		; Ausgabe A hexadezimal
		ret

;------------------------------------------------------------------------------
; Test auf RAM ab Adr
; in HL	Adr
; A=0 -> AC1-Mode, A<>0	CPM-Mode
;------------------------------------------------------------------------------

chkram_ab:	call	OUTHL		; OUTHL; Ausgabe HL hexadezimal
		rst	prnst		; Ausgabe String
		db "H.",0AEh            ; "H.."
		cp	0
		jr	z, chkram_ab1	; A=0 -> AC1-Mode, A<>0	CPM-Mode
		call	cpmmode		; CP/M-Modus
chkram_ab1:	call	isram_ab	; Test auf RAM ab HL bis max FFFF
		push	af
		call	ac1mode		; AC1-Modus
		dec	hl
		call	OUTHL		; OUTHL; Ausgabe HL hexadezimal
		pop	af
		call	z, o_ok		; Ausgabe "OK"
		jr	c, chkram_ab2
		call	o_defekt	; Ausgabe "defekt!"
		call	OUTHEX		; Ausgabe A hexadezimal
		rst	prnst		; Ausgabe String
		db 0ADh
		ld	a, c
		call	OUTHEX		; Ausgabe A hexadezimal
		rst	prnst		; Ausgabe String
		db 8Dh
chkram_ab2:	ret

;------------------------------------------------------------------------------
; 
;------------------------------------------------------------------------------

sub_2412:	xor	a
		jr	loc_2417
;		
loc_2415:	inc	a
		ret	z
loc_2417:	ld	c, a
		ld	(hl), a
		ld	a, (hl)
		cp	c
		jr	z, loc_2415
		scf
		ccf
		ret

;------------------------------------------------------------------------------
; 
;------------------------------------------------------------------------------

chkram_an:	call	o_test		; Ausgabe "Test"+Nr.
		rst	prnst		; Ausgabe String
		db " Check CPM-RAM an Adresse:",0A0h
		call	OUTHL		; Ausgabe HL hexadezimal
		rst	prnst		; Ausgabe String
		db "H ",0BDh
		call	cpmmode		; CP/M-Modus
		call	sub_2412
		call	ac1mode		; AC1-Modus
		; ok
		call	z, OUTHEX	; Ausgabe A hexadezimal
		call	z, o_ok		; Ausgabe "OK"
		jr	c, chkram_an1	; Ende wenn ok
		; Fehler
		rst	prnst		; Ausgabe String
		db "Fehler:",0A0h
		ld	b, a
		ld	a, c
		call	OUTHEX		; Ausgabe A hexadezimal
		rst	prnst		; Ausgabe String
		db '-',0BEh
		ld	a, b
		call	OUTHEX		; Ausgabe A hexadezimal
		call	o_defekt	; Ausgabe "defekt!"
		rst	prnst		; Ausgabe String
		db 8Dh
chkram_an1:	ret

;------------------------------------------------------------------------------
; Test auf RAM ab HL bis max FFFF
;------------------------------------------------------------------------------

isram_ab:	ld	a, (hl)
		cpl
		ld	(hl), a		; Komplement schreiben
		ld	c, (hl)		; gegenlesen
		cp	(hl)		; vergleichen
		jr	nz, isram1	; kein RAM
		cpl
		ld	(hl), a		; orig Wert zurueckschreiben
		inc	hl		; naechste Adr.
		ld	a, h
		or	l
		ret	z		; Ende bei FFFF
		ld	a, h		; 2000-2600 auslassen (dieses Programm)
		cp	20h 	; hi(2000h)
		jr	nz, isram_ab	; Test auf RAM ab HL bis max FFFF
		ld	hl, 2601h	; in diesem Fall weiter	ab 2601
		jr	isram_ab	; Test auf RAM ab HL bis max FFFF
isram1:		cpl			; im Fehlerfall
		ld	(hl), a		; orig.	Wert zurueckschreiben
		inc	hl		; naechste Adr.
		scf
		ccf			; Cy=0
		ret

;------------------------------------------------------------------------------
; Schreiben/Lesen AC1<->CPM Adr HL
;------------------------------------------------------------------------------

sub_248F:	ld	a, (hl)
		push	af
		ld	a, 0Fh
		sbc	a, h
		ld	a, (hl)
		jr	nc, loc_2499
		ld	a, 55h ; 'U'
loc_2499:	call	cpmmode		; CP/M-Modus
		ld	(hl), 0FFh
		cpl
		ld	e, a
		ld	(hl), a
		ld	c, (hl)
		call	ac1mode		; AC1-Modus
		cpl
		ld	d, a
		ld	(hl), a
		ld	b, (hl)
		pop	af
		ld	(hl), a
		xor	a
		ld	a, d
		cp	b
		jr	nz, loc_24B6
		ld	a, e
		cp	c
		jr	nz, loc_24B6
		scf
		ret
; lese CPM-Byte
loc_24B6:	call	cpmmode		; CP/M-Modus
		ld	a, (hl)
		call	ac1mode		; AC1-Modus
		scf
		ccf
		ret
		
;------------------------------------------------------------------------------
; Ausgabe Test+Schreiben/Lesen AC1<->CPM+aadr
;------------------------------------------------------------------------------

sub_24C0:	call	o_test		; Ausgabe "Test"+Nr.
		rst	prnst		; Ausgabe String
		db " Schreiben/Lesen AC1<->CPM",0A0h
		call	OUTHL		; OUTHL; Ausgabe HL hexadezimal
		rst	prnst		; Ausgabe String
		db "H.", 0AEh
		ret

;------------------------------------------------------------------------------
; UP zu rdwrA, rdwrB
; Schreiben/Lesen AC1<->CPM
;------------------------------------------------------------------------------

sub_24E7:	call	sub_248F	; Lesen/Schreiben Adr HL
		ret	c		; ok
		
		; Ausgabe fehlerhalfte Werte
		push	af
		rst	prnst		; Ausgabe String
		db "AC-",0BEh
		ld	a, d
		call	OUTHEX		; Ausgabe A hexadezimal
		rst	prnst		; Ausgabe String
		db 0BEh
		ld	a, b
		call	OUTHEX		; Ausgabe A hexadezimal
		rst	prnst		; Ausgabe String
		db " CP-",0BEh
		ld	a, e
		call	OUTHEX		; Ausgabe A hexadezimal
		rst	prnst		; Ausgabe String
		db 0BEh
		ld	a, c
		call	OUTHEX		; Ausgabe A hexadezimal
		rst	prnst		; Ausgabe String
		db " def",0AEh
		ld	c, (hl)
		pop	af
		cp	c
		jr	nz, loc_2547
		rst	prnst		; Ausgabe String
		db "Achtung ! AC1-RAM schreibt auf CPM-RAM durch !",0Dh,8Dh
loc_2547:	xor	a
		ret

;------------------------------------------------------------------------------
; 
;------------------------------------------------------------------------------

sub_2549:	push	bc
		call	outhlx		; Ausgabe HL und Cursor zurcksetzen
		ld	e, (hl)
		call	cpmmode		; CP/M-Modus
		ld	(hl), 0FFh
		call	ac1mode		; AC1-Modus
		ld	a, (hl)
		push	af
		ld	a, 55h ; 'U'
		ld	(hl), a
		call	cpmmode		; CP/M-Modus
		ld	b, (hl)
		call	ac1mode		; AC1-Modus
		cpl
		ld	(hl), a
		call	cpmmode		; CP/M-Modus
		ld	c, (hl)
		call	ac1mode		; AC1-Modus
		ld	(hl), e
		cp	c
		jr	nz, loc_2588
		cpl
		cp	b
		jr	nz, loc_2588
		pop	af
		cp	0FFh
		call	z, sub_2596
		xor	a
		cp	d
		jr	nz, loc_2592
loc_257D:	pop	bc
		push	hl
		xor	a
		sbc	hl, bc
		pop	hl
		jr	z, loc_259A
		inc	hl
		jr	sub_2549
loc_2588:	pop	af
		cp	0FFh
		call	z, sub_2596
		xor	a
		cp	d
		jr	nz, loc_257D
loc_2592:	pop	bc
		scf
		ccf
		ret
;
sub_2596:	cp	e
		ret	z
		jr	loc_2592
loc_259A:	scf
		ret

;------------------------------------------------------------------------------
; Ausgabe HL und Cursor zurcksetzen
;------------------------------------------------------------------------------

outhlx:		call	OUTHL		; Ausgabe HL hexadezimal
		rst	prnst		; Ausgabe String
aI:		db 8,8,8,88h
		ret

		end
