TITLE 'Zeige ASCI-Datei auf Konsole'
;
;(Tagesdatum)
;
;Anwendung:	SHOW DISKFILE.EXT
;Mit 'Leerzeichen' wird der naechste Schirm angezeigt;
;mit 'RETURN' die naechste Zeile.
;Gleiche Funktion wie TYPE, aber
;SHOW kann von WordStar aus aufgerufen werden.
;
FALSE	EQU	0
TRUE    EQU     NOT FALSE
;
BOOT	EQU	0    	;Warmstart
BDOS    EQU     5       ;BDOS-Eingang
FCB1	EQU	5CH	;Eingabe FCB
DBUFF	EQU	80H	;StandardPuffer
TPA     EQU     100H	;Anwenderbereich
LMAX	EQU	24	;Zeilen pro Schirm
;
;Setze Flags im Hauptprogramm, damit von
;einigen Subroutines nur eine Kopie generiert wird
;Setze die Flags vor dem MACLIB-Call.
;
CIFLAG	SET	FALSE	;Zeicheneingabe von der Konsole
CMFLAG	SET	FALSE	;ASCII-Vergleich
COFLAG	SET	FALSE	;Zeichenausgabe auf die Konsole
CRFLAG	SET	FALSE	;neue Zeile
DMFLAG	SET	FALSE   ;setze DMA
FLFLAG	SET	FALSE   ;Fuell-Zeichen
FNFLAG	SET	FALSE   ;Dateiname lesen
OPFLAG	SET	FALSE   ;Datei eroeffnen
PRFLAG	SET	FALSE   ;Konsolpuffer drucken
RCFLAG	SET	FALSE   ;Konsolpuffer lesen
RDFLAG	SET	FALSE   ;Datei lesen
;Ende der Flags
;
	MACLIB	CPMMAC
;
	ORG	TPA
;
START:
	ENTER
	VERSN	'(Tagesdatum).SHOW'
	LDA     FCB1+1
	CPI     BLANK	;Dateiname?
	JNZ     OPEND	;ja
	GFNAME	FCB1	;Dateiname lesen
OPEND:
	COMPRA	'COM',FCB1+9 ;COM-Datei?
	JZ      NOCOM   ;ja
	OPEN    FCB1    ;Quell-Datei
	SETDMA  DBUFF   ;benutze Standard
	LXI     H,100H  ;setze Pointer
NEXTSC:
	CALL	SCREEN	;naechster Schirm
FREE2:
	READCH		;warte auf Eingabe
	CPI     BLANK   ;Leerzeichen?
	JZ      NEXTSC  ;naechster Schirm
	CPI     CR
	JNZ     DONE  	;Abbruch
	PCHAR   CR
	MVI     B,1   	;setze auf 1 Zeile
	CALL    LINE    ;l Zeile
	JMP     FREE2
;
;Routine zum Fuellen des Konsolschirms
;
SCREEN:
	MVI	B,LMAX	;Zeilenzaehler
	PCHAR	CR
NEXTLN:
	CALL	LINE
	DCR     B	;zaehlen
	JNZ     NEXTLN  ;weiter
	RET
;
;Routine zum Anzeigen einer Zeile
;
LINE:
	MOV	A,H	;pruefe Pointer
	ORA     A       ;noch 80-FF?
	JZ      LIN3    ;ja
	READS   FCB1    ;lies einen Sektor
	JNZ     EOFILE  ;Dateiende
	LXI     H,DBUFF ;Zeiger zuruecksetzen
	JMP     LINE
LIN3:
	MOV	A,M
	INX     H
	ANI     7FH	;loesche Paritybit
	CPI     EOF     ;Dateiende
	JZ      EOFILE  ;ja
	MOV     D,A     ;retten
	CPI     CR      ;Zeilenende?
	JNZ     LIN2    ;nein
	MOV     A,B     ;pruefe Position
	CPI     1       ;letze Zeile?
	RZ              ;ja, kein CR
	MOV	A,D	;lade CR
LIN2:
	PCHAR		;Ausgabe auf Konsole
	MOV     A,D     ;lade
	CPI     CR      ;Zeilenende?
	JNZ     LINE    ;nein
	RET
NOCOM:
	ERRORM 'Benutze DUMP fuer eine COM-Datei',DONE
EOFILE:
	READCH		;letze Seite
DONE:
	EXIT
;
	END	START
