	TITLE	'RENAME benennt eine Datei um mit nicht-eindeutigen Angaben'
;
;(Tagesdatum)
;Abbruch des Programms mit ESC.
;Programm beendet sich, wenn es eine Systemdatei findet.
;Anwendung 	RENAME OLD NEW
;		RENAME OLD.EXT *.BAK
;		RENAME OLD.EXT NEW.*
;		RENAME OLD.* NEW.*
;		RENAME *.EXT *.BAK
;
FALSE	EQU	0
TRUE    EQU     NOT FALSE
;
BOOT	EQU	0
BDOS    EQU     5       ;BDOS-Eingang
TPA     EQU     100H
FCB	EQU	5CH	;Dateisteuerblock
;
FCB1	EQU	5CH	;erster Dateiname
FCB2	EQU	6CH	;zweiter Dateiname
DBUFF	EQU	80H	;Standardpuffer
;
;Setze Flags im Hauptprogramm, damit von
;einigen Subroutines nur eine Kopie generiert wird.
;Die Flags muessen vor dem MACLIB-Call gesetzt werden
;
CIFLAG	SET	FALSE	;Eingabe Konsolzeichen
CMFLAG	SET     FALSE   ;Vergleich
CRFLAG	SET     FALSE   ;neue Zeile
COFLAG	SET     FALSE   ;Ausgabe Konsolzeichen
DEFLAG	SET     FALSE   ;Datei loeschen
MVFLAG	SET     FALSE   ;Blockverschiebung
OPFLAG	SET     FALSE   ;Datei eroeffnen
PRFLAG	SET     FALSE   ;Konsolausgabe
RNFLAG	SET     FALSE   ;Datei umbenennen
UNFLAG	SET     FALSE   ;setze Dateiattribute
;Ende der Flags
;
	MACLIB	CPMMAC
;
	ORG	TPA
;
START:
	ENTER
	VERSN	'(Tagesdatum).RENAME'
	LDA	FCB1+1
	CPI     BLANK
	JZ      NOSOUR
	LDA     FCB2+1
	CPI     BLANK
	JZ      NODEST
	COMPAR  FCB1+1,FCB2+1,11
	JZ      SAMEN
	COMPAR  '???????????',FCB1+1
	JZ      IMPROP
	COMPAR  '???????????',FCB2+1
	JZ      IMPROP
	XRA     A	;null
	STA     FIRSTF	;loesche Flag
	PRINT   <LF,'Zum Abbruch ESC druecken',CR,LF>
;
;rette Originalparameter
;
	MOVE	FCB1,FCOPY,20H
	MOVE    FCB1,OFCB,20H
NEXTN:			;naechsten Namen
	OPEN	FCB1,FPASS ;Quelldatei
	ABORT   ESC	;Ende?
	MVI     A,0FFH
	STA     FIRSTF	;Wiederholung
	LDA     FCB1+10 ;System-Datei
	ANI     80H     ;Bit7
	JNZ     SYSFIL  ;ueberspringen
	UNPROT  FCB1
	MOVE    FCB1,OFCB,12 ;Original
	LDA     FCB1	;Laufwerknummer
	STA     DFCB
;
;Test auf nicht-eindeutigen Originaldateinamen
;
	COMPAR  FCB1+1,FCOPY+1,8
	JZ 	NOQ1 	;nein
	MOVE 	FCB1+1,OFCB+1,11 ;alter Name
	MOVE 	FCB1+1,DFCB+1,8 ;neuerName
	MOVE 	F2COPY+9,DFCB+9,3 ;Dateityp
	JMP 	CHEK2
NOQ1:
;
;Test auf nicht-eindeutigen Originaldateityp
;
	COMPAR	FCB1+9,FCOPY+9,3
	JZ      NOQ3	;nein
	MOVE    FCB1+1,OFCB+1,11 ;neuerName
	MOVE    FCB1+9,DFCB+9,3 ;neuerTyp
	MOVE    F2COPY+1,DFCB+1,8 ;Name
	JMP     CHEK2
;
;Test auf nicht-eindeutigen neuen Namen
;
NOQ3:
	AMBIG FCB1, DFCB
CHEK2:
	OPEN	DFCB, RENAM
	CRLF
	PFNAME	DFCB
	PRINT	' Existiert bereits. Loeschen?'
	READCH
	UCASE
	CPI	'J'
	JNZ	DONE
	LDA     FCB1	;Laufwerk
	STA     DFCB
	DELETE  DFCB
RENAM:
	RENAME	OFCB
	MOVE    FCOPY+1,FCB+1,11
	JMP     NEXTN
FPASS: 			;Fehlermeldung
			;falls 1. Durchgang
	LDA	FIRSTF 	;lies Durchgangs-Flag
	ORA 	A 	;erster Durchgang
	JNZ 	DONE 	;nein
	ERRORM	'Datei nicht gefunden',DONE
NOSOUR:
	ERRORM	'Keine Quell-Datei',DONE
NODEST:
	ERRORM	'Keine Ziel-Datei',DONE
SAMEN:
	ERRORM	'Gleicher Name',DONE
IMPROP:
	ERRORM	'Ungueltiger Name',DONE
FIRSTF:
	DB	0	;1. Durchgang
;
SYSFIL:			;Systemdatei gefunden
	CRLF
	PFNAME	FCB
	PRINT	' ist eine Systemdatei'
DONE:
	EXIT
FCOPY: 	DS	10H	;Originalkommando
F2COPY: DS      10H     ;mit zweitem Dateinamen
OFCB: 	DS      10H     ;Originalname
DFCB: 	DS      10H     ;neuer Name
;
	END START
