TITLE 'DUMP binaere Datei zur Konsole'
;
;(Tagesdatum)
;
;Anwendung:	DUMP (Dateiname)
;
;Zwischenr = naechster Schirm
;<CR> 	   = naechste Zeile
;<ESC> 	   = Abbruch

;Mit 'Leerzeichen' wird der naechste Schirm angezeigt;
;mit 'RETURN' die naechste Zeile.
;Gleiche Funktion wie TYPE, aber
;SHOW kann von WordStar aus aufgerufen werden.
;
FALSE	EQU	0
TRUE    EQU     NOT FALSE
;
BOOT	EQU	0    	;Warmstart
BDOS    EQU     5       ;BDOS-Eingang
FCB1	EQU	5CH	;Eingabe FCB
DBUFF	EQU	80H	;StandardPuffer
TPA     EQU     100H	;Anwenderbereich
LMAX	EQU	23	;Zeilen pro Schirm
;
;Setze Flags im Hauptprogramm, damit von
;einigen Subroutines nur eine Kopie generiert wird
;Setze die Flags vor dem MACLIB-Call.
;
CIFLAG	SET	FALSE	;Zeicheneingabe von der Konsole
COFLAG	SET	FALSE	;Zeichenausgabe auf die Konsole
CRFLAG	SET	FALSE	;neue Zeile
CXFLAG	SET	FALSE	;binaer in C nach hex
DMFLAG	SET	FALSE   ;setze DMA
FLFLAG	SET	FALSE   ;Fuell-Zeichen
FNFLAG	SET	FALSE   ;Dateiname lesen
GTFLAG	SET	FALSE	;Zeichen von Puffer lesen
OPFLAG	SET	FALSE   ;Datei eroeffnen
PRFLAG	SET	FALSE   ;Konsolpuffer drucken
RCFLAG	SET	FALSE   ;Konsolpuffer lesen
RDFLAG	SET	FALSE   ;Datei lesen
;Ende der Flags
;
	MACLIB	CPMMAC
;
	ORG	100H
;
START:
	ENTER
	VERSN	'(Tagesdatum).DUMP'
	LDA     FCB1+1
	CPI     BLANK	;Dateiname?
	JNZ     OP3	;ja
	GFNAME	FCB1	;Dateiname lesen
OP3:
	OPEN    FCB1    ;Eingabe Datei
	SETDMA  DBUFF   ;Sektor Adresse
	LXI     H,TPA	;Anzeige Pointer

	SHLD	PNTR
	PRINT	'Leertaste fuer naechsten Bildschirm, '
	PRINT	'<CR> naechste Zeile, <ESC> zum Abbrechen'

NEWLN:			;neue Zeile
	CRLF
	PUSH	H    	;Pufferzeiger
	LHLD    PNTR    ;Anzeige Pointer
	OUTHEX  H       ;Adresse
	OUTHEX  L
	LXI     D,10H	;naechste Zeile
	DAD     D
	SHLD    PNTR
	POP     H    	;Pufferzeiger
	PCHAR   BLANK
NEXT:
	MOV	A,H	;pruefe Pointer
	ORA	A      	;noch 80-FF hex?
	JZ      NEXT2   ;ja
	READS   FCB1    ;einen Sektor lesen
	JNZ     DONE    ;Dateiende
	LXI     H,DBUFF
	JMP     NEXT
NEXT2:
	OUTHEX	M
	INX     H
	MOV     A,L
	ANI     0FH  	;Zeilenende?
	JZ      PASC    ;ja
	ANI     3       ;Leerzeichen?
	JNZ     NEXT    ;nein
	PCHAR   BLANK
	JMP     NEXT
PASC:			;ASCll-Dump
	PRINT	' '
	PUSH	H	;Pufferzeiger
	MOV     A,L
	SUI     10H
	MOV     L,A ;aendere Zeiger
PAS2:
	MOV	A,M
	INX     H
	CPI     7FH  	;Bit 7 an?
	JNC     PAS3    ;ja
	CPI     BLANK   ;Control-Zeichen?
	JNC     PAS4    ;nein
PAS3:
	MVI 	A,PERIOD ;aendern in Punkt
PAS4:
	PCHAR		;drucken
	MOV	A,L
	ANI     0FH 	;Zeilenende?
	JNZ     PAS2    ;nein
	POP     H       ;Pufferzeiger
	ABORT   ESC     ;Abbruch?
	LDA     LINE
	DCR     A
	STA	LINE
	JNZ     NEWLN
	MVI     A,LMAX
	STA     LINE
;
;stop bis Leertaste gedrueckt wird
FREEZ:
	READCH 		;warte auf Eingabe
	CPI 	BLANK	;Leerzeichen?
	JZ      NEWLN
	ANI     1FH  	;konvertiere in Control
	CPI     CR      ;naechste Zeile?
	JNZ     FREZ2   ;nein
	MVI     A,1     ;l Zeile
	STA     LINE
	JMP     NEWLN
LINE:
	DB	LMAX 	;Zeilenzaehler
FREZ2:
	CPI	ESC  	;Abbruch?
	JNZ     FREEZ   ;nein
DONE:
	EXIT
;
PNTR:	DS 	2	;Anzeige Pointer
	END START
