TITLE	'DIREC,Verzeichnis-Utitity'
;
;(Tagesdatum)
;
;
FALSE	EQU	0
TRUE    EQU     NOT FALSE
;
BOOT	EQU	0
BDOS    EQU     5       ;BDOS-Eingang
TPA     EQU     100H
FCB	EQU	5CH  	;Dateisteuerblock
FCB1    EQU     5CH  	;1. Dateiname
FCB2    EQU     6CH     ;2. Dateiname
DBUFF   EQU     80H     ;Standardpuffer
ABUFF   EQU     DBUFF   ;Puffer
UNUSED  EQU     0E5H    ;unbenutzter Verz. Eintrag
;
;Setze Flags im Hauptprogramm, damit von
;einigen Subroutines nur eine Kopie generiert wird.
;Die Flags muessen vor dem MACLIB-Call gesetzt werden
;
BNFLAG 	SET	FALSE	;binaer nach ASCII bin
CIFLAG	SET	FALSE	;Konsoleingabe
COFLAG 	SET     FALSE   ;Konsolausgabe
CRFLAG 	SET     FALSE   ;Neue Zeile
CXFLAG 	SET     FALSE   ;binaer nach hex
DEFLAG 	SET     FALSE   ;binaer nach dezimal
DVFLAG 	SET     FALSE   ;16-bit Division
MLFLAG 	SET     FALSE   ;16-bit Multiplikation
MVFLAG 	SET     FALSE   ;Blockverschiebung
PRFLAG 	SET     FALSE   ;Konsolausgabe
FLFLAG	SET	FALSE	;Loeschen
;
;Ende der Flags
;
	MACLIB CPMMAC
;
	ORG	TPA
;
START:
	ENTER
	VERSN	'(Tagesdatum).DIREC.2'
	CPMVER		;teste Version
	CPI	20H
	JC	ERRVER	;falsche Version
	PRINT	'Fuer Laufwerk '
	CALL	CDISK 	;momentanes Laufwerk
	LDA     FCB1
	ORA     A	;Laufwerk angegeben?
	CNZ     SETDSK 	;ja
	STA	FCB1 	;binaer
	ADI	 'A'	;konvertiere nach ASCll
	PCHAR
	CALL    GETDPH 	;Disk-Parameter
	CALL    XAMINE
	PRINT	'Bitte eine Taste druecken: '
	READCH  	;warte auf Eingabe
	CALL    REPEAT 	;init. Parameter
	CALL    BLOCK 	;Zuordnungs-Tabelle
	JMP     DONE
;
;Block-Move Disk-Parameter zum Ende des Programms
;
GETDPH:
	MVI	C,31	;Disk-Param-Adresse
	CALL	BDOS
	MOVE 	,DPARM,15 ;kopiere ans Ende
	LHLD	BLKMAX 	;max. Zahl der Btoecke
	INX	H
	SHLD	BLKMAX 	;Beginn bei Null
	LHLD 	DIRENT 	;Anzahl der Verzeichniseintraege
	INX	H	;Beginn bei Null
	DIVIDE 	4 	;konvertiere in # Sektoren
;Rette Anzahl der Verzeichnis-Sektoren als 16 Bits
	SHLD	DIRMAX
	SHLD	DIRMX2
;
;Verzeichnis-Zuordnung wird gespeichert als
;1000 0000 fuer 1 Block, 1100 0000 fuer 2, etc.
;Das linke Byte soll in H stehen
;
	LHLD	ALLOC	;vertausche Bytes
	MOV	A,L
	MOV	L,H
	MOV	H,A
	SHLD	ALLOC
;Anzahl der Verzeichnisbloecke in ASCII
	XRA	A
XAM3:
	DAD 	H	;mal2
	JNC 	XAM4
	INR 	A
	JMP 	XAM3
XAM4:
	MOV 	E,A	;# Verz.Bloecke
	MVI 	D,0
	LHLD 	BLKMAX	;Bloecke
	SBC 	HL,DE   ;fuer Verzeichnis
	SHLD 	NETBL   ;netto Datenbloecke
	MOV	A,E
	ORI 	'0'
	STA	ALLOCA
;
;selektiere Laufwerk und init. Disk-Parameter-Kopf
;
	LDA	FCB
	MOV     C,A
	CALL    SELDSK	;selektiere Laufwerk
	MOV     A,H     ;HL enthaelt DPH
	ORA     L
	JZ      ILDISK  ;Fehler, kein Laufwerk
	MOV     E,M     ;UEbersetzungstabelle
	INX     H       ;Adresse
	MOV     D,M
	XCHG
	SHLD	DPH
	RET
;
;Anzeige der Disk-Parameter
;
XAMINE:
	PRINT	<CR,LF,'Sektoren/Spur: '>
	LHLD    NUMSEC
	HLDEC		;dezimal
	PCHAR   BLANK
	PCHAR   '('
	OUTHL
	PRINT   <' hex)',CR,LF,'Sektoren/Block: '>
	LDA     BLM
	INR     A
	MOV     L,A
	MVI     H,0
	HLDEC
	PCHAR   BLANK
	PCHAR   '('
	OUTHEX  L
	PRINT   ' hex)'
	PRINT   <CR,LF,'Blockgroesse: '>
	DIVIDE  8
	MOV     B,L 	;rette Blockgroesse
	HLDEC
	PRINT	'K Bytes'
	LHLD    NETBL	;# Daten-Bloecke
	MOV     A,B	;Blockgroesse
	MULT
	PRINT	<CR,LF,'Diskettengroesse: '>
	HLDEC
	PRINT   'K Bytes'
	PRINT   <CR, LF,'Extents/Eintrag: '>
	LDA     EMASK
	INR     A
	MOV     L,A
	MVI     H,0
	HLDEC
	PRINT   <CR,LF,'Anzahl der Bloecke: '>
	LHLD	BLKMAX
	HLDEC
	PCHAR   BLANK
	PCHAR   '('
	OUTHL
	PRINT   <' hex)',CR,LF,'Max. Dir. Eintraege: '>
	LHLD    DIRENT
	INX     H
	HLDEC
	PCHAR   BLANK
	PCHAR   '('
	OUTHL
	PRINT   <' hex)',CR,LF,'Dir. Bloecke: '>
	LDA     ALLOCA
	PCHAR
	PCHAR   BLANK
	PCHAR   '('
	LDA     ALLOC+1
	BINBIN		;ALLOC in binaer
	LDA     ALLOC
	ORA     A
	JZ      XAM2
	BINBIN		;2. falls benoetigt
XAM2:
	PRINT	<')',CR,LF,'Spur-Offset: '>
	LHLD    TRKOFF
	HLDEC
	MOV     A,H
	ORA     A
	JZ      XAM5	;ueberspringe hex
	PCHAR   BLANK
	PCHAR   '('
	OUTHL
	PRINT	' hex)'
XAM5:
	CRLF
	RET
SETDSK:			;setze Laufwerk
	DCR	A	;0=A,1=B
	STA  	CURD2
	MOV	E,A
	MVI	C,14	;selektiere neues Laufwerk
	JMP	BDOS
;
REPEAT:			;zuruecksetzen Parameter
	FILLD	SECTOR,HERE-SECTOR,0
	LHLD    TRKOFF
	SHLD    TRACK 	;Spur-Offset zuruecksetzen
	LHLD    DIRMAX 	;# Verzeichnis-Sektoren
	SHLD    DIRMX2
	RET
;
;Anzeige der Block-Zuordnungs-Tabelle
;
BLOCK:
;
;Setze reservierte Verzeichnis-Bloecke in Tabelle
;durch Shift von ALLOC nach links
	PRINT	<CR,LF,LF,'Dateizuordnungstabelle',CR,LF>
	LHLD    BLKMAX	;Anzahl Bloecke
	MOV     B,H
	MOV     c,L
	FILLD   BMAP,,0	;loeschen des Tabellenbereichs
	LHLD    ALLOC
	LXI     D,BMAP
C14A:
	XCHG
	INR	M   	;setze Bit
	INX     H
	XCHG
	DAD     H       ;mal2
	MOV     A,L
	ORA     H       ;null?
	JNZ     C14A    ;nein
BLOCK3:
	CALL	NXTSEC
	JZ      BLOCK4	;fertig
	CALL    BPROG
	JMP     BLOCK3
;
;Anzeige der Zuordnungstabelle
;
BLOCK4:
	PRINT	'Bitte eine Taste druecken: '
	READCH		;warte auf Eingabe
	PRINT   <CR,LF,LF,'0123456789ABCDEF'>
	PRINT   '0123456789ABCDEF'
	LHLD    BLKMAX
	MOV     B,H
	MOV     C,L
	LXI     H,BMAP	;Beginn der Tabelle
BMAP2:
	MOV	A,L
	ANI     0FH  	;loesche obere 4 Bits
	JNZ     BMAP6
	MOV     A,L
	ANI     1FH  	;loesche obere 3 Bits
	JZ      BMAPT	;gerade
	PCHAR   BLANK
	JMP     BMAP5
BMAPT:
	ABORT	ESC
	CRLF     	;neue Zeile
	OUTHEX  L       ;Adresse
	PCHAR   ':'
	PCHAR   BLANK
	JMP     BMAP5
BMAP6:
	CPI	8
	JNZ     BMAP5
	PCHAR   BLANK
BMAP5:
	MOV	A,M  	;Eintrag
	ORA     A       ;null?
	JZ      BMAP8   ;ja
	XCHG            ;rette HL in DE
	LHLD	BLKCNT
	INX     H       ;Zaehler
	SHLD    BLKCNT
	XCHG
BMAP8:
	CPI	10   	;<9
	JNC     BMAP3   ;mache ASCII
	ORI     '0'
	JMP     BMAP4
BMAP3:
	ADI 	'A'-10	;mache hex
BMAP4:
	PCHAR 		;ausgeben
	INX 	H
	DCX 	B	;zaehlen
	MOV 	A,C     ;fertig?
	ORA 	B
	JNZ 	BMAP2   ;nein
;
;Anzeige der Gesamtblockzahl und Zahl der benutzten Bloecke
;
	CRLF
	LHLD	NETBL ;netto + Bloecke
	HLDEC
	PUSH    H
	PRINT   ' Bloecke total,'
	LHLD    BLKCNT
	LDA     ALLOCA	;Verz.Bloecke
	SUI     '0'     ;mache binaer
	MOV     E,A
	MVI     D,0
	SBC     HL,DE
	HLDEC
	PRINT	' benutzt,'
	XCHG
	POP     H
	SBC     HL,DE	;Differenz
	HLDEC
	PRINT   <' uebrig',CR,LF>
	RET
;
;Aufbau der Block-Zuordnungs-Tabelle
BPROG:
	CALL	E5AREA	;suche E5
	MOV     A,M     ;1. Byte
	CPI     17      ;Benutzer > 16?
	JNC     BKINCD  ;ja
	PUSH    H
;
	OUTHEX		;Benutzernummer
	PCHAR	BLANK
	INX     H    	;Dateiname
	PRINT	,11  	;Anzeige Dateiname
	PCHAR   BLANK
	LXI     D,11    ;hinter Dateiname
	DAD     D       ;1. Eintrag
	MVI     C,4     ;naechste 4 Bytes
;
;Die naechsten 4 Bytes enthalten Bereich und Anzahl der Sektoren
;
LOOP2:
	OUTHEX	M
	INX     H
	DCR     c
	JNZ     LOOP2
	PCHAR   BLANK
	MVI     C,16	;16 Bloecke/Bereich
;
;Test auf mehr als 255 Bloecke.
;Wenn ja, wird eine 16-Bit-Blockadresse benutzt
;
	LDA 	BLKMAX+1 ;obere Haelfte
	ORA 	A 	;null?
	JNZ 	BNEXT6 	;nein, 16 Bits
;
;8-bit Blockadressen
BNEXT8:
	MOV	A,M
	OUTHEX      	;Anzeige Blocknummer
	ORA     A       ;null?
	JZ      BPRT2   ;letzter Block
	PUSH    H
	LXI     H,BMAP  ;Start
	MOV     E,A
	MVI     D,0
	DAD     D       ;Offset
	INR     M       ;kennzeichne als benutzt
	POP     H
	INX     H
	MOV     A,L
	ANI     0FH     ;Ende der Zeile?
	JNZ	BNEXT8	;nein
	JMP     BPRT2
;
;16-bit Blockadressen
;
BNEXT6:
	MOV	E,M	;niederes Byte
	OUTHEX  E       ;Blocknummer
	INX     H
	MOV	A,M	;oberes Byte
	OUTHEX  	;Blocknummer
	ORA     E	;null?
	JZ  	BPRT2 	;ja, fertig
	MOV	D,M
	PUSH    H
	LXI     H,BMAP	;Tabellenbeginn
	DAD     D       ;addiere Adresse
	INR     M       ;kennzeichne als benutzt
	POP     H
	INX     H       ;naechsteAdresse
	MOV     A,L
	ANI     0FH     ;Zeilenende?
	JNZ     BNEXT6  ;nein
BPRT2:
	POP	H	;Beginn des FCB
	CRLF    	;neue Zeile
BKINCD:
	CALL	DECCNT
	JZ      CKDONE
	LXI     D,32  	;FCB-Laenge
	DAD     D     	;naechster Eintrag
	JMP     BPROG
;
;erhoehe Zaehler, vermindere Sektornummer
;
CKDONE:
	LHLD	DIRMX2
	DCX     H     	;Sektorzaehler
	SHLD    DIRMX2
	LHLD	SECTOR 	;16 Bits
	INX	H
	SHLD	SECTOR
	XCHG
	LHLD 	NUMSEC 	;Sektoren/Spur
;
;teste, ob eine neue Spur gelesen werden muss
;
	SBC	HL,DE	;Differenz
	MOV     A,L
	ORA     H       ;null?
	RNZ
	SHLD	SECTOR  ;null setzen
	LHLD    TRACK
	INX     H       ;erhoehe Spur
	SHLD    TRACK
	RET
;
;Lies naechsten Sektor (4 Verzeichnis-Eintraege).
;Setze Zero-Flag, falls letzter Sektor
;
NXTSEC:
	LDA	E5FLAG 	;uninitialisierter gefunden?
	CPI     1	;ja
	RZ
NXTSF:
	LHLD	DIRMX2  ;mehr Sektoren?
	MOV     A,L
	ORA     H	;setze Flags
	RZ      	;nein
	CALL	SETTRK 	;setze Spur
	LHLD    SECTOR  ;16 Bits
	MOV     B,H
	MOV     c,L
	CALL    TRANSL
	CALL    SETSEC 	;setze Sektor
	CALL    READ
	MVI     A,4     ;Eintraege/Sektor
	STA     ECOUNT
	LXI     H,ABUFF ;DMA-Adresse
	ANI	1
	XRI	1	;invertiere Fehler-Flag
	RET		;Null, wenn Fehler
;
;Vermindere Anzahl der verbleibenden Eintraege im Sektor
;(4 maximal). Zero-Flag gesetzt, falls letzter
;
DECCNT:
	LDA	ECOUNT	;Eintraege/Sektor
	DCR 	A
	STA	ECOUNT
	RET
;
;Test auf E5 uninitialisierter Bereich, setze E5FLAG=1, wenn ja
E5AREA:
	INX	H     	;1.Zeichen
	INX     H       ;2.Zeichen
	MOV     A,M
	CPI     UNUSED
	DCX     H
	DCX     H
	RNZ		;nicht gefunden
	MVI	A,1
	STA     E5FLAG  ;setze Flag
	RET
;
;suche momentanes Standardlaufwerk
;
CDISK:
	MVI	C,25
	CALL    BDOS
	STA     CURD2 	;A=0, B=1
	ADI     'A'     ;konvertiere nach ASCII
	STA     CURDSK
	RET
;
;uebersetze BC von logischer in physikalische
;Sektornummer BC => HL => BC
;
TRANSL:
	LHLD	DPH 	;Translate-Tabelle
	XCHG
	CALL    SECTRN
	MOV     B,H
	MOV     c,L
	RET
;
;setze Spur auf 16-bit Wert in BC
;
SETTRK:
	LHLD 	TRACK	;16 Bits
	MOV 	B,H     ;kann null sein
	MOV 	C,L
	LHLD 	BOOT+1  ;Warmstart
	PUSH 	D
	LXI 	D,3*9   ;Offset
	DAD 	D
	POP	D
	PCHL
SETSEC:			;selektiere Sektor in BC
	LHLD 	BOOT+1	;Warmstart
	PUSH 	D
	LXI 	D,3*10  ;Offset
	DAD	D
	POP 	D
	PCHL
SELDSK:			;selektiere Disk in C
	LHLD 	BOOT+1  ;Warmstart
	PUSH 	D
	LXI 	D,3*8   ;Offset
	DAD	D
	POP 	D
	PCHL
;Lies Sektor, A=0, wenn erfolgreich
READ:
	LHLD	BOOT+1	;Warmstart
	PUSH	D
	LXI 	D,3*12  ;Offset
	DAD	D
	POP	D
	PCHL
;Schreibe Sektor, A:0, wenn erfolgreich
WRITE:
	LHLD	BOOT+1	;Warmstart
	PUSH 	D
	LXI 	D,3*13  ;Offset
	DAD	D
	POP	D
	PCHL
;
;Sektor-UEbersetzung von logischem Sektor in BC
;in physikalischen Sektor in HL, DE enthaelt Translate-Tabelle
;
SECTRN:
	LHLD	BOOT+1 	;Warmstart
	PUSH 	D
	LXI 	D,3*15 	;Offset
	DAD 	D
	POP 	D
	PCHL
;
ERRVER:
	ERRORM	'CP/M-Version muss 2 oder groesser sein'

ILDISK:
	ERRORM	'?Illegales Laufwerk'
DONE:
	EXIT
DPARM:			;Kopie der Disk-Parameter
NUMSEC: DS	2	;Sektoren per Spur
BSHIFT: DS      1       ;Block-Shift
BLM: 	DS      1       ;Block-Maske
EMASK: 	DS      1       ;Extent-Maske
BLKMAX: DS      2       ;max # Bloecke auf Diskette
DIRENT: DS      2       ;max # Verz.Eintraege
ALLOC: 	DS      2       ;AL1, AL0 vertauscht
CKS: 	DS      2       ;Check Groesse
TRKOFF: DS      2       ;Spur-Offset
;
DPH:	DS 	2	;Disk-Parameter-Kopf
;
DIRMAX: DS      2       ;max # Verzeichnis-Sektoren
NETBL: 	DS      2       ;Anzahl von Daten-Bloecken
ALLOCA: DS      1       ;Verzeichnis-Bloecke (ASCII)
DIRMX2: DS      2       ;verbleibende Verz. Sektoren
CURDSK: DS	1	;Laufwerk (ASCll)
CURD2: 	DS      1       ;Laufwerk (binaer)
ECOUNT: DS      1       ;Eintraege im Sektor (0-3)
;
SECTOR: DS	2	;laufender Sektor
TRACK: 	DS      2       ;laufende Spur
E5FLAG: DS      1       ;nicht-initialisiert, wenn 1
BLKCNT: DS      2       ;Bloecke benutzt
;
HERE: 			;ersetze durch ASEG:
	ORG (HERE AND 0FF00H) + 100H 	;ORG 0A00H
					;fuer Microsoft
BMAP: 	DS	1	;Block-Zuordnungs-Tabelle

	END START
