	TITLE	'Loesche Datei mit nicht-eindeutigem Namen'
;
;(Tagesdatum)
;
;Anwendung: 	DELETE NAME
; 		DELETE NAME.EXT
; 		DELETE NAME.*
; 		DELETE *.EXT
;
FALSE	EQU	0
TRUE    EQU     NOT FALSE
;
BOOT	EQU	0
BDOS    EQU     5       ;BDOS-Eingang
TPA     EQU     100H
;
FCB1	EQU	5CH	;erster Dateiname
FCB2	EQU	6CH	;zweiter Dateiname
DBUFF	EQU	80H	;Standardpuffer
;
;Setze Flags im Hauptprogramm, damit von
;einigen Subroutines nur eine Kopie generiert wird.
;Die Flags muessen vor dem MACLIB-Call gesetzt werden
;
CIFLAG	SET	FALSE	;Eingabe Konsolzeichen
CMFLAG	SET     FALSE   ;Vergleich
CRFLAG	SET     FALSE   ;neue Zeile
COFLAG	SET     FALSE   ;Ausgabe Konsolzeichen
DEFLAG	SET     FALSE   ;Datei loeschen
MVFLAG	SET     FALSE   ;Blockverschiebung
OPFLAG	SET     FALSE   ;Datei eroeffnen
PRFLAG	SET     FALSE   ;Konsolausgabe
UNFLAG	SET     FALSE   ;Dateischutz aufheben
;Ende der Flags
;
	MACLIB	CPMMAC
;
	ORG	TPA
;
START:
	ENTER
	VERSN	'(Tagesdatum).DELETE'
	LDA	FCB1+1
	CPI     BLANK
	JZ      NOSOUR
	PRINT	<LF,'Zum Abbruch ESC druecken',CR,LF>
	LDA     FCB2+1
	STA	QUERY	;nachfragen zum Loeschen
	COMPAR  '???????????',FCB1+1
	JNZ     ALLNAM
	PRINT   'Alles Loeschen? (J/N)'
	READCH
	UCASE
	CPI	'J'
	JNZ	DONE
ALLNAM:			;lies ersten Dateinamen
	LXI	D,FCB1
	MVI     c,17  	;suche Dateinamen
	CALL    BDOS
	CPI     0FFH  	;gefunden?
	JZ      NOSOUR	;nein
	CALL    GETNAM
NNAME: 			;lies naechsten Dateinamen
	LXI	D,FCB1
	MVI     c,18
	CALL    BDOS
	CPI     0FFH  	;mehr?
	JZ      NNAM2   ;nein
	CALL    GETNAM
	JMP     NNAME
NNAM2:
	LXI	H,FNAMES-12
	SHLD    FPNTR
NEXTN: 			;naechsten Namen
	LHLD 	FPNTR   ;Pointer
	LXI     D,12
	DAD     D	;rette
	SHLD    FPNTR
	MOV     A,M
	CPI     BLANK
	JZ      DONE
	MOVE    ,FCB1,12
	OPEN    FCB1	;Quell-Datei
	ABORT   ESC 	;Ende?
	LDA     QUERY 	;nachfragen
	CPI     'Q'
	JNZ     NOASK
	PRINT   <CR,LF,'Loeschen '>
	PFNAME  FCB1
	PCHAR   '?'
	PCHAR   BLANK
	READCH
	UCASE
	CPI	'J'
	JNZ     NEXTN
NOASK:
	DELETE	FCB1, NEXTN
	CRLF
	PFNAME	FCB1
	PRINT   'geloescht'
	JMP     NEXTN
GETNAM:			;Kopiere Dateinamen in
			;Zwischenbereich
	RRC		;3 Bits rechts = 5 links
	RRC		;0=0, 1=20H
	RRC		;2=40H,3=60H
	ANI	60H    	;Maske
	MOV     E,A
	MVI     D,0
	LXI     H,DBUFF
	DAD     D
	XCHG
	LHLD	FPNTR	;Ziel
	XCHG		;nach DE
	MOVE	,,12
	LXI     H,12
	DAD     D
	SHLD    FPNTR  	;naechsten Namen
	MVI     M,BLANK ;markiere Ende
	RET
NOSOUR:
	ERRORM 'Keine Quell-Datei',DONE
;
FPNTR:	DW	FNAMES	;Namen Pointer
QUERY:	DS      1       ;wenn Q, vor Loeschen fragen
;
DONE:
	EXIT
;
FNAMES:	DS	1	;Dateinamenstapel

	END START
