	TITLE	'Kopiere und verifiziere Datei'
;
;(Tagesdatum)
;
;Anwendung: COPYV QUELLE ZIEL
;
FALSE	EQU	0
TRUE    EQU     NOT FALSE
;
BOOT	EQU	0    	;Warmstart
BDOS    EQU     5       ;BDOS-Eingang
TPA     EQU     100H
;
FCB1	EQU	5CH	;erster Dateiname
FCB2	EQU	6CH	;zweiter Dateiname
DBUFF	EQU	80H	;Standardpuffer
BEL	EQU	7
;
;Setze Flags im Hauptprogramm, damit von
;einigen Subroutines nur eine Kopie generiert wird.
;Die Flags muessen vor dem MACLIB-Call gesetzt werden
;
CIFLAG	SET	FALSE	;Eingabe Konsolzeichen
CLFLAG	SET     FALSE   ;Datei schliessen
CMFLAG	SET     FALSE   ;Vergleich
COFLAG	SET     FALSE   ;Ausgabe Konsolzeichen
CRFLAG	SET     FALSE   ;neue Zeile
DEFLAG	SET     FALSE   ;Datei loeschen
DMFLAG	SET	FALSE	;DMA-Adresse setzen
MKFLAG	SET     FALSE   ;neue Datei erstellen
MVFLAG	SET     FALSE   ;Blockverschiebung
OPFLAG	SET     FALSE   ;Datei eroeffnen
PRFLAG	SET     FALSE   ;Konsolausgabe
RDFLAG	SET     FALSE   ;Sektor lesen
RNFLAG	SET     FALSE   ;Datei umbenennen
S2FLAG	SET     FALSE   ;SETUP2 Makro
UNFLAG	SET     FALSE   ;Schutz aufheben
WRFLAG	SET     FALSE   ;Sektor schreiben
;Ende der Flags
;
	MACLIB	CPMMAC
;
	ORG	TPA
;
START:
	ENTER
	VERSN	'(Tagesdatum).COPYV'
	SETUP2		;Eingabe- und Ausgabe-Dateien
	LDA	FCB1+9
	ANI     80H	;geschuetzt
	STA     PROTFL	;Schutzflag
	LDFILE	FCB1,BUFFP
	JNC     EOFILE	;Datei ok
	ERRORM  <CR,LF,'?Datei zu gross'>
EOFILE:
	LHLD	BUFFP   ;Pointer
	MVI     M,EOF
	ABORT   ESC
	WRFILE  DFCB,BUFFP,'#'
	CLOSE	DFCB	;Ziel-Datei
;Vergleiche beide Dateien
	OPEN	DFCB    
	LXI     H,BUFFER
	SETDMA  DBUFF   
NSECT:
	ABORT	ESC       
	READS   DFCB      
	ORA     A	;weiter bei null
	JNZ     DONE2     
	COMPAR  ,DBUFF,128 ;l Sektor
	JNZ     DIFFER    
	LXI     D,80H     
	DAD     D	;naechsten Sektor
	JMP     NSECT     
DONE2:
	LDA	PROTFL 	;geschuetzt?
	ORA     A
	JZ      DONE  	;nein
	PROTEC	DFCB
DONE:
	JMP	BOOT	;Warmstart
DIFFER:
	ERRORM	<BEL,'?Dateien sind verschieden'>
PROTFL:	DS	1	;Schutzflag
OLDSTK:
	DS	2
	DS	34
STACK:
BUFFP:	DW	BUFFER
BUFFER:	DS	1
;
	END	START
