;Alan R. Miller, Programmieren mit CP/M, 1984 SYBEX-Verlag GmbH Duesseldorf
;Abb. 3.5: S. 65ff Programm zum Auffinden des DTR-Bits

TITLE	'Anzeige eines I/O Ports in binaer'
	;(Tagesdatum)
	ORG 100H
;
PORT	EQU	5       ;Status-Port
BDOS    EQU     5
TYPEF   EQU     2 	;Konsole-Ausgabe
CSTATF  EQU     11     	;Konsole-Status
CR      EQU     13   	;Cursor Zeilenanfang
LF      EQU     10      ;Cursor naechste Zeile
;
START:
	LXI	SP,STACK
	IN	PORT	;lesen
	MOV	H,A	;retten
	CALL	BITS	;Anzeige binaer
NEXT:
	IN    	PORT 	;naechste Eingabe
	MOV     L,A	;retten
	CMP     H	;Unterschied?
	JNZ     SHOW	;ja
	PUSH  	H
	MVI	C,CSTATF;Konsol-Status
	CALL  	BDOS
	POP	H
	RRC		;teste Bit 0
	JC 	0	;Programmende
	JMP     NEXT
;
SHOW:
	CALL	BITS	;Anzeige binaer
	MOV	H,L	;umschalten
	JMP	NEXT
;
BITS:			;konvertiere binaer nach ASCII
	MOV	C,A
	MVI	B,8	;8 Bits
BIT2:
	MOV	A,C
	ADD	A	;shift links
	MOV	C,A
	MVI     A,0 	;null
	ACI     '0'   	;Carry + ASCII 0
	CALL    OUTT
	DCR     B   	;zaehlen
	JNZ     BIT2	;8mal
CRLF:			;neue Zeile
	MVI	A,CR
	CALL    OUTT
	MVI     A,LF
OUTT:			;Konsol-Ausgabe
	PUSH	H
	PUSH    B
	PUSH    PSW
	MVI     C,TYPEF	;Konsol-Ausgabe
	MOV     E,A
	CALL    BDOS
	POP     PSW
	POP     B
	POP     H
	RET
	DS	12	;Stack
STACK:
	END	START
